/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.data;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.resources.data.AnimationFrame;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class AnimationMetadataSection
implements IMetadataSection {
    private final List<AnimationFrame> animationFrames;
    private final int frameWidth;
    private final int frameHeight;
    private final int frameTime;
    private final boolean interpolate;

    public AnimationMetadataSection(List<AnimationFrame> p_i46088_1_, int p_i46088_2_, int p_i46088_3_, int p_i46088_4_, boolean p_i46088_5_) {
        this.animationFrames = p_i46088_1_;
        this.frameWidth = p_i46088_2_;
        this.frameHeight = p_i46088_3_;
        this.frameTime = p_i46088_4_;
        this.interpolate = p_i46088_5_;
    }

    public int getFrameHeight() {
        return this.frameHeight;
    }

    public int getFrameWidth() {
        return this.frameWidth;
    }

    public int getFrameCount() {
        return this.animationFrames.size();
    }

    public int getFrameTime() {
        return this.frameTime;
    }

    public boolean isInterpolate() {
        return this.interpolate;
    }

    private AnimationFrame getAnimationFrame(int p_getAnimationFrame_1_) {
        return this.animationFrames.get(p_getAnimationFrame_1_);
    }

    public int getFrameTimeSingle(int p_getFrameTimeSingle_1_) {
        AnimationFrame lvt_2_1_ = this.getAnimationFrame(p_getFrameTimeSingle_1_);
        if (lvt_2_1_.hasNoTime()) {
            return this.frameTime;
        }
        return lvt_2_1_.getFrameTime();
    }

    public boolean frameHasTime(int p_frameHasTime_1_) {
        return !this.animationFrames.get(p_frameHasTime_1_).hasNoTime();
    }

    public int getFrameIndex(int p_getFrameIndex_1_) {
        return this.animationFrames.get(p_getFrameIndex_1_).getFrameIndex();
    }

    public Set<Integer> getFrameIndexSet() {
        HashSet lvt_1_1_ = Sets.newHashSet();
        for (AnimationFrame lvt_3_1_ : this.animationFrames) {
            lvt_1_1_.add(lvt_3_1_.getFrameIndex());
        }
        return lvt_1_1_;
    }
}

