/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.data;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import net.minecraft.client.resources.data.AnimationFrame;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.client.resources.data.BaseMetadataSectionSerializer;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.Validate;

@SideOnly(value=Side.CLIENT)
public class AnimationMetadataSectionSerializer
extends BaseMetadataSectionSerializer<AnimationMetadataSection>
implements JsonSerializer<AnimationMetadataSection> {
    public AnimationMetadataSection deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
        ArrayList lvt_4_1_ = Lists.newArrayList();
        JsonObject lvt_5_1_ = JsonUtils.getJsonObject(p_deserialize_1_, "metadata section");
        int lvt_6_1_ = JsonUtils.getInt(lvt_5_1_, "frametime", 1);
        if (lvt_6_1_ != 1) {
            Validate.inclusiveBetween((long)1L, (long)Integer.MAX_VALUE, (long)lvt_6_1_, (String)"Invalid default frame time");
        }
        if (lvt_5_1_.has("frames")) {
            try {
                JsonArray lvt_7_1_ = JsonUtils.getJsonArray(lvt_5_1_, "frames");
                for (int lvt_8_1_ = 0; lvt_8_1_ < lvt_7_1_.size(); ++lvt_8_1_) {
                    JsonElement lvt_9_1_ = lvt_7_1_.get(lvt_8_1_);
                    AnimationFrame lvt_10_1_ = this.parseAnimationFrame(lvt_8_1_, lvt_9_1_);
                    if (lvt_10_1_ == null) continue;
                    lvt_4_1_.add(lvt_10_1_);
                }
            }
            catch (ClassCastException lvt_7_2_) {
                throw new JsonParseException("Invalid animation->frames: expected array, was " + lvt_5_1_.get("frames"), (Throwable)lvt_7_2_);
            }
        }
        int lvt_7_3_ = JsonUtils.getInt(lvt_5_1_, "width", -1);
        int lvt_8_2_ = JsonUtils.getInt(lvt_5_1_, "height", -1);
        if (lvt_7_3_ != -1) {
            Validate.inclusiveBetween((long)1L, (long)Integer.MAX_VALUE, (long)lvt_7_3_, (String)"Invalid width");
        }
        if (lvt_8_2_ != -1) {
            Validate.inclusiveBetween((long)1L, (long)Integer.MAX_VALUE, (long)lvt_8_2_, (String)"Invalid height");
        }
        boolean lvt_9_2_ = JsonUtils.getBoolean(lvt_5_1_, "interpolate", false);
        return new AnimationMetadataSection(lvt_4_1_, lvt_7_3_, lvt_8_2_, lvt_6_1_, lvt_9_2_);
    }

    private AnimationFrame parseAnimationFrame(int p_parseAnimationFrame_1_, JsonElement p_parseAnimationFrame_2_) {
        if (p_parseAnimationFrame_2_.isJsonPrimitive()) {
            return new AnimationFrame(JsonUtils.getInt(p_parseAnimationFrame_2_, "frames[" + p_parseAnimationFrame_1_ + "]"));
        }
        if (p_parseAnimationFrame_2_.isJsonObject()) {
            JsonObject lvt_3_1_ = JsonUtils.getJsonObject(p_parseAnimationFrame_2_, "frames[" + p_parseAnimationFrame_1_ + "]");
            int lvt_4_1_ = JsonUtils.getInt(lvt_3_1_, "time", -1);
            if (lvt_3_1_.has("time")) {
                Validate.inclusiveBetween((long)1L, (long)Integer.MAX_VALUE, (long)lvt_4_1_, (String)"Invalid frame time");
            }
            int lvt_5_1_ = JsonUtils.getInt(lvt_3_1_, "index");
            Validate.inclusiveBetween((long)0L, (long)Integer.MAX_VALUE, (long)lvt_5_1_, (String)"Invalid frame index");
            return new AnimationFrame(lvt_5_1_, lvt_4_1_);
        }
        return null;
    }

    public JsonElement serialize(AnimationMetadataSection p_serialize_1_, Type p_serialize_2_, JsonSerializationContext p_serialize_3_) {
        JsonObject lvt_4_1_ = new JsonObject();
        lvt_4_1_.addProperty("frametime", (Number)p_serialize_1_.getFrameTime());
        if (p_serialize_1_.getFrameWidth() != -1) {
            lvt_4_1_.addProperty("width", (Number)p_serialize_1_.getFrameWidth());
        }
        if (p_serialize_1_.getFrameHeight() != -1) {
            lvt_4_1_.addProperty("height", (Number)p_serialize_1_.getFrameHeight());
        }
        if (p_serialize_1_.getFrameCount() > 0) {
            JsonArray lvt_5_1_ = new JsonArray();
            for (int lvt_6_1_ = 0; lvt_6_1_ < p_serialize_1_.getFrameCount(); ++lvt_6_1_) {
                if (p_serialize_1_.frameHasTime(lvt_6_1_)) {
                    JsonObject lvt_7_1_ = new JsonObject();
                    lvt_7_1_.addProperty("index", (Number)p_serialize_1_.getFrameIndex(lvt_6_1_));
                    lvt_7_1_.addProperty("time", (Number)p_serialize_1_.getFrameTimeSingle(lvt_6_1_));
                    lvt_5_1_.add((JsonElement)lvt_7_1_);
                    continue;
                }
                lvt_5_1_.add((JsonElement)new JsonPrimitive((Number)p_serialize_1_.getFrameIndex(lvt_6_1_)));
            }
            lvt_4_1_.add("frames", (JsonElement)lvt_5_1_);
        }
        return lvt_4_1_;
    }

    @Override
    public String getSectionName() {
        return "animation";
    }

    public /* synthetic */ Object deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
        return this.deserialize(p_deserialize_1_, p_deserialize_2_, p_deserialize_3_);
    }

    public /* synthetic */ JsonElement serialize(Object p_serialize_1_, Type p_serialize_2_, JsonSerializationContext p_serialize_3_) {
        return this.serialize((AnimationMetadataSection)p_serialize_1_, p_serialize_2_, p_serialize_3_);
    }
}

