/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapterFactory;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.client.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.EnumTypeAdapterFactory;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.util.registry.RegistrySimple;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MetadataSerializer {
    private final IRegistry<String, Registration<? extends IMetadataSection>> metadataSectionSerializerRegistry = new RegistrySimple<String, Registration<? extends IMetadataSection>>();
    private final GsonBuilder gsonBuilder = new GsonBuilder();
    private Gson gson;

    public MetadataSerializer() {
        this.gsonBuilder.registerTypeHierarchyAdapter(ITextComponent.class, (Object)new ITextComponent.Serializer());
        this.gsonBuilder.registerTypeHierarchyAdapter(Style.class, (Object)new Style.Serializer());
        this.gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new EnumTypeAdapterFactory());
    }

    public <T extends IMetadataSection> void registerMetadataSectionType(IMetadataSectionSerializer<T> p_registerMetadataSectionType_1_, Class<T> p_registerMetadataSectionType_2_) {
        this.metadataSectionSerializerRegistry.putObject(p_registerMetadataSectionType_1_.getSectionName(), new Registration(p_registerMetadataSectionType_1_, p_registerMetadataSectionType_2_));
        this.gsonBuilder.registerTypeAdapter(p_registerMetadataSectionType_2_, p_registerMetadataSectionType_1_);
        this.gson = null;
    }

    public <T extends IMetadataSection> T parseMetadataSection(String p_parseMetadataSection_1_, JsonObject p_parseMetadataSection_2_) {
        if (p_parseMetadataSection_1_ == null) {
            throw new IllegalArgumentException("Metadata section name cannot be null");
        }
        if (!p_parseMetadataSection_2_.has(p_parseMetadataSection_1_)) {
            return null;
        }
        if (!p_parseMetadataSection_2_.get(p_parseMetadataSection_1_).isJsonObject()) {
            throw new IllegalArgumentException("Invalid metadata for '" + p_parseMetadataSection_1_ + "' - expected object, found " + p_parseMetadataSection_2_.get(p_parseMetadataSection_1_));
        }
        Registration<? extends IMetadataSection> lvt_3_1_ = this.metadataSectionSerializerRegistry.getObject(p_parseMetadataSection_1_);
        if (lvt_3_1_ == null) {
            throw new IllegalArgumentException("Don't know how to handle metadata section '" + p_parseMetadataSection_1_ + "'");
        }
        return (T)((IMetadataSection)this.getGson().fromJson((JsonElement)p_parseMetadataSection_2_.getAsJsonObject(p_parseMetadataSection_1_), lvt_3_1_.clazz));
    }

    private Gson getGson() {
        if (this.gson == null) {
            this.gson = this.gsonBuilder.create();
        }
        return this.gson;
    }

    @SideOnly(value=Side.CLIENT)
    class Registration<T extends IMetadataSection> {
        final IMetadataSectionSerializer<T> section;
        final Class<T> clazz;

        private Registration(IMetadataSectionSerializer<T> p_i1305_2_, Class<T> p_i1305_3_) {
            this.section = p_i1305_2_;
            this.clazz = p_i1305_3_;
        }
    }
}

