/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.settings;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.play.client.CPacketClientSettings;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;

@SideOnly(value=Side.CLIENT)
public class GameSettings {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new Gson();
    private static final Type TYPE_LIST_STRING = new ParameterizedType(){

        @Override
        public Type[] getActualTypeArguments() {
            return new Type[]{String.class};
        }

        @Override
        public Type getRawType() {
            return List.class;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }
    };
    public static final Splitter COLON_SPLITTER = Splitter.on((char)':');
    private static final String[] GUISCALES = new String[]{"options.guiScale.auto", "options.guiScale.small", "options.guiScale.normal", "options.guiScale.large"};
    private static final String[] PARTICLES = new String[]{"options.particles.all", "options.particles.decreased", "options.particles.minimal"};
    private static final String[] AMBIENT_OCCLUSIONS = new String[]{"options.ao.off", "options.ao.min", "options.ao.max"};
    private static final String[] CLOUDS_TYPES = new String[]{"options.off", "options.graphics.fast", "options.graphics.fancy"};
    private static final String[] ATTACK_INDICATORS = new String[]{"options.off", "options.attack.crosshair", "options.attack.hotbar"};
    public float mouseSensitivity = 0.5f;
    public boolean invertMouse;
    public int renderDistanceChunks = -1;
    public boolean viewBobbing = true;
    public boolean anaglyph;
    public boolean fboEnable = true;
    public int limitFramerate = 120;
    public int clouds = 2;
    public boolean fancyGraphics = true;
    public int ambientOcclusion = 2;
    public List<String> resourcePacks = Lists.newArrayList();
    public List<String> incompatibleResourcePacks = Lists.newArrayList();
    public EntityPlayer.EnumChatVisibility chatVisibility = EntityPlayer.EnumChatVisibility.FULL;
    public boolean chatColours = true;
    public boolean chatLinks = true;
    public boolean chatLinksPrompt = true;
    public float chatOpacity = 1.0f;
    public boolean snooperEnabled = true;
    public boolean fullScreen;
    public boolean enableVsync = true;
    public boolean useVbo = true;
    public boolean reducedDebugInfo;
    public boolean hideServerAddress;
    public boolean advancedItemTooltips;
    public boolean pauseOnLostFocus = true;
    private final Set<EnumPlayerModelParts> setModelParts = Sets.newHashSet((Object[])EnumPlayerModelParts.values());
    public boolean touchscreen;
    public EnumHandSide mainHand = EnumHandSide.RIGHT;
    public int overrideWidth;
    public int overrideHeight;
    public boolean heldItemTooltips = true;
    public float chatScale = 1.0f;
    public float chatWidth = 1.0f;
    public float chatHeightUnfocused = 0.44366196f;
    public float chatHeightFocused = 1.0f;
    public boolean showInventoryAchievementHint = true;
    public int mipmapLevels = 4;
    private final Map<SoundCategory, Float> soundLevels = Maps.newEnumMap(SoundCategory.class);
    public boolean useNativeTransport = true;
    public boolean entityShadows = true;
    public int attackIndicator = 1;
    public boolean enableWeakAttacks;
    public boolean showSubtitles;
    public boolean realmsNotifications = true;
    public boolean autoJump = true;
    public KeyBinding keyBindForward = new KeyBinding("key.forward", 17, "key.categories.movement");
    public KeyBinding keyBindLeft = new KeyBinding("key.left", 30, "key.categories.movement");
    public KeyBinding keyBindBack = new KeyBinding("key.back", 31, "key.categories.movement");
    public KeyBinding keyBindRight = new KeyBinding("key.right", 32, "key.categories.movement");
    public KeyBinding keyBindJump = new KeyBinding("key.jump", 57, "key.categories.movement");
    public KeyBinding keyBindSneak = new KeyBinding("key.sneak", 42, "key.categories.movement");
    public KeyBinding keyBindSprint = new KeyBinding("key.sprint", 29, "key.categories.movement");
    public KeyBinding keyBindInventory = new KeyBinding("key.inventory", 18, "key.categories.inventory");
    public KeyBinding keyBindSwapHands = new KeyBinding("key.swapHands", 33, "key.categories.inventory");
    public KeyBinding keyBindDrop = new KeyBinding("key.drop", 16, "key.categories.inventory");
    public KeyBinding keyBindUseItem = new KeyBinding("key.use", -99, "key.categories.gameplay");
    public KeyBinding keyBindAttack = new KeyBinding("key.attack", -100, "key.categories.gameplay");
    public KeyBinding keyBindPickBlock = new KeyBinding("key.pickItem", -98, "key.categories.gameplay");
    public KeyBinding keyBindChat = new KeyBinding("key.chat", 20, "key.categories.multiplayer");
    public KeyBinding keyBindPlayerList = new KeyBinding("key.playerlist", 15, "key.categories.multiplayer");
    public KeyBinding keyBindCommand = new KeyBinding("key.command", 53, "key.categories.multiplayer");
    public KeyBinding keyBindScreenshot = new KeyBinding("key.screenshot", 60, "key.categories.misc");
    public KeyBinding keyBindTogglePerspective = new KeyBinding("key.togglePerspective", 63, "key.categories.misc");
    public KeyBinding keyBindSmoothCamera = new KeyBinding("key.smoothCamera", 0, "key.categories.misc");
    public KeyBinding keyBindFullscreen = new KeyBinding("key.fullscreen", 87, "key.categories.misc");
    public KeyBinding keyBindSpectatorOutlines = new KeyBinding("key.spectatorOutlines", 0, "key.categories.misc");
    public KeyBinding[] keyBindsHotbar = new KeyBinding[]{new KeyBinding("key.hotbar.1", 2, "key.categories.inventory"), new KeyBinding("key.hotbar.2", 3, "key.categories.inventory"), new KeyBinding("key.hotbar.3", 4, "key.categories.inventory"), new KeyBinding("key.hotbar.4", 5, "key.categories.inventory"), new KeyBinding("key.hotbar.5", 6, "key.categories.inventory"), new KeyBinding("key.hotbar.6", 7, "key.categories.inventory"), new KeyBinding("key.hotbar.7", 8, "key.categories.inventory"), new KeyBinding("key.hotbar.8", 9, "key.categories.inventory"), new KeyBinding("key.hotbar.9", 10, "key.categories.inventory")};
    public KeyBinding[] keyBindings;
    protected Minecraft mc;
    private File optionsFile;
    public EnumDifficulty difficulty;
    public boolean hideGUI;
    public int thirdPersonView;
    public boolean showDebugInfo;
    public boolean showDebugProfilerChart;
    public boolean showLagometer;
    public String lastServer;
    public boolean smoothCamera;
    public boolean debugCamEnable;
    public float fovSetting;
    public float gammaSetting;
    public float saturation;
    public int guiScale;
    public int particleSetting;
    public String language;
    public boolean forceUnicodeFont;
    private boolean needsResourceRefresh = false;

    public GameSettings(Minecraft p_i46326_1_, File p_i46326_2_) {
        this.setForgeKeybindProperties();
        this.keyBindings = (KeyBinding[])ArrayUtils.addAll((Object[])new KeyBinding[]{this.keyBindAttack, this.keyBindUseItem, this.keyBindForward, this.keyBindLeft, this.keyBindBack, this.keyBindRight, this.keyBindJump, this.keyBindSneak, this.keyBindSprint, this.keyBindDrop, this.keyBindInventory, this.keyBindChat, this.keyBindPlayerList, this.keyBindPickBlock, this.keyBindCommand, this.keyBindScreenshot, this.keyBindTogglePerspective, this.keyBindSmoothCamera, this.keyBindFullscreen, this.keyBindSpectatorOutlines, this.keyBindSwapHands}, (Object[])this.keyBindsHotbar);
        this.difficulty = EnumDifficulty.NORMAL;
        this.lastServer = "";
        this.fovSetting = 70.0f;
        this.language = "en_us";
        this.mc = p_i46326_1_;
        this.optionsFile = new File(p_i46326_2_, "options.txt");
        if (p_i46326_1_.isJava64bit() && Runtime.getRuntime().maxMemory() >= 1000000000L) {
            Options.RENDER_DISTANCE.setValueMax(32.0f);
        } else {
            Options.RENDER_DISTANCE.setValueMax(16.0f);
        }
        this.renderDistanceChunks = p_i46326_1_.isJava64bit() ? 12 : 8;
        this.loadOptions();
    }

    public GameSettings() {
        this.setForgeKeybindProperties();
        this.keyBindings = (KeyBinding[])ArrayUtils.addAll((Object[])new KeyBinding[]{this.keyBindAttack, this.keyBindUseItem, this.keyBindForward, this.keyBindLeft, this.keyBindBack, this.keyBindRight, this.keyBindJump, this.keyBindSneak, this.keyBindSprint, this.keyBindDrop, this.keyBindInventory, this.keyBindChat, this.keyBindPlayerList, this.keyBindPickBlock, this.keyBindCommand, this.keyBindScreenshot, this.keyBindTogglePerspective, this.keyBindSmoothCamera, this.keyBindFullscreen, this.keyBindSpectatorOutlines, this.keyBindSwapHands}, (Object[])this.keyBindsHotbar);
        this.difficulty = EnumDifficulty.NORMAL;
        this.lastServer = "";
        this.fovSetting = 70.0f;
        this.language = "en_us";
    }

    public static String getKeyDisplayString(int p_getKeyDisplayString_0_) {
        return p_getKeyDisplayString_0_ < 0 ? I18n.format("key.mouseButton", p_getKeyDisplayString_0_ + 101) : (p_getKeyDisplayString_0_ < 256 ? Keyboard.getKeyName((int)p_getKeyDisplayString_0_) : String.format("%c", Character.valueOf((char)(p_getKeyDisplayString_0_ - 256))).toUpperCase());
    }

    public static boolean isKeyDown(KeyBinding p_isKeyDown_0_) {
        int i = p_isKeyDown_0_.getKeyCode();
        return i != 0 && i < 256 ? (i < 0 ? Mouse.isButtonDown((int)(i + 100)) : Keyboard.isKeyDown((int)i)) : false;
    }

    public void setOptionKeyBinding(KeyBinding p_setOptionKeyBinding_1_, int p_setOptionKeyBinding_2_) {
        p_setOptionKeyBinding_1_.setKeyCode(p_setOptionKeyBinding_2_);
        this.saveOptions();
    }

    public void setOptionFloatValue(Options p_setOptionFloatValue_1_, float p_setOptionFloatValue_2_) {
        if (p_setOptionFloatValue_1_ == Options.SENSITIVITY) {
            this.mouseSensitivity = p_setOptionFloatValue_2_;
        }
        if (p_setOptionFloatValue_1_ == Options.FOV) {
            this.fovSetting = p_setOptionFloatValue_2_;
        }
        if (p_setOptionFloatValue_1_ == Options.GAMMA) {
            this.gammaSetting = p_setOptionFloatValue_2_;
        }
        if (p_setOptionFloatValue_1_ == Options.FRAMERATE_LIMIT) {
            this.limitFramerate = (int)p_setOptionFloatValue_2_;
        }
        if (p_setOptionFloatValue_1_ == Options.CHAT_OPACITY) {
            this.chatOpacity = p_setOptionFloatValue_2_;
            this.mc.ingameGUI.getChatGUI().refreshChat();
        }
        if (p_setOptionFloatValue_1_ == Options.CHAT_HEIGHT_FOCUSED) {
            this.chatHeightFocused = p_setOptionFloatValue_2_;
            this.mc.ingameGUI.getChatGUI().refreshChat();
        }
        if (p_setOptionFloatValue_1_ == Options.CHAT_HEIGHT_UNFOCUSED) {
            this.chatHeightUnfocused = p_setOptionFloatValue_2_;
            this.mc.ingameGUI.getChatGUI().refreshChat();
        }
        if (p_setOptionFloatValue_1_ == Options.CHAT_WIDTH) {
            this.chatWidth = p_setOptionFloatValue_2_;
            this.mc.ingameGUI.getChatGUI().refreshChat();
        }
        if (p_setOptionFloatValue_1_ == Options.CHAT_SCALE) {
            this.chatScale = p_setOptionFloatValue_2_;
            this.mc.ingameGUI.getChatGUI().refreshChat();
        }
        if (p_setOptionFloatValue_1_ == Options.MIPMAP_LEVELS) {
            int i = this.mipmapLevels;
            this.mipmapLevels = (int)p_setOptionFloatValue_2_;
            if ((float)i != p_setOptionFloatValue_2_) {
                this.mc.getTextureMapBlocks().setMipmapLevels(this.mipmapLevels);
                this.mc.getTextureManager().bindTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
                this.mc.getTextureMapBlocks().setBlurMipmapDirect(false, this.mipmapLevels > 0);
                this.needsResourceRefresh = true;
            }
        }
        if (p_setOptionFloatValue_1_ == Options.RENDER_DISTANCE) {
            this.renderDistanceChunks = (int)p_setOptionFloatValue_2_;
            this.mc.renderGlobal.setDisplayListEntitiesDirty();
        }
    }

    public void setOptionValue(Options p_setOptionValue_1_, int p_setOptionValue_2_) {
        if (p_setOptionValue_1_ == Options.RENDER_DISTANCE) {
            this.setOptionFloatValue(p_setOptionValue_1_, MathHelper.clamp((float)(this.renderDistanceChunks + p_setOptionValue_2_), p_setOptionValue_1_.getValueMin(), p_setOptionValue_1_.getValueMax()));
        }
        if (p_setOptionValue_1_ == Options.MAIN_HAND) {
            this.mainHand = this.mainHand.opposite();
        }
        if (p_setOptionValue_1_ == Options.INVERT_MOUSE) {
            boolean bl = this.invertMouse = !this.invertMouse;
        }
        if (p_setOptionValue_1_ == Options.GUI_SCALE) {
            this.guiScale = this.guiScale + p_setOptionValue_2_ & 3;
        }
        if (p_setOptionValue_1_ == Options.PARTICLES) {
            this.particleSetting = (this.particleSetting + p_setOptionValue_2_) % 3;
        }
        if (p_setOptionValue_1_ == Options.VIEW_BOBBING) {
            boolean bl = this.viewBobbing = !this.viewBobbing;
        }
        if (p_setOptionValue_1_ == Options.RENDER_CLOUDS) {
            this.clouds = (this.clouds + p_setOptionValue_2_) % 3;
        }
        if (p_setOptionValue_1_ == Options.FORCE_UNICODE_FONT) {
            this.forceUnicodeFont = !this.forceUnicodeFont;
            this.mc.fontRendererObj.setUnicodeFlag(this.mc.getLanguageManager().isCurrentLocaleUnicode() || this.forceUnicodeFont);
        }
        if (p_setOptionValue_1_ == Options.FBO_ENABLE) {
            boolean bl = this.fboEnable = !this.fboEnable;
        }
        if (p_setOptionValue_1_ == Options.ANAGLYPH) {
            this.anaglyph = !this.anaglyph;
            this.mc.refreshResources();
        }
        if (p_setOptionValue_1_ == Options.GRAPHICS) {
            this.fancyGraphics = !this.fancyGraphics;
            this.mc.renderGlobal.loadRenderers();
        }
        if (p_setOptionValue_1_ == Options.AMBIENT_OCCLUSION) {
            this.ambientOcclusion = (this.ambientOcclusion + p_setOptionValue_2_) % 3;
            this.mc.renderGlobal.loadRenderers();
        }
        if (p_setOptionValue_1_ == Options.CHAT_VISIBILITY) {
            this.chatVisibility = EntityPlayer.EnumChatVisibility.getEnumChatVisibility((this.chatVisibility.getChatVisibility() + p_setOptionValue_2_) % 3);
        }
        if (p_setOptionValue_1_ == Options.CHAT_COLOR) {
            boolean bl = this.chatColours = !this.chatColours;
        }
        if (p_setOptionValue_1_ == Options.CHAT_LINKS) {
            boolean bl = this.chatLinks = !this.chatLinks;
        }
        if (p_setOptionValue_1_ == Options.CHAT_LINKS_PROMPT) {
            boolean bl = this.chatLinksPrompt = !this.chatLinksPrompt;
        }
        if (p_setOptionValue_1_ == Options.SNOOPER_ENABLED) {
            boolean bl = this.snooperEnabled = !this.snooperEnabled;
        }
        if (p_setOptionValue_1_ == Options.TOUCHSCREEN) {
            boolean bl = this.touchscreen = !this.touchscreen;
        }
        if (p_setOptionValue_1_ == Options.USE_FULLSCREEN) {
            boolean bl = this.fullScreen = !this.fullScreen;
            if (this.mc.isFullScreen() != this.fullScreen) {
                this.mc.toggleFullscreen();
            }
        }
        if (p_setOptionValue_1_ == Options.ENABLE_VSYNC) {
            this.enableVsync = !this.enableVsync;
            Display.setVSyncEnabled((boolean)this.enableVsync);
        }
        if (p_setOptionValue_1_ == Options.USE_VBO) {
            this.useVbo = !this.useVbo;
            this.mc.renderGlobal.loadRenderers();
        }
        if (p_setOptionValue_1_ == Options.REDUCED_DEBUG_INFO) {
            boolean bl = this.reducedDebugInfo = !this.reducedDebugInfo;
        }
        if (p_setOptionValue_1_ == Options.ENTITY_SHADOWS) {
            boolean bl = this.entityShadows = !this.entityShadows;
        }
        if (p_setOptionValue_1_ == Options.ATTACK_INDICATOR) {
            this.attackIndicator = (this.attackIndicator + p_setOptionValue_2_) % 3;
        }
        if (p_setOptionValue_1_ == Options.SHOW_SUBTITLES) {
            boolean bl = this.showSubtitles = !this.showSubtitles;
        }
        if (p_setOptionValue_1_ == Options.REALMS_NOTIFICATIONS) {
            boolean bl = this.realmsNotifications = !this.realmsNotifications;
        }
        if (p_setOptionValue_1_ == Options.AUTO_JUMP) {
            this.autoJump = !this.autoJump;
        }
        this.saveOptions();
    }

    public float getOptionFloatValue(Options p_getOptionFloatValue_1_) {
        return p_getOptionFloatValue_1_ == Options.FOV ? this.fovSetting : (p_getOptionFloatValue_1_ == Options.GAMMA ? this.gammaSetting : (p_getOptionFloatValue_1_ == Options.SATURATION ? this.saturation : (p_getOptionFloatValue_1_ == Options.SENSITIVITY ? this.mouseSensitivity : (p_getOptionFloatValue_1_ == Options.CHAT_OPACITY ? this.chatOpacity : (p_getOptionFloatValue_1_ == Options.CHAT_HEIGHT_FOCUSED ? this.chatHeightFocused : (p_getOptionFloatValue_1_ == Options.CHAT_HEIGHT_UNFOCUSED ? this.chatHeightUnfocused : (p_getOptionFloatValue_1_ == Options.CHAT_SCALE ? this.chatScale : (p_getOptionFloatValue_1_ == Options.CHAT_WIDTH ? this.chatWidth : (p_getOptionFloatValue_1_ == Options.FRAMERATE_LIMIT ? (float)this.limitFramerate : (p_getOptionFloatValue_1_ == Options.MIPMAP_LEVELS ? (float)this.mipmapLevels : (p_getOptionFloatValue_1_ == Options.RENDER_DISTANCE ? (float)this.renderDistanceChunks : 0.0f)))))))))));
    }

    public boolean getOptionOrdinalValue(Options p_getOptionOrdinalValue_1_) {
        switch (p_getOptionOrdinalValue_1_) {
            case INVERT_MOUSE: {
                return this.invertMouse;
            }
            case VIEW_BOBBING: {
                return this.viewBobbing;
            }
            case ANAGLYPH: {
                return this.anaglyph;
            }
            case FBO_ENABLE: {
                return this.fboEnable;
            }
            case CHAT_COLOR: {
                return this.chatColours;
            }
            case CHAT_LINKS: {
                return this.chatLinks;
            }
            case CHAT_LINKS_PROMPT: {
                return this.chatLinksPrompt;
            }
            case SNOOPER_ENABLED: {
                return this.snooperEnabled;
            }
            case USE_FULLSCREEN: {
                return this.fullScreen;
            }
            case ENABLE_VSYNC: {
                return this.enableVsync;
            }
            case USE_VBO: {
                return this.useVbo;
            }
            case TOUCHSCREEN: {
                return this.touchscreen;
            }
            case FORCE_UNICODE_FONT: {
                return this.forceUnicodeFont;
            }
            case REDUCED_DEBUG_INFO: {
                return this.reducedDebugInfo;
            }
            case ENTITY_SHADOWS: {
                return this.entityShadows;
            }
            case SHOW_SUBTITLES: {
                return this.showSubtitles;
            }
            case REALMS_NOTIFICATIONS: {
                return this.realmsNotifications;
            }
            case ENABLE_WEAK_ATTACKS: {
                return this.enableWeakAttacks;
            }
            case AUTO_JUMP: {
                return this.autoJump;
            }
        }
        return false;
    }

    private static String getTranslation(String[] p_getTranslation_0_, int p_getTranslation_1_) {
        if (p_getTranslation_1_ < 0 || p_getTranslation_1_ >= p_getTranslation_0_.length) {
            p_getTranslation_1_ = 0;
        }
        return I18n.format(p_getTranslation_0_[p_getTranslation_1_], new Object[0]);
    }

    public String getKeyBinding(Options p_getKeyBinding_1_) {
        String s = I18n.format(p_getKeyBinding_1_.getEnumString(), new Object[0]) + ": ";
        if (p_getKeyBinding_1_.getEnumFloat()) {
            float f1 = this.getOptionFloatValue(p_getKeyBinding_1_);
            float f = p_getKeyBinding_1_.normalizeValue(f1);
            return p_getKeyBinding_1_ == Options.SENSITIVITY ? (f == 0.0f ? s + I18n.format("options.sensitivity.min", new Object[0]) : (f == 1.0f ? s + I18n.format("options.sensitivity.max", new Object[0]) : s + (int)(f * 200.0f) + "%")) : (p_getKeyBinding_1_ == Options.FOV ? (f1 == 70.0f ? s + I18n.format("options.fov.min", new Object[0]) : (f1 == 110.0f ? s + I18n.format("options.fov.max", new Object[0]) : s + (int)f1)) : (p_getKeyBinding_1_ == Options.FRAMERATE_LIMIT ? (f1 == p_getKeyBinding_1_.valueMax ? s + I18n.format("options.framerateLimit.max", new Object[0]) : s + I18n.format("options.framerate", (int)f1)) : (p_getKeyBinding_1_ == Options.RENDER_CLOUDS ? (f1 == p_getKeyBinding_1_.valueMin ? s + I18n.format("options.cloudHeight.min", new Object[0]) : s + ((int)f1 + 128)) : (p_getKeyBinding_1_ == Options.GAMMA ? (f == 0.0f ? s + I18n.format("options.gamma.min", new Object[0]) : (f == 1.0f ? s + I18n.format("options.gamma.max", new Object[0]) : s + "+" + (int)(f * 100.0f) + "%")) : (p_getKeyBinding_1_ == Options.SATURATION ? s + (int)(f * 400.0f) + "%" : (p_getKeyBinding_1_ == Options.CHAT_OPACITY ? s + (int)(f * 90.0f + 10.0f) + "%" : (p_getKeyBinding_1_ == Options.CHAT_HEIGHT_UNFOCUSED ? s + GuiNewChat.calculateChatboxHeight(f) + "px" : (p_getKeyBinding_1_ == Options.CHAT_HEIGHT_FOCUSED ? s + GuiNewChat.calculateChatboxHeight(f) + "px" : (p_getKeyBinding_1_ == Options.CHAT_WIDTH ? s + GuiNewChat.calculateChatboxWidth(f) + "px" : (p_getKeyBinding_1_ == Options.RENDER_DISTANCE ? s + I18n.format("options.chunks", (int)f1) : (p_getKeyBinding_1_ == Options.MIPMAP_LEVELS ? (f1 == 0.0f ? s + I18n.format("options.off", new Object[0]) : s + (int)f1) : (f == 0.0f ? s + I18n.format("options.off", new Object[0]) : s + (int)(f * 100.0f) + "%"))))))))))));
        }
        if (p_getKeyBinding_1_.getEnumBoolean()) {
            boolean flag = this.getOptionOrdinalValue(p_getKeyBinding_1_);
            return flag ? s + I18n.format("options.on", new Object[0]) : s + I18n.format("options.off", new Object[0]);
        }
        if (p_getKeyBinding_1_ == Options.MAIN_HAND) {
            return s + (Object)((Object)this.mainHand);
        }
        if (p_getKeyBinding_1_ == Options.GUI_SCALE) {
            return s + GameSettings.getTranslation(GUISCALES, this.guiScale);
        }
        if (p_getKeyBinding_1_ == Options.CHAT_VISIBILITY) {
            return s + I18n.format(this.chatVisibility.getResourceKey(), new Object[0]);
        }
        if (p_getKeyBinding_1_ == Options.PARTICLES) {
            return s + GameSettings.getTranslation(PARTICLES, this.particleSetting);
        }
        if (p_getKeyBinding_1_ == Options.AMBIENT_OCCLUSION) {
            return s + GameSettings.getTranslation(AMBIENT_OCCLUSIONS, this.ambientOcclusion);
        }
        if (p_getKeyBinding_1_ == Options.RENDER_CLOUDS) {
            return s + GameSettings.getTranslation(CLOUDS_TYPES, this.clouds);
        }
        if (p_getKeyBinding_1_ == Options.GRAPHICS) {
            if (this.fancyGraphics) {
                return s + I18n.format("options.graphics.fancy", new Object[0]);
            }
            String s1 = "options.graphics.fast";
            return s + I18n.format("options.graphics.fast", new Object[0]);
        }
        return p_getKeyBinding_1_ == Options.ATTACK_INDICATOR ? s + GameSettings.getTranslation(ATTACK_INDICATORS, this.attackIndicator) : s;
    }

    public void loadOptions() {
        try {
            if (!this.optionsFile.exists()) {
                return;
            }
            this.soundLevels.clear();
            List list = IOUtils.readLines((InputStream)new FileInputStream(this.optionsFile));
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            for (String s : list) {
                try {
                    Iterator iterator = COLON_SPLITTER.omitEmptyStrings().limit(2).split((CharSequence)s).iterator();
                    nbttagcompound.setString((String)iterator.next(), (String)iterator.next());
                }
                catch (Exception var10) {
                    LOGGER.warn("Skipping bad option: {}", new Object[]{s});
                }
            }
            nbttagcompound = this.dataFix(nbttagcompound);
            for (String s1 : nbttagcompound.getKeySet()) {
                String s2 = nbttagcompound.getString(s1);
                try {
                    if ("mouseSensitivity".equals(s1)) {
                        this.mouseSensitivity = this.parseFloat(s2);
                    }
                    if ("fov".equals(s1)) {
                        this.fovSetting = this.parseFloat(s2) * 40.0f + 70.0f;
                    }
                    if ("gamma".equals(s1)) {
                        this.gammaSetting = this.parseFloat(s2);
                    }
                    if ("saturation".equals(s1)) {
                        this.saturation = this.parseFloat(s2);
                    }
                    if ("invertYMouse".equals(s1)) {
                        this.invertMouse = "true".equals(s2);
                    }
                    if ("renderDistance".equals(s1)) {
                        this.renderDistanceChunks = Integer.parseInt(s2);
                    }
                    if ("guiScale".equals(s1)) {
                        this.guiScale = Integer.parseInt(s2);
                    }
                    if ("particles".equals(s1)) {
                        this.particleSetting = Integer.parseInt(s2);
                    }
                    if ("bobView".equals(s1)) {
                        this.viewBobbing = "true".equals(s2);
                    }
                    if ("anaglyph3d".equals(s1)) {
                        this.anaglyph = "true".equals(s2);
                    }
                    if ("maxFps".equals(s1)) {
                        this.limitFramerate = Integer.parseInt(s2);
                    }
                    if ("fboEnable".equals(s1)) {
                        this.fboEnable = "true".equals(s2);
                    }
                    if ("difficulty".equals(s1)) {
                        this.difficulty = EnumDifficulty.getDifficultyEnum(Integer.parseInt(s2));
                    }
                    if ("fancyGraphics".equals(s1)) {
                        this.fancyGraphics = "true".equals(s2);
                    }
                    if ("ao".equals(s1)) {
                        this.ambientOcclusion = "true".equals(s2) ? 2 : ("false".equals(s2) ? 0 : Integer.parseInt(s2));
                    }
                    if ("renderClouds".equals(s1)) {
                        if ("true".equals(s2)) {
                            this.clouds = 2;
                        } else if ("false".equals(s2)) {
                            this.clouds = 0;
                        } else if ("fast".equals(s2)) {
                            this.clouds = 1;
                        }
                    }
                    if ("attackIndicator".equals(s1)) {
                        if ("0".equals(s2)) {
                            this.attackIndicator = 0;
                        } else if ("1".equals(s2)) {
                            this.attackIndicator = 1;
                        } else if ("2".equals(s2)) {
                            this.attackIndicator = 2;
                        }
                    }
                    if ("resourcePacks".equals(s1)) {
                        this.resourcePacks = (List)GSON.fromJson(s2, TYPE_LIST_STRING);
                        if (this.resourcePacks == null) {
                            this.resourcePacks = Lists.newArrayList();
                        }
                    }
                    if ("incompatibleResourcePacks".equals(s1)) {
                        this.incompatibleResourcePacks = (List)GSON.fromJson(s2, TYPE_LIST_STRING);
                        if (this.incompatibleResourcePacks == null) {
                            this.incompatibleResourcePacks = Lists.newArrayList();
                        }
                    }
                    if ("lastServer".equals(s1)) {
                        this.lastServer = s2;
                    }
                    if ("lang".equals(s1)) {
                        this.language = s2;
                    }
                    if ("chatVisibility".equals(s1)) {
                        this.chatVisibility = EntityPlayer.EnumChatVisibility.getEnumChatVisibility(Integer.parseInt(s2));
                    }
                    if ("chatColors".equals(s1)) {
                        this.chatColours = "true".equals(s2);
                    }
                    if ("chatLinks".equals(s1)) {
                        this.chatLinks = "true".equals(s2);
                    }
                    if ("chatLinksPrompt".equals(s1)) {
                        this.chatLinksPrompt = "true".equals(s2);
                    }
                    if ("chatOpacity".equals(s1)) {
                        this.chatOpacity = this.parseFloat(s2);
                    }
                    if ("snooperEnabled".equals(s1)) {
                        this.snooperEnabled = "true".equals(s2);
                    }
                    if ("fullscreen".equals(s1)) {
                        this.fullScreen = "true".equals(s2);
                    }
                    if ("enableVsync".equals(s1)) {
                        this.enableVsync = "true".equals(s2);
                    }
                    if ("useVbo".equals(s1)) {
                        this.useVbo = "true".equals(s2);
                    }
                    if ("hideServerAddress".equals(s1)) {
                        this.hideServerAddress = "true".equals(s2);
                    }
                    if ("advancedItemTooltips".equals(s1)) {
                        this.advancedItemTooltips = "true".equals(s2);
                    }
                    if ("pauseOnLostFocus".equals(s1)) {
                        this.pauseOnLostFocus = "true".equals(s2);
                    }
                    if ("touchscreen".equals(s1)) {
                        this.touchscreen = "true".equals(s2);
                    }
                    if ("overrideHeight".equals(s1)) {
                        this.overrideHeight = Integer.parseInt(s2);
                    }
                    if ("overrideWidth".equals(s1)) {
                        this.overrideWidth = Integer.parseInt(s2);
                    }
                    if ("heldItemTooltips".equals(s1)) {
                        this.heldItemTooltips = "true".equals(s2);
                    }
                    if ("chatHeightFocused".equals(s1)) {
                        this.chatHeightFocused = this.parseFloat(s2);
                    }
                    if ("chatHeightUnfocused".equals(s1)) {
                        this.chatHeightUnfocused = this.parseFloat(s2);
                    }
                    if ("chatScale".equals(s1)) {
                        this.chatScale = this.parseFloat(s2);
                    }
                    if ("chatWidth".equals(s1)) {
                        this.chatWidth = this.parseFloat(s2);
                    }
                    if ("showInventoryAchievementHint".equals(s1)) {
                        this.showInventoryAchievementHint = "true".equals(s2);
                    }
                    if ("mipmapLevels".equals(s1)) {
                        this.mipmapLevels = Integer.parseInt(s2);
                    }
                    if ("forceUnicodeFont".equals(s1)) {
                        this.forceUnicodeFont = "true".equals(s2);
                    }
                    if ("reducedDebugInfo".equals(s1)) {
                        this.reducedDebugInfo = "true".equals(s2);
                    }
                    if ("useNativeTransport".equals(s1)) {
                        this.useNativeTransport = "true".equals(s2);
                    }
                    if ("entityShadows".equals(s1)) {
                        this.entityShadows = "true".equals(s2);
                    }
                    if ("mainHand".equals(s1)) {
                        EnumHandSide enumHandSide = this.mainHand = "left".equals(s2) ? EnumHandSide.LEFT : EnumHandSide.RIGHT;
                    }
                    if ("showSubtitles".equals(s1)) {
                        this.showSubtitles = "true".equals(s2);
                    }
                    if ("realmsNotifications".equals(s1)) {
                        this.realmsNotifications = "true".equals(s2);
                    }
                    if ("enableWeakAttacks".equals(s1)) {
                        this.enableWeakAttacks = "true".equals(s2);
                    }
                    if ("autoJump".equals(s1)) {
                        this.autoJump = "true".equals(s2);
                    }
                    for (KeyBinding keyBinding : this.keyBindings) {
                        if (!s1.equals("key_" + keyBinding.getKeyDescription())) continue;
                        if (s2.indexOf(58) != -1) {
                            String[] t = s2.split(":");
                            keyBinding.setKeyModifierAndCode(KeyModifier.valueFromString(t[1]), Integer.parseInt(t[0]));
                            continue;
                        }
                        keyBinding.setKeyModifierAndCode(KeyModifier.NONE, Integer.parseInt(s2));
                    }
                    for (SoundCategory soundCategory : SoundCategory.values()) {
                        if (!s1.equals("soundCategory_" + soundCategory.getName())) continue;
                        this.soundLevels.put(soundCategory, Float.valueOf(this.parseFloat(s2)));
                    }
                    for (EnumPlayerModelParts enumPlayerModelParts : EnumPlayerModelParts.values()) {
                        if (!s1.equals("modelPart_" + enumPlayerModelParts.getPartName())) continue;
                        this.setModelPartEnabled(enumPlayerModelParts, "true".equals(s2));
                    }
                }
                catch (Exception exception) {
                    LOGGER.warn("Skipping bad option: {}:{}", new Object[]{s1, s2});
                }
            }
            KeyBinding.resetKeyBindingArrayAndHash();
        }
        catch (Exception exception) {
            LOGGER.error("Failed to load options", (Throwable)exception);
        }
    }

    private NBTTagCompound dataFix(NBTTagCompound p_dataFix_1_) {
        int i = 0;
        try {
            i = Integer.parseInt(p_dataFix_1_.getString("version"));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return this.mc.getDataFixer().process(FixTypes.OPTIONS, p_dataFix_1_, i);
    }

    private float parseFloat(String p_parseFloat_1_) {
        return "true".equals(p_parseFloat_1_) ? 1.0f : ("false".equals(p_parseFloat_1_) ? 0.0f : Float.parseFloat(p_parseFloat_1_));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveOptions() {
        if (FMLClientHandler.instance().isLoading()) {
            return;
        }
        PrintWriter printwriter = null;
        try {
            printwriter = new PrintWriter(new FileWriter(this.optionsFile));
            printwriter.println("version:922");
            printwriter.println("invertYMouse:" + this.invertMouse);
            printwriter.println("mouseSensitivity:" + this.mouseSensitivity);
            printwriter.println("fov:" + (this.fovSetting - 70.0f) / 40.0f);
            printwriter.println("gamma:" + this.gammaSetting);
            printwriter.println("saturation:" + this.saturation);
            printwriter.println("renderDistance:" + this.renderDistanceChunks);
            printwriter.println("guiScale:" + this.guiScale);
            printwriter.println("particles:" + this.particleSetting);
            printwriter.println("bobView:" + this.viewBobbing);
            printwriter.println("anaglyph3d:" + this.anaglyph);
            printwriter.println("maxFps:" + this.limitFramerate);
            printwriter.println("fboEnable:" + this.fboEnable);
            printwriter.println("difficulty:" + this.difficulty.getDifficultyId());
            printwriter.println("fancyGraphics:" + this.fancyGraphics);
            printwriter.println("ao:" + this.ambientOcclusion);
            switch (this.clouds) {
                case 0: {
                    printwriter.println("renderClouds:false");
                    break;
                }
                case 1: {
                    printwriter.println("renderClouds:fast");
                    break;
                }
                case 2: {
                    printwriter.println("renderClouds:true");
                }
            }
            printwriter.println("resourcePacks:" + GSON.toJson(this.resourcePacks));
            printwriter.println("incompatibleResourcePacks:" + GSON.toJson(this.incompatibleResourcePacks));
            printwriter.println("lastServer:" + this.lastServer);
            printwriter.println("lang:" + this.language);
            printwriter.println("chatVisibility:" + this.chatVisibility.getChatVisibility());
            printwriter.println("chatColors:" + this.chatColours);
            printwriter.println("chatLinks:" + this.chatLinks);
            printwriter.println("chatLinksPrompt:" + this.chatLinksPrompt);
            printwriter.println("chatOpacity:" + this.chatOpacity);
            printwriter.println("snooperEnabled:" + this.snooperEnabled);
            printwriter.println("fullscreen:" + this.fullScreen);
            printwriter.println("enableVsync:" + this.enableVsync);
            printwriter.println("useVbo:" + this.useVbo);
            printwriter.println("hideServerAddress:" + this.hideServerAddress);
            printwriter.println("advancedItemTooltips:" + this.advancedItemTooltips);
            printwriter.println("pauseOnLostFocus:" + this.pauseOnLostFocus);
            printwriter.println("touchscreen:" + this.touchscreen);
            printwriter.println("overrideWidth:" + this.overrideWidth);
            printwriter.println("overrideHeight:" + this.overrideHeight);
            printwriter.println("heldItemTooltips:" + this.heldItemTooltips);
            printwriter.println("chatHeightFocused:" + this.chatHeightFocused);
            printwriter.println("chatHeightUnfocused:" + this.chatHeightUnfocused);
            printwriter.println("chatScale:" + this.chatScale);
            printwriter.println("chatWidth:" + this.chatWidth);
            printwriter.println("showInventoryAchievementHint:" + this.showInventoryAchievementHint);
            printwriter.println("mipmapLevels:" + this.mipmapLevels);
            printwriter.println("forceUnicodeFont:" + this.forceUnicodeFont);
            printwriter.println("reducedDebugInfo:" + this.reducedDebugInfo);
            printwriter.println("useNativeTransport:" + this.useNativeTransport);
            printwriter.println("entityShadows:" + this.entityShadows);
            printwriter.println("mainHand:" + (this.mainHand == EnumHandSide.LEFT ? "left" : "right"));
            printwriter.println("attackIndicator:" + this.attackIndicator);
            printwriter.println("showSubtitles:" + this.showSubtitles);
            printwriter.println("realmsNotifications:" + this.realmsNotifications);
            printwriter.println("enableWeakAttacks:" + this.enableWeakAttacks);
            printwriter.println("autoJump:" + this.autoJump);
            for (KeyBinding keyBinding : this.keyBindings) {
                String keyString = "key_" + keyBinding.getKeyDescription() + ":" + keyBinding.getKeyCode();
                printwriter.println(keyBinding.getKeyModifier() != KeyModifier.NONE ? keyString + ":" + (Object)((Object)keyBinding.getKeyModifier()) : keyString);
            }
            for (SoundCategory soundCategory : SoundCategory.values()) {
                printwriter.println("soundCategory_" + soundCategory.getName() + ":" + this.getSoundLevel(soundCategory));
            }
            for (EnumPlayerModelParts enumPlayerModelParts : EnumPlayerModelParts.values()) {
                printwriter.println("modelPart_" + enumPlayerModelParts.getPartName() + ":" + this.setModelParts.contains((Object)enumPlayerModelParts));
            }
        }
        catch (Exception exception) {
            try {
                LOGGER.error("Failed to save options", (Throwable)exception);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(printwriter);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)printwriter);
        }
        IOUtils.closeQuietly((Writer)printwriter);
        this.sendSettingsToServer();
    }

    public float getSoundLevel(SoundCategory p_getSoundLevel_1_) {
        return this.soundLevels.containsKey((Object)p_getSoundLevel_1_) ? this.soundLevels.get((Object)p_getSoundLevel_1_).floatValue() : 1.0f;
    }

    public void setSoundLevel(SoundCategory p_setSoundLevel_1_, float p_setSoundLevel_2_) {
        this.mc.getSoundHandler().setSoundLevel(p_setSoundLevel_1_, p_setSoundLevel_2_);
        this.soundLevels.put(p_setSoundLevel_1_, Float.valueOf(p_setSoundLevel_2_));
    }

    public void sendSettingsToServer() {
        if (this.mc.player != null) {
            int i = 0;
            for (EnumPlayerModelParts enumplayermodelparts : this.setModelParts) {
                i |= enumplayermodelparts.getPartMask();
            }
            this.mc.player.connection.sendPacket(new CPacketClientSettings(this.language, this.renderDistanceChunks, this.chatVisibility, this.chatColours, i, this.mainHand));
        }
    }

    public Set<EnumPlayerModelParts> getModelParts() {
        return ImmutableSet.copyOf(this.setModelParts);
    }

    public void setModelPartEnabled(EnumPlayerModelParts p_setModelPartEnabled_1_, boolean p_setModelPartEnabled_2_) {
        if (p_setModelPartEnabled_2_) {
            this.setModelParts.add(p_setModelPartEnabled_1_);
        } else {
            this.setModelParts.remove((Object)p_setModelPartEnabled_1_);
        }
        this.sendSettingsToServer();
    }

    public void switchModelPartEnabled(EnumPlayerModelParts p_switchModelPartEnabled_1_) {
        if (this.getModelParts().contains((Object)p_switchModelPartEnabled_1_)) {
            this.setModelParts.remove((Object)p_switchModelPartEnabled_1_);
        } else {
            this.setModelParts.add(p_switchModelPartEnabled_1_);
        }
        this.sendSettingsToServer();
    }

    public int shouldRenderClouds() {
        return this.renderDistanceChunks >= 4 ? this.clouds : 0;
    }

    public boolean isUsingNativeTransport() {
        return this.useNativeTransport;
    }

    private void setForgeKeybindProperties() {
        KeyConflictContext inGame = KeyConflictContext.IN_GAME;
        this.keyBindForward.setKeyConflictContext(inGame);
        this.keyBindLeft.setKeyConflictContext(inGame);
        this.keyBindBack.setKeyConflictContext(inGame);
        this.keyBindRight.setKeyConflictContext(inGame);
        this.keyBindJump.setKeyConflictContext(inGame);
        this.keyBindSneak.setKeyConflictContext(inGame);
        this.keyBindSprint.setKeyConflictContext(inGame);
        this.keyBindAttack.setKeyConflictContext(inGame);
        this.keyBindChat.setKeyConflictContext(inGame);
        this.keyBindPlayerList.setKeyConflictContext(inGame);
        this.keyBindCommand.setKeyConflictContext(inGame);
        this.keyBindTogglePerspective.setKeyConflictContext(inGame);
        this.keyBindSmoothCamera.setKeyConflictContext(inGame);
        this.keyBindSwapHands.setKeyConflictContext(inGame);
    }

    public void onGuiClosed() {
        if (this.needsResourceRefresh) {
            this.mc.scheduleResourcesRefresh();
            this.needsResourceRefresh = false;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static enum Options {
        INVERT_MOUSE("options.invertMouse", false, true),
        SENSITIVITY("options.sensitivity", true, false),
        FOV("options.fov", true, false, 30.0f, 110.0f, 1.0f),
        GAMMA("options.gamma", true, false),
        SATURATION("options.saturation", true, false),
        RENDER_DISTANCE("options.renderDistance", true, false, 2.0f, 16.0f, 1.0f),
        VIEW_BOBBING("options.viewBobbing", false, true),
        ANAGLYPH("options.anaglyph", false, true),
        FRAMERATE_LIMIT("options.framerateLimit", true, false, 10.0f, 260.0f, 10.0f),
        FBO_ENABLE("options.fboEnable", false, true),
        RENDER_CLOUDS("options.renderClouds", false, false),
        GRAPHICS("options.graphics", false, false),
        AMBIENT_OCCLUSION("options.ao", false, false),
        GUI_SCALE("options.guiScale", false, false),
        PARTICLES("options.particles", false, false),
        CHAT_VISIBILITY("options.chat.visibility", false, false),
        CHAT_COLOR("options.chat.color", false, true),
        CHAT_LINKS("options.chat.links", false, true),
        CHAT_OPACITY("options.chat.opacity", true, false),
        CHAT_LINKS_PROMPT("options.chat.links.prompt", false, true),
        SNOOPER_ENABLED("options.snooper", false, true),
        USE_FULLSCREEN("options.fullscreen", false, true),
        ENABLE_VSYNC("options.vsync", false, true),
        USE_VBO("options.vbo", false, true),
        TOUCHSCREEN("options.touchscreen", false, true),
        CHAT_SCALE("options.chat.scale", true, false),
        CHAT_WIDTH("options.chat.width", true, false),
        CHAT_HEIGHT_FOCUSED("options.chat.height.focused", true, false),
        CHAT_HEIGHT_UNFOCUSED("options.chat.height.unfocused", true, false),
        MIPMAP_LEVELS("options.mipmapLevels", true, false, 0.0f, 4.0f, 1.0f),
        FORCE_UNICODE_FONT("options.forceUnicodeFont", false, true),
        REDUCED_DEBUG_INFO("options.reducedDebugInfo", false, true),
        ENTITY_SHADOWS("options.entityShadows", false, true),
        MAIN_HAND("options.mainHand", false, false),
        ATTACK_INDICATOR("options.attackIndicator", false, false),
        ENABLE_WEAK_ATTACKS("options.enableWeakAttacks", false, true),
        SHOW_SUBTITLES("options.showSubtitles", false, true),
        REALMS_NOTIFICATIONS("options.realmsNotifications", false, true),
        AUTO_JUMP("options.autoJump", false, true);

        private final boolean enumFloat;
        private final boolean enumBoolean;
        private final String enumString;
        private final float valueStep;
        private float valueMin;
        private float valueMax;

        public static Options getEnumOptions(int p_getEnumOptions_0_) {
            for (Options gamesettings$options : Options.values()) {
                if (gamesettings$options.returnEnumOrdinal() != p_getEnumOptions_0_) continue;
                return gamesettings$options;
            }
            return null;
        }

        private Options(String p_i1015_3_, boolean p_i1015_4_, boolean p_i1015_5_) {
            this(p_i1015_3_, p_i1015_4_, p_i1015_5_, 0.0f, 1.0f, 0.0f);
        }

        private Options(String p_i45004_3_, boolean p_i45004_4_, boolean p_i45004_5_, float p_i45004_6_, float p_i45004_7_, float p_i45004_8_) {
            this.enumString = p_i45004_3_;
            this.enumFloat = p_i45004_4_;
            this.enumBoolean = p_i45004_5_;
            this.valueMin = p_i45004_6_;
            this.valueMax = p_i45004_7_;
            this.valueStep = p_i45004_8_;
        }

        public boolean getEnumFloat() {
            return this.enumFloat;
        }

        public boolean getEnumBoolean() {
            return this.enumBoolean;
        }

        public int returnEnumOrdinal() {
            return this.ordinal();
        }

        public String getEnumString() {
            return this.enumString;
        }

        public float getValueMin() {
            return this.valueMin;
        }

        public float getValueMax() {
            return this.valueMax;
        }

        public void setValueMax(float p_setValueMax_1_) {
            this.valueMax = p_setValueMax_1_;
        }

        public float normalizeValue(float p_normalizeValue_1_) {
            return MathHelper.clamp((this.snapToStepClamp(p_normalizeValue_1_) - this.valueMin) / (this.valueMax - this.valueMin), 0.0f, 1.0f);
        }

        public float denormalizeValue(float p_denormalizeValue_1_) {
            return this.snapToStepClamp(this.valueMin + (this.valueMax - this.valueMin) * MathHelper.clamp(p_denormalizeValue_1_, 0.0f, 1.0f));
        }

        public float snapToStepClamp(float p_snapToStepClamp_1_) {
            p_snapToStepClamp_1_ = this.snapToStep(p_snapToStepClamp_1_);
            return MathHelper.clamp(p_snapToStepClamp_1_, this.valueMin, this.valueMax);
        }

        private float snapToStep(float p_snapToStep_1_) {
            if (this.valueStep > 0.0f) {
                p_snapToStep_1_ = this.valueStep * (float)Math.round(p_snapToStep_1_ / this.valueStep);
            }
            return p_snapToStep_1_;
        }
    }
}

