/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.settings;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyBindingMap;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class KeyBinding
implements Comparable<KeyBinding> {
    private static final List<KeyBinding> KEYBIND_ARRAY = Lists.newArrayList();
    private static final KeyBindingMap HASH = new KeyBindingMap();
    private static final Set<String> KEYBIND_SET = Sets.newHashSet();
    private final String keyDescription;
    private final int keyCodeDefault;
    private final String keyCategory;
    private int keyCode;
    private boolean pressed;
    private int pressTime;
    private KeyModifier keyModifierDefault = KeyModifier.NONE;
    private KeyModifier keyModifier = KeyModifier.NONE;
    private IKeyConflictContext keyConflictContext = KeyConflictContext.UNIVERSAL;

    public static void onTick(int p_onTick_0_) {
        KeyBinding keybinding;
        if (p_onTick_0_ != 0 && (keybinding = HASH.lookupActive(p_onTick_0_)) != null) {
            ++keybinding.pressTime;
        }
    }

    public static void setKeyBindState(int p_setKeyBindState_0_, boolean p_setKeyBindState_1_) {
        if (p_setKeyBindState_0_ != 0) {
            for (KeyBinding keybinding : HASH.lookupAll(p_setKeyBindState_0_)) {
                if (keybinding == null) continue;
                keybinding.pressed = p_setKeyBindState_1_;
            }
        }
    }

    public static void updateKeyBindState() {
        for (KeyBinding keybinding : KEYBIND_ARRAY) {
            try {
                KeyBinding.setKeyBindState(keybinding.keyCode, keybinding.keyCode < 256 && Keyboard.isKeyDown((int)keybinding.keyCode));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        }
    }

    public static void unPressAllKeys() {
        for (KeyBinding keybinding : KEYBIND_ARRAY) {
            keybinding.unpressKey();
        }
    }

    public static void resetKeyBindingArrayAndHash() {
        HASH.clearMap();
        for (KeyBinding keybinding : KEYBIND_ARRAY) {
            HASH.addKey(keybinding.keyCode, keybinding);
        }
    }

    public static Set<String> getKeybinds() {
        return KEYBIND_SET;
    }

    public KeyBinding(String p_i45001_1_, int p_i45001_2_, String p_i45001_3_) {
        this.keyDescription = p_i45001_1_;
        this.keyCode = p_i45001_2_;
        this.keyCodeDefault = p_i45001_2_;
        this.keyCategory = p_i45001_3_;
        KEYBIND_ARRAY.add(this);
        HASH.addKey(p_i45001_2_, this);
        KEYBIND_SET.add(p_i45001_3_);
    }

    public boolean isKeyDown() {
        return this.pressed && this.getKeyConflictContext().isActive() && this.getKeyModifier().isActive(this.getKeyConflictContext());
    }

    public String getKeyCategory() {
        return this.keyCategory;
    }

    public boolean isPressed() {
        if (this.pressTime == 0) {
            return false;
        }
        --this.pressTime;
        return true;
    }

    private void unpressKey() {
        this.pressTime = 0;
        this.pressed = false;
    }

    public String getKeyDescription() {
        return this.keyDescription;
    }

    public int getKeyCodeDefault() {
        return this.keyCodeDefault;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public void setKeyCode(int p_setKeyCode_1_) {
        this.keyCode = p_setKeyCode_1_;
    }

    @Override
    public int compareTo(KeyBinding p_compareTo_1_) {
        int i = I18n.format(this.keyCategory, new Object[0]).compareTo(I18n.format(p_compareTo_1_.keyCategory, new Object[0]));
        if (i == 0) {
            i = I18n.format(this.keyDescription, new Object[0]).compareTo(I18n.format(p_compareTo_1_.keyDescription, new Object[0]));
        }
        return i;
    }

    public KeyBinding(String p_i16_1_, IKeyConflictContext p_i16_2_, int p_i16_3_, String p_i16_4_) {
        this(p_i16_1_, p_i16_2_, KeyModifier.NONE, p_i16_3_, p_i16_4_);
    }

    public KeyBinding(String p_i17_1_, IKeyConflictContext p_i17_2_, KeyModifier p_i17_3_, int p_i17_4_, String p_i17_5_) {
        this.keyDescription = p_i17_1_;
        this.keyCode = p_i17_4_;
        this.keyCodeDefault = p_i17_4_;
        this.keyCategory = p_i17_5_;
        this.keyConflictContext = p_i17_2_;
        this.keyModifier = p_i17_3_;
        this.keyModifierDefault = p_i17_3_;
        if (this.keyModifier.matches(p_i17_4_)) {
            this.keyModifier = KeyModifier.NONE;
        }
        KEYBIND_ARRAY.add(this);
        HASH.addKey(p_i17_4_, this);
        KEYBIND_SET.add(p_i17_5_);
    }

    public boolean isActiveAndMatches(int p_isActiveAndMatches_1_) {
        return p_isActiveAndMatches_1_ != 0 && p_isActiveAndMatches_1_ == this.getKeyCode() && this.getKeyConflictContext().isActive() && this.getKeyModifier().isActive(this.getKeyConflictContext());
    }

    public void setKeyConflictContext(IKeyConflictContext p_setKeyConflictContext_1_) {
        this.keyConflictContext = p_setKeyConflictContext_1_;
    }

    public IKeyConflictContext getKeyConflictContext() {
        return this.keyConflictContext;
    }

    public KeyModifier getKeyModifierDefault() {
        return this.keyModifierDefault;
    }

    public KeyModifier getKeyModifier() {
        return this.keyModifier;
    }

    public void setKeyModifierAndCode(KeyModifier p_setKeyModifierAndCode_1_, int p_setKeyModifierAndCode_2_) {
        this.keyCode = p_setKeyModifierAndCode_2_;
        if (p_setKeyModifierAndCode_1_.matches(p_setKeyModifierAndCode_2_)) {
            p_setKeyModifierAndCode_1_ = KeyModifier.NONE;
        }
        HASH.removeKey(this);
        this.keyModifier = p_setKeyModifierAndCode_1_;
        HASH.addKey(p_setKeyModifierAndCode_2_, this);
    }

    public void setToDefault() {
        this.setKeyModifierAndCode(this.getKeyModifierDefault(), this.getKeyCodeDefault());
    }

    public boolean isSetToDefaultValue() {
        return this.getKeyCode() == this.getKeyCodeDefault() && this.getKeyModifier() == this.getKeyModifierDefault();
    }

    public boolean conflicts(KeyBinding p_conflicts_1_) {
        if (this.getKeyConflictContext().conflicts(p_conflicts_1_.getKeyConflictContext()) || p_conflicts_1_.getKeyConflictContext().conflicts(this.getKeyConflictContext())) {
            KeyModifier keyModifier = this.getKeyModifier();
            KeyModifier otherKeyModifier = p_conflicts_1_.getKeyModifier();
            if (keyModifier.matches(p_conflicts_1_.getKeyCode()) || otherKeyModifier.matches(this.getKeyCode())) {
                return true;
            }
            if (this.getKeyCode() == p_conflicts_1_.getKeyCode()) {
                return keyModifier == otherKeyModifier || this.getKeyConflictContext().conflicts(KeyConflictContext.IN_GAME) && (keyModifier == KeyModifier.NONE || otherKeyModifier == KeyModifier.NONE);
            }
        }
        return false;
    }

    public boolean hasKeyCodeModifierConflict(KeyBinding p_hasKeyCodeModifierConflict_1_) {
        return !(!this.getKeyConflictContext().conflicts(p_hasKeyCodeModifierConflict_1_.getKeyConflictContext()) && !p_hasKeyCodeModifierConflict_1_.getKeyConflictContext().conflicts(this.getKeyConflictContext()) || !this.getKeyModifier().matches(p_hasKeyCodeModifierConflict_1_.getKeyCode()) && !p_hasKeyCodeModifierConflict_1_.getKeyModifier().matches(this.getKeyCode()));
    }

    public String getDisplayName() {
        return this.getKeyModifier().getLocalizedComboName(this.getKeyCode());
    }
}

