/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.shader;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.shader.Shader;
import net.minecraft.client.shader.ShaderUniform;
import net.minecraft.client.util.JsonException;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;
import org.lwjgl.util.vector.Matrix4f;

@SideOnly(value=Side.CLIENT)
public class ShaderGroup {
    private final Framebuffer mainFramebuffer;
    private final IResourceManager resourceManager;
    private final String shaderGroupName;
    private final List<Shader> listShaders = Lists.newArrayList();
    private final Map<String, Framebuffer> mapFramebuffers = Maps.newHashMap();
    private final List<Framebuffer> listFramebuffers = Lists.newArrayList();
    private Matrix4f projectionMatrix;
    private int mainFramebufferWidth;
    private int mainFramebufferHeight;
    private float time;
    private float lastStamp;

    public ShaderGroup(TextureManager p_i1050_1_, IResourceManager p_i1050_2_, Framebuffer p_i1050_3_, ResourceLocation p_i1050_4_) throws JsonException, IOException, JsonSyntaxException {
        this.resourceManager = p_i1050_2_;
        this.mainFramebuffer = p_i1050_3_;
        this.time = 0.0f;
        this.lastStamp = 0.0f;
        this.mainFramebufferWidth = p_i1050_3_.framebufferWidth;
        this.mainFramebufferHeight = p_i1050_3_.framebufferHeight;
        this.shaderGroupName = p_i1050_4_.toString();
        this.resetProjectionMatrix();
        this.parseGroup(p_i1050_1_, p_i1050_4_);
    }

    public void parseGroup(TextureManager p_parseGroup_1_, ResourceLocation p_parseGroup_2_) throws JsonException, IOException, JsonSyntaxException {
        IResource lvt_4_1_;
        block11: {
            JsonParser lvt_3_1_ = new JsonParser();
            lvt_4_1_ = null;
            try {
                lvt_4_1_ = this.resourceManager.getResource(p_parseGroup_2_);
                JsonObject lvt_5_1_ = lvt_3_1_.parse(IOUtils.toString((InputStream)lvt_4_1_.getInputStream(), (Charset)Charsets.UTF_8)).getAsJsonObject();
                if (JsonUtils.isJsonArray(lvt_5_1_, "targets")) {
                    JsonArray lvt_6_1_ = lvt_5_1_.getAsJsonArray("targets");
                    int lvt_7_1_ = 0;
                    for (JsonElement lvt_9_1_ : lvt_6_1_) {
                        try {
                            this.initTarget(lvt_9_1_);
                        }
                        catch (Exception lvt_10_1_) {
                            JsonException lvt_11_1_ = JsonException.forException(lvt_10_1_);
                            lvt_11_1_.prependJsonKey("targets[" + lvt_7_1_ + "]");
                            throw lvt_11_1_;
                        }
                        ++lvt_7_1_;
                    }
                }
                if (!JsonUtils.isJsonArray(lvt_5_1_, "passes")) break block11;
                JsonArray lvt_6_2_ = lvt_5_1_.getAsJsonArray("passes");
                int lvt_7_2_ = 0;
                for (JsonElement lvt_9_2_ : lvt_6_2_) {
                    try {
                        this.parsePass(p_parseGroup_1_, lvt_9_2_);
                    }
                    catch (Exception lvt_10_2_) {
                        JsonException lvt_11_2_ = JsonException.forException(lvt_10_2_);
                        lvt_11_2_.prependJsonKey("passes[" + lvt_7_2_ + "]");
                        throw lvt_11_2_;
                    }
                    ++lvt_7_2_;
                }
            }
            catch (Exception lvt_5_2_) {
                try {
                    JsonException lvt_6_3_ = JsonException.forException(lvt_5_2_);
                    lvt_6_3_.setFilenameAndFlush(p_parseGroup_2_.getResourcePath());
                    throw lvt_6_3_;
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(lvt_4_1_);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly((Closeable)lvt_4_1_);
    }

    private void initTarget(JsonElement p_initTarget_1_) throws JsonException {
        if (JsonUtils.isString(p_initTarget_1_)) {
            this.addFramebuffer(p_initTarget_1_.getAsString(), this.mainFramebufferWidth, this.mainFramebufferHeight);
        } else {
            JsonObject lvt_2_1_ = JsonUtils.getJsonObject(p_initTarget_1_, "target");
            String lvt_3_1_ = JsonUtils.getString(lvt_2_1_, "name");
            int lvt_4_1_ = JsonUtils.getInt(lvt_2_1_, "width", this.mainFramebufferWidth);
            int lvt_5_1_ = JsonUtils.getInt(lvt_2_1_, "height", this.mainFramebufferHeight);
            if (this.mapFramebuffers.containsKey(lvt_3_1_)) {
                throw new JsonException(lvt_3_1_ + " is already defined");
            }
            this.addFramebuffer(lvt_3_1_, lvt_4_1_, lvt_5_1_);
        }
    }

    private void parsePass(TextureManager p_parsePass_1_, JsonElement p_parsePass_2_) throws JsonException, IOException {
        JsonArray lvt_11_2_;
        JsonObject lvt_3_1_;
        block16: {
            lvt_3_1_ = JsonUtils.getJsonObject(p_parsePass_2_, "pass");
            String lvt_4_1_ = JsonUtils.getString(lvt_3_1_, "name");
            String lvt_5_1_ = JsonUtils.getString(lvt_3_1_, "intarget");
            String lvt_6_1_ = JsonUtils.getString(lvt_3_1_, "outtarget");
            Framebuffer lvt_7_1_ = this.getFramebuffer(lvt_5_1_);
            Framebuffer lvt_8_1_ = this.getFramebuffer(lvt_6_1_);
            if (lvt_7_1_ == null) {
                throw new JsonException("Input target '" + lvt_5_1_ + "' does not exist");
            }
            if (lvt_8_1_ == null) {
                throw new JsonException("Output target '" + lvt_6_1_ + "' does not exist");
            }
            Shader lvt_9_1_ = this.addShader(lvt_4_1_, lvt_7_1_, lvt_8_1_);
            JsonArray lvt_10_1_ = JsonUtils.getJsonArray(lvt_3_1_, "auxtargets", null);
            if (lvt_10_1_ == null) break block16;
            int lvt_11_1_ = 0;
            for (JsonElement lvt_13_1_ : lvt_10_1_) {
                block15: {
                    try {
                        Framebuffer lvt_17_1_;
                        String lvt_15_1_;
                        block17: {
                            JsonObject lvt_14_1_ = JsonUtils.getJsonObject(lvt_13_1_, "auxtarget");
                            lvt_15_1_ = JsonUtils.getString(lvt_14_1_, "name");
                            String lvt_16_1_ = JsonUtils.getString(lvt_14_1_, "id");
                            lvt_17_1_ = this.getFramebuffer(lvt_16_1_);
                            if (lvt_17_1_ != null) break block17;
                            ResourceLocation lvt_18_1_ = new ResourceLocation("textures/effect/" + lvt_16_1_ + ".png");
                            IResource lvt_19_1_ = null;
                            try {
                                lvt_19_1_ = this.resourceManager.getResource(lvt_18_1_);
                            }
                            catch (FileNotFoundException lvt_20_1_) {
                                try {
                                    throw new JsonException("Render target or texture '" + lvt_16_1_ + "' does not exist");
                                }
                                catch (Throwable throwable) {
                                    IOUtils.closeQuietly(lvt_19_1_);
                                    throw throwable;
                                }
                            }
                            IOUtils.closeQuietly((Closeable)lvt_19_1_);
                            p_parsePass_1_.bindTexture(lvt_18_1_);
                            ITextureObject lvt_20_2_ = p_parsePass_1_.getTexture(lvt_18_1_);
                            int lvt_21_1_ = JsonUtils.getInt(lvt_14_1_, "width");
                            int lvt_22_1_ = JsonUtils.getInt(lvt_14_1_, "height");
                            boolean lvt_23_1_ = JsonUtils.getBoolean(lvt_14_1_, "bilinear");
                            if (lvt_23_1_) {
                                GlStateManager.glTexParameteri(3553, 10241, 9729);
                                GlStateManager.glTexParameteri(3553, 10240, 9729);
                            } else {
                                GlStateManager.glTexParameteri(3553, 10241, 9728);
                                GlStateManager.glTexParameteri(3553, 10240, 9728);
                            }
                            lvt_9_1_.addAuxFramebuffer(lvt_15_1_, lvt_20_2_.getGlTextureId(), lvt_21_1_, lvt_22_1_);
                            break block15;
                        }
                        lvt_9_1_.addAuxFramebuffer(lvt_15_1_, lvt_17_1_, lvt_17_1_.framebufferTextureWidth, lvt_17_1_.framebufferTextureHeight);
                    }
                    catch (Exception lvt_14_2_) {
                        JsonException lvt_15_2_ = JsonException.forException(lvt_14_2_);
                        lvt_15_2_.prependJsonKey("auxtargets[" + lvt_11_1_ + "]");
                        throw lvt_15_2_;
                    }
                }
                ++lvt_11_1_;
            }
        }
        if ((lvt_11_2_ = JsonUtils.getJsonArray(lvt_3_1_, "uniforms", null)) != null) {
            int lvt_12_1_ = 0;
            for (JsonElement lvt_14_3_ : lvt_11_2_) {
                try {
                    this.initUniform(lvt_14_3_);
                }
                catch (Exception lvt_15_3_) {
                    JsonException lvt_16_2_ = JsonException.forException(lvt_15_3_);
                    lvt_16_2_.prependJsonKey("uniforms[" + lvt_12_1_ + "]");
                    throw lvt_16_2_;
                }
                ++lvt_12_1_;
            }
        }
    }

    private void initUniform(JsonElement p_initUniform_1_) throws JsonException {
        JsonObject lvt_2_1_ = JsonUtils.getJsonObject(p_initUniform_1_, "uniform");
        String lvt_3_1_ = JsonUtils.getString(lvt_2_1_, "name");
        ShaderUniform lvt_4_1_ = this.listShaders.get(this.listShaders.size() - 1).getShaderManager().getShaderUniform(lvt_3_1_);
        if (lvt_4_1_ == null) {
            throw new JsonException("Uniform '" + lvt_3_1_ + "' does not exist");
        }
        float[] lvt_5_1_ = new float[4];
        int lvt_6_1_ = 0;
        JsonArray lvt_7_1_ = JsonUtils.getJsonArray(lvt_2_1_, "values");
        for (JsonElement lvt_9_1_ : lvt_7_1_) {
            try {
                lvt_5_1_[lvt_6_1_] = JsonUtils.getFloat(lvt_9_1_, "value");
            }
            catch (Exception lvt_10_1_) {
                JsonException lvt_11_1_ = JsonException.forException(lvt_10_1_);
                lvt_11_1_.prependJsonKey("values[" + lvt_6_1_ + "]");
                throw lvt_11_1_;
            }
            ++lvt_6_1_;
        }
        switch (lvt_6_1_) {
            case 0: {
                break;
            }
            case 1: {
                lvt_4_1_.set(lvt_5_1_[0]);
                break;
            }
            case 2: {
                lvt_4_1_.set(lvt_5_1_[0], lvt_5_1_[1]);
                break;
            }
            case 3: {
                lvt_4_1_.set(lvt_5_1_[0], lvt_5_1_[1], lvt_5_1_[2]);
                break;
            }
            case 4: {
                lvt_4_1_.set(lvt_5_1_[0], lvt_5_1_[1], lvt_5_1_[2], lvt_5_1_[3]);
            }
        }
    }

    public Framebuffer getFramebufferRaw(String p_getFramebufferRaw_1_) {
        return this.mapFramebuffers.get(p_getFramebufferRaw_1_);
    }

    public void addFramebuffer(String p_addFramebuffer_1_, int p_addFramebuffer_2_, int p_addFramebuffer_3_) {
        Framebuffer lvt_4_1_ = new Framebuffer(p_addFramebuffer_2_, p_addFramebuffer_3_, true);
        lvt_4_1_.setFramebufferColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.mapFramebuffers.put(p_addFramebuffer_1_, lvt_4_1_);
        if (p_addFramebuffer_2_ == this.mainFramebufferWidth && p_addFramebuffer_3_ == this.mainFramebufferHeight) {
            this.listFramebuffers.add(lvt_4_1_);
        }
    }

    public void deleteShaderGroup() {
        for (Framebuffer lvt_2_1_ : this.mapFramebuffers.values()) {
            lvt_2_1_.deleteFramebuffer();
        }
        for (Shader lvt_2_2_ : this.listShaders) {
            lvt_2_2_.deleteShader();
        }
        this.listShaders.clear();
    }

    public Shader addShader(String p_addShader_1_, Framebuffer p_addShader_2_, Framebuffer p_addShader_3_) throws JsonException, IOException {
        Shader lvt_4_1_ = new Shader(this.resourceManager, p_addShader_1_, p_addShader_2_, p_addShader_3_);
        this.listShaders.add(this.listShaders.size(), lvt_4_1_);
        return lvt_4_1_;
    }

    private void resetProjectionMatrix() {
        this.projectionMatrix = new Matrix4f();
        this.projectionMatrix.setIdentity();
        this.projectionMatrix.m00 = 2.0f / (float)this.mainFramebuffer.framebufferTextureWidth;
        this.projectionMatrix.m11 = 2.0f / (float)(-this.mainFramebuffer.framebufferTextureHeight);
        this.projectionMatrix.m22 = -0.0020001999f;
        this.projectionMatrix.m33 = 1.0f;
        this.projectionMatrix.m03 = -1.0f;
        this.projectionMatrix.m13 = 1.0f;
        this.projectionMatrix.m23 = -1.0001999f;
    }

    public void createBindFramebuffers(int p_createBindFramebuffers_1_, int p_createBindFramebuffers_2_) {
        this.mainFramebufferWidth = this.mainFramebuffer.framebufferTextureWidth;
        this.mainFramebufferHeight = this.mainFramebuffer.framebufferTextureHeight;
        this.resetProjectionMatrix();
        for (Shader lvt_4_1_ : this.listShaders) {
            lvt_4_1_.setProjectionMatrix(this.projectionMatrix);
        }
        for (Framebuffer lvt_4_2_ : this.listFramebuffers) {
            lvt_4_2_.createBindFramebuffer(p_createBindFramebuffers_1_, p_createBindFramebuffers_2_);
        }
    }

    public void loadShaderGroup(float p_loadShaderGroup_1_) {
        if (p_loadShaderGroup_1_ < this.lastStamp) {
            this.time += 1.0f - this.lastStamp;
            this.time += p_loadShaderGroup_1_;
        } else {
            this.time += p_loadShaderGroup_1_ - this.lastStamp;
        }
        this.lastStamp = p_loadShaderGroup_1_;
        while (this.time > 20.0f) {
            this.time -= 20.0f;
        }
        for (Shader lvt_3_1_ : this.listShaders) {
            lvt_3_1_.loadShader(this.time / 20.0f);
        }
    }

    public final String getShaderGroupName() {
        return this.shaderGroupName;
    }

    private Framebuffer getFramebuffer(String p_getFramebuffer_1_) {
        if (p_getFramebuffer_1_ == null) {
            return null;
        }
        if (p_getFramebuffer_1_.equals("minecraft:main")) {
            return this.mainFramebuffer;
        }
        return this.mapFramebuffers.get(p_getFramebuffer_1_);
    }
}

