/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.shader;

import java.io.IOException;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.shader.ShaderManager;
import net.minecraft.client.util.JsonException;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class ShaderLinkHelper {
    private static final Logger LOGGER = LogManager.getLogger();
    private static ShaderLinkHelper staticShaderLinkHelper;

    public static void setNewStaticShaderLinkHelper() {
        staticShaderLinkHelper = new ShaderLinkHelper();
    }

    public static ShaderLinkHelper getStaticShaderLinkHelper() {
        return staticShaderLinkHelper;
    }

    private ShaderLinkHelper() {
    }

    public void deleteShader(ShaderManager p_deleteShader_1_) {
        p_deleteShader_1_.getFragmentShaderLoader().deleteShader(p_deleteShader_1_);
        p_deleteShader_1_.getVertexShaderLoader().deleteShader(p_deleteShader_1_);
        OpenGlHelper.glDeleteProgram(p_deleteShader_1_.getProgram());
    }

    public int createProgram() throws JsonException {
        int lvt_1_1_ = OpenGlHelper.glCreateProgram();
        if (lvt_1_1_ <= 0) {
            throw new JsonException("Could not create shader program (returned program ID " + lvt_1_1_ + ")");
        }
        return lvt_1_1_;
    }

    public void linkProgram(ShaderManager p_linkProgram_1_) throws IOException {
        p_linkProgram_1_.getFragmentShaderLoader().attachShader(p_linkProgram_1_);
        p_linkProgram_1_.getVertexShaderLoader().attachShader(p_linkProgram_1_);
        OpenGlHelper.glLinkProgram(p_linkProgram_1_.getProgram());
        int lvt_2_1_ = OpenGlHelper.glGetProgrami(p_linkProgram_1_.getProgram(), OpenGlHelper.GL_LINK_STATUS);
        if (lvt_2_1_ == 0) {
            LOGGER.warn("Error encountered when linking program containing VS {} and FS {}. Log output:", new Object[]{p_linkProgram_1_.getVertexShaderLoader().getShaderFilename(), p_linkProgram_1_.getFragmentShaderLoader().getShaderFilename()});
            LOGGER.warn(OpenGlHelper.glGetProgramInfoLog(p_linkProgram_1_.getProgram(), 32768));
        }
    }
}

