/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.shader;

import com.google.common.collect.Maps;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.shader.ShaderManager;
import net.minecraft.client.util.JsonException;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.BufferUtils;

@SideOnly(value=Side.CLIENT)
public class ShaderLoader {
    private final ShaderType shaderType;
    private final String shaderFilename;
    private final int shader;
    private int shaderAttachCount;

    private ShaderLoader(ShaderType p_i45091_1_, int p_i45091_2_, String p_i45091_3_) {
        this.shaderType = p_i45091_1_;
        this.shader = p_i45091_2_;
        this.shaderFilename = p_i45091_3_;
    }

    public void attachShader(ShaderManager p_attachShader_1_) {
        ++this.shaderAttachCount;
        OpenGlHelper.glAttachShader(p_attachShader_1_.getProgram(), this.shader);
    }

    public void deleteShader(ShaderManager p_deleteShader_1_) {
        --this.shaderAttachCount;
        if (this.shaderAttachCount <= 0) {
            OpenGlHelper.glDeleteShader(this.shader);
            this.shaderType.getLoadedShaders().remove(this.shaderFilename);
        }
    }

    public String getShaderFilename() {
        return this.shaderFilename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ShaderLoader loadShader(IResourceManager p_loadShader_0_, ShaderType p_loadShader_1_, String p_loadShader_2_) throws IOException {
        ShaderLoader lvt_3_1_ = (ShaderLoader)p_loadShader_1_.getLoadedShaders().get(p_loadShader_2_);
        if (lvt_3_1_ == null) {
            ResourceLocation lvt_4_1_ = new ResourceLocation("shaders/program/" + p_loadShader_2_ + p_loadShader_1_.getShaderExtension());
            IResource lvt_5_1_ = p_loadShader_0_.getResource(lvt_4_1_);
            try {
                byte[] lvt_6_1_ = IOUtils.toByteArray((InputStream)new BufferedInputStream(lvt_5_1_.getInputStream()));
                ByteBuffer lvt_7_1_ = BufferUtils.createByteBuffer((int)lvt_6_1_.length);
                lvt_7_1_.put(lvt_6_1_);
                lvt_7_1_.position(0);
                int lvt_8_1_ = OpenGlHelper.glCreateShader(p_loadShader_1_.getShaderMode());
                OpenGlHelper.glShaderSource(lvt_8_1_, lvt_7_1_);
                OpenGlHelper.glCompileShader(lvt_8_1_);
                if (OpenGlHelper.glGetShaderi(lvt_8_1_, OpenGlHelper.GL_COMPILE_STATUS) == 0) {
                    String lvt_9_1_ = StringUtils.trim((String)OpenGlHelper.glGetShaderInfoLog(lvt_8_1_, 32768));
                    JsonException lvt_10_1_ = new JsonException("Couldn't compile " + p_loadShader_1_.getShaderName() + " program: " + lvt_9_1_);
                    lvt_10_1_.setFilenameAndFlush(lvt_4_1_.getResourcePath());
                    throw lvt_10_1_;
                }
                lvt_3_1_ = new ShaderLoader(p_loadShader_1_, lvt_8_1_, p_loadShader_2_);
                p_loadShader_1_.getLoadedShaders().put(p_loadShader_2_, lvt_3_1_);
            }
            finally {
                IOUtils.closeQuietly((Closeable)lvt_5_1_);
            }
        }
        return lvt_3_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public static enum ShaderType {
        VERTEX("vertex", ".vsh", OpenGlHelper.GL_VERTEX_SHADER),
        FRAGMENT("fragment", ".fsh", OpenGlHelper.GL_FRAGMENT_SHADER);

        private final String shaderName;
        private final String shaderExtension;
        private final int shaderMode;
        private final Map<String, ShaderLoader> loadedShaders = Maps.newHashMap();

        private ShaderType(String p_i45090_3_, String p_i45090_4_, int p_i45090_5_) {
            this.shaderName = p_i45090_3_;
            this.shaderExtension = p_i45090_4_;
            this.shaderMode = p_i45090_5_;
        }

        public String getShaderName() {
            return this.shaderName;
        }

        private String getShaderExtension() {
            return this.shaderExtension;
        }

        private int getShaderMode() {
            return this.shaderMode;
        }

        private Map<String, ShaderLoader> getLoadedShaders() {
            return this.loadedShaders;
        }
    }
}

