/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.shader;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.shader.ShaderDefault;
import net.minecraft.client.shader.ShaderLinkHelper;
import net.minecraft.client.shader.ShaderLoader;
import net.minecraft.client.shader.ShaderUniform;
import net.minecraft.client.util.JsonBlendingMode;
import net.minecraft.client.util.JsonException;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class ShaderManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ShaderDefault DEFAULT_SHADER_UNIFORM = new ShaderDefault();
    private static ShaderManager staticShaderManager;
    private static int currentProgram;
    private static boolean lastCull;
    private final Map<String, Object> shaderSamplers = Maps.newHashMap();
    private final List<String> samplerNames = Lists.newArrayList();
    private final List<Integer> shaderSamplerLocations = Lists.newArrayList();
    private final List<ShaderUniform> shaderUniforms = Lists.newArrayList();
    private final List<Integer> shaderUniformLocations = Lists.newArrayList();
    private final Map<String, ShaderUniform> mappedShaderUniforms = Maps.newHashMap();
    private final int program;
    private final String programFilename;
    private final boolean useFaceCulling;
    private boolean isDirty;
    private final JsonBlendingMode blendingMode;
    private final List<Integer> attribLocations;
    private final List<String> attributes;
    private final ShaderLoader vertexShaderLoader;
    private final ShaderLoader fragmentShaderLoader;

    public ShaderManager(IResourceManager p_i45087_1_, String p_i45087_2_) throws JsonException, IOException {
        JsonParser lvt_3_1_ = new JsonParser();
        ResourceLocation lvt_4_1_ = new ResourceLocation("shaders/program/" + p_i45087_2_ + ".json");
        this.programFilename = p_i45087_2_;
        IResource lvt_5_1_ = null;
        try {
            JsonArray lvt_11_2_;
            JsonArray lvt_10_2_;
            lvt_5_1_ = p_i45087_1_.getResource(lvt_4_1_);
            JsonObject lvt_6_1_ = lvt_3_1_.parse(IOUtils.toString((InputStream)lvt_5_1_.getInputStream(), (Charset)Charsets.UTF_8)).getAsJsonObject();
            String lvt_7_1_ = JsonUtils.getString(lvt_6_1_, "vertex");
            String lvt_8_1_ = JsonUtils.getString(lvt_6_1_, "fragment");
            JsonArray lvt_9_1_ = JsonUtils.getJsonArray(lvt_6_1_, "samplers", null);
            if (lvt_9_1_ != null) {
                int lvt_10_1_ = 0;
                for (Object lvt_12_1_ : lvt_9_1_) {
                    try {
                        this.parseSampler((JsonElement)lvt_12_1_);
                    }
                    catch (Exception lvt_13_1_) {
                        JsonException lvt_14_1_ = JsonException.forException(lvt_13_1_);
                        lvt_14_1_.prependJsonKey("samplers[" + lvt_10_1_ + "]");
                        throw lvt_14_1_;
                    }
                    ++lvt_10_1_;
                }
            }
            if ((lvt_10_2_ = JsonUtils.getJsonArray(lvt_6_1_, "attributes", null)) != null) {
                int lvt_11_1_ = 0;
                this.attribLocations = Lists.newArrayListWithCapacity((int)lvt_10_2_.size());
                this.attributes = Lists.newArrayListWithCapacity((int)lvt_10_2_.size());
                for (Iterator lvt_13_2_ : lvt_10_2_) {
                    try {
                        this.attributes.add(JsonUtils.getString((JsonElement)lvt_13_2_, "attribute"));
                    }
                    catch (Exception lvt_14_2_) {
                        JsonException lvt_15_1_ = JsonException.forException(lvt_14_2_);
                        lvt_15_1_.prependJsonKey("attributes[" + lvt_11_1_ + "]");
                        throw lvt_15_1_;
                    }
                    ++lvt_11_1_;
                }
            } else {
                this.attribLocations = null;
                this.attributes = null;
            }
            if ((lvt_11_2_ = JsonUtils.getJsonArray(lvt_6_1_, "uniforms", null)) != null) {
                int lvt_12_2_ = 0;
                for (JsonElement lvt_14_3_ : lvt_11_2_) {
                    try {
                        this.parseUniform(lvt_14_3_);
                    }
                    catch (Exception lvt_15_2_) {
                        JsonException lvt_16_1_ = JsonException.forException(lvt_15_2_);
                        lvt_16_1_.prependJsonKey("uniforms[" + lvt_12_2_ + "]");
                        throw lvt_16_1_;
                    }
                    ++lvt_12_2_;
                }
            }
            this.blendingMode = JsonBlendingMode.parseBlendNode(JsonUtils.getJsonObject(lvt_6_1_, "blend", null));
            this.useFaceCulling = JsonUtils.getBoolean(lvt_6_1_, "cull", true);
            this.vertexShaderLoader = ShaderLoader.loadShader(p_i45087_1_, ShaderLoader.ShaderType.VERTEX, lvt_7_1_);
            this.fragmentShaderLoader = ShaderLoader.loadShader(p_i45087_1_, ShaderLoader.ShaderType.FRAGMENT, lvt_8_1_);
            this.program = ShaderLinkHelper.getStaticShaderLinkHelper().createProgram();
            ShaderLinkHelper.getStaticShaderLinkHelper().linkProgram(this);
            this.setupUniforms();
            if (this.attributes != null) {
                for (String lvt_13_3_ : this.attributes) {
                    int lvt_14_4_ = OpenGlHelper.glGetAttribLocation(this.program, lvt_13_3_);
                    this.attribLocations.add(lvt_14_4_);
                }
            }
        }
        catch (Exception lvt_7_2_) {
            JsonException lvt_8_2_ = JsonException.forException(lvt_7_2_);
            lvt_8_2_.setFilenameAndFlush(lvt_4_1_.getResourcePath());
            throw lvt_8_2_;
        }
        finally {
            IOUtils.closeQuietly((Closeable)lvt_5_1_);
        }
        this.markDirty();
    }

    public void deleteShader() {
        ShaderLinkHelper.getStaticShaderLinkHelper().deleteShader(this);
    }

    public void endShader() {
        OpenGlHelper.glUseProgram(0);
        currentProgram = -1;
        staticShaderManager = null;
        lastCull = true;
        for (int lvt_1_1_ = 0; lvt_1_1_ < this.shaderSamplerLocations.size(); ++lvt_1_1_) {
            if (this.shaderSamplers.get(this.samplerNames.get(lvt_1_1_)) == null) continue;
            GlStateManager.setActiveTexture(OpenGlHelper.defaultTexUnit + lvt_1_1_);
            GlStateManager.bindTexture(0);
        }
    }

    public void useShader() {
        this.isDirty = false;
        staticShaderManager = this;
        this.blendingMode.apply();
        if (this.program != currentProgram) {
            OpenGlHelper.glUseProgram(this.program);
            currentProgram = this.program;
        }
        if (this.useFaceCulling) {
            GlStateManager.enableCull();
        } else {
            GlStateManager.disableCull();
        }
        for (int lvt_1_1_ = 0; lvt_1_1_ < this.shaderSamplerLocations.size(); ++lvt_1_1_) {
            if (this.shaderSamplers.get(this.samplerNames.get(lvt_1_1_)) == null) continue;
            GlStateManager.setActiveTexture(OpenGlHelper.defaultTexUnit + lvt_1_1_);
            GlStateManager.enableTexture2D();
            Object lvt_2_1_ = this.shaderSamplers.get(this.samplerNames.get(lvt_1_1_));
            int lvt_3_1_ = -1;
            if (lvt_2_1_ instanceof Framebuffer) {
                lvt_3_1_ = ((Framebuffer)lvt_2_1_).framebufferTexture;
            } else if (lvt_2_1_ instanceof ITextureObject) {
                lvt_3_1_ = ((ITextureObject)lvt_2_1_).getGlTextureId();
            } else if (lvt_2_1_ instanceof Integer) {
                lvt_3_1_ = (Integer)lvt_2_1_;
            }
            if (lvt_3_1_ == -1) continue;
            GlStateManager.bindTexture(lvt_3_1_);
            OpenGlHelper.glUniform1i(OpenGlHelper.glGetUniformLocation(this.program, this.samplerNames.get(lvt_1_1_)), lvt_1_1_);
        }
        for (ShaderUniform lvt_2_2_ : this.shaderUniforms) {
            lvt_2_2_.upload();
        }
    }

    public void markDirty() {
        this.isDirty = true;
    }

    @Nullable
    public ShaderUniform getShaderUniform(String p_getShaderUniform_1_) {
        return this.mappedShaderUniforms.get(p_getShaderUniform_1_);
    }

    public ShaderUniform getShaderUniformOrDefault(String p_getShaderUniformOrDefault_1_) {
        ShaderUniform lvt_2_1_ = this.getShaderUniform(p_getShaderUniformOrDefault_1_);
        return lvt_2_1_ == null ? DEFAULT_SHADER_UNIFORM : lvt_2_1_;
    }

    private void setupUniforms() {
        int lvt_1_1_ = 0;
        int lvt_2_1_ = 0;
        while (lvt_1_1_ < this.samplerNames.size()) {
            String lvt_3_1_ = this.samplerNames.get(lvt_1_1_);
            int lvt_4_1_ = OpenGlHelper.glGetUniformLocation(this.program, lvt_3_1_);
            if (lvt_4_1_ == -1) {
                LOGGER.warn("Shader {}could not find sampler named {} in the specified shader program.", new Object[]{this.programFilename, lvt_3_1_});
                this.shaderSamplers.remove(lvt_3_1_);
                this.samplerNames.remove(lvt_2_1_);
                --lvt_2_1_;
            } else {
                this.shaderSamplerLocations.add(lvt_4_1_);
            }
            ++lvt_1_1_;
            ++lvt_2_1_;
        }
        for (ShaderUniform lvt_2_2_ : this.shaderUniforms) {
            String lvt_3_2_ = lvt_2_2_.getShaderName();
            int lvt_4_2_ = OpenGlHelper.glGetUniformLocation(this.program, lvt_3_2_);
            if (lvt_4_2_ == -1) {
                LOGGER.warn("Could not find uniform named {} in the specified shader program.", new Object[]{lvt_3_2_});
                continue;
            }
            this.shaderUniformLocations.add(lvt_4_2_);
            lvt_2_2_.setUniformLocation(lvt_4_2_);
            this.mappedShaderUniforms.put(lvt_3_2_, lvt_2_2_);
        }
    }

    private void parseSampler(JsonElement p_parseSampler_1_) throws JsonException {
        JsonObject lvt_2_1_ = JsonUtils.getJsonObject(p_parseSampler_1_, "sampler");
        String lvt_3_1_ = JsonUtils.getString(lvt_2_1_, "name");
        if (!JsonUtils.isString(lvt_2_1_, "file")) {
            this.shaderSamplers.put(lvt_3_1_, null);
            this.samplerNames.add(lvt_3_1_);
            return;
        }
        this.samplerNames.add(lvt_3_1_);
    }

    public void addSamplerTexture(String p_addSamplerTexture_1_, Object p_addSamplerTexture_2_) {
        if (this.shaderSamplers.containsKey(p_addSamplerTexture_1_)) {
            this.shaderSamplers.remove(p_addSamplerTexture_1_);
        }
        this.shaderSamplers.put(p_addSamplerTexture_1_, p_addSamplerTexture_2_);
        this.markDirty();
    }

    private void parseUniform(JsonElement p_parseUniform_1_) throws JsonException {
        JsonObject lvt_2_1_ = JsonUtils.getJsonObject(p_parseUniform_1_, "uniform");
        String lvt_3_1_ = JsonUtils.getString(lvt_2_1_, "name");
        int lvt_4_1_ = ShaderUniform.parseType(JsonUtils.getString(lvt_2_1_, "type"));
        int lvt_5_1_ = JsonUtils.getInt(lvt_2_1_, "count");
        float[] lvt_6_1_ = new float[Math.max(lvt_5_1_, 16)];
        JsonArray lvt_7_1_ = JsonUtils.getJsonArray(lvt_2_1_, "values");
        if (lvt_7_1_.size() != lvt_5_1_ && lvt_7_1_.size() > 1) {
            throw new JsonException("Invalid amount of values specified (expected " + lvt_5_1_ + ", found " + lvt_7_1_.size() + ")");
        }
        int lvt_8_1_ = 0;
        for (JsonElement lvt_10_1_ : lvt_7_1_) {
            try {
                lvt_6_1_[lvt_8_1_] = JsonUtils.getFloat(lvt_10_1_, "value");
            }
            catch (Exception lvt_11_1_) {
                JsonException lvt_12_1_ = JsonException.forException(lvt_11_1_);
                lvt_12_1_.prependJsonKey("values[" + lvt_8_1_ + "]");
                throw lvt_12_1_;
            }
            ++lvt_8_1_;
        }
        if (lvt_5_1_ > 1 && lvt_7_1_.size() == 1) {
            while (lvt_8_1_ < lvt_5_1_) {
                lvt_6_1_[lvt_8_1_] = lvt_6_1_[0];
                ++lvt_8_1_;
            }
        }
        int lvt_9_1_ = lvt_5_1_ > 1 && lvt_5_1_ <= 4 && lvt_4_1_ < 8 ? lvt_5_1_ - 1 : 0;
        ShaderUniform lvt_10_2_ = new ShaderUniform(lvt_3_1_, lvt_4_1_ + lvt_9_1_, lvt_5_1_, this);
        if (lvt_4_1_ <= 3) {
            lvt_10_2_.set((int)lvt_6_1_[0], (int)lvt_6_1_[1], (int)lvt_6_1_[2], (int)lvt_6_1_[3]);
        } else if (lvt_4_1_ <= 7) {
            lvt_10_2_.setSafe(lvt_6_1_[0], lvt_6_1_[1], lvt_6_1_[2], lvt_6_1_[3]);
        } else {
            lvt_10_2_.set(lvt_6_1_);
        }
        this.shaderUniforms.add(lvt_10_2_);
    }

    public ShaderLoader getVertexShaderLoader() {
        return this.vertexShaderLoader;
    }

    public ShaderLoader getFragmentShaderLoader() {
        return this.fragmentShaderLoader;
    }

    public int getProgram() {
        return this.program;
    }

    static {
        currentProgram = -1;
        lastCull = true;
    }
}

