/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.shader;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.shader.ShaderManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.BufferUtils;
import org.lwjgl.util.vector.Matrix4f;

@SideOnly(value=Side.CLIENT)
public class ShaderUniform {
    private static final Logger LOGGER = LogManager.getLogger();
    private int uniformLocation;
    private final int uniformCount;
    private final int uniformType;
    private final IntBuffer uniformIntBuffer;
    private final FloatBuffer uniformFloatBuffer;
    private final String shaderName;
    private boolean dirty;
    private final ShaderManager shaderManager;

    public ShaderUniform(String p_i45092_1_, int p_i45092_2_, int p_i45092_3_, ShaderManager p_i45092_4_) {
        this.shaderName = p_i45092_1_;
        this.uniformCount = p_i45092_3_;
        this.uniformType = p_i45092_2_;
        this.shaderManager = p_i45092_4_;
        if (p_i45092_2_ <= 3) {
            this.uniformIntBuffer = BufferUtils.createIntBuffer((int)p_i45092_3_);
            this.uniformFloatBuffer = null;
        } else {
            this.uniformIntBuffer = null;
            this.uniformFloatBuffer = BufferUtils.createFloatBuffer((int)p_i45092_3_);
        }
        this.uniformLocation = -1;
        this.markDirty();
    }

    private void markDirty() {
        this.dirty = true;
        if (this.shaderManager != null) {
            this.shaderManager.markDirty();
        }
    }

    public static int parseType(String p_parseType_0_) {
        int lvt_1_1_ = -1;
        if ("int".equals(p_parseType_0_)) {
            lvt_1_1_ = 0;
        } else if ("float".equals(p_parseType_0_)) {
            lvt_1_1_ = 4;
        } else if (p_parseType_0_.startsWith("matrix")) {
            if (p_parseType_0_.endsWith("2x2")) {
                lvt_1_1_ = 8;
            } else if (p_parseType_0_.endsWith("3x3")) {
                lvt_1_1_ = 9;
            } else if (p_parseType_0_.endsWith("4x4")) {
                lvt_1_1_ = 10;
            }
        }
        return lvt_1_1_;
    }

    public void setUniformLocation(int p_setUniformLocation_1_) {
        this.uniformLocation = p_setUniformLocation_1_;
    }

    public String getShaderName() {
        return this.shaderName;
    }

    public void set(float p_set_1_) {
        this.uniformFloatBuffer.position(0);
        this.uniformFloatBuffer.put(0, p_set_1_);
        this.markDirty();
    }

    public void set(float p_set_1_, float p_set_2_) {
        this.uniformFloatBuffer.position(0);
        this.uniformFloatBuffer.put(0, p_set_1_);
        this.uniformFloatBuffer.put(1, p_set_2_);
        this.markDirty();
    }

    public void set(float p_set_1_, float p_set_2_, float p_set_3_) {
        this.uniformFloatBuffer.position(0);
        this.uniformFloatBuffer.put(0, p_set_1_);
        this.uniformFloatBuffer.put(1, p_set_2_);
        this.uniformFloatBuffer.put(2, p_set_3_);
        this.markDirty();
    }

    public void set(float p_set_1_, float p_set_2_, float p_set_3_, float p_set_4_) {
        this.uniformFloatBuffer.position(0);
        this.uniformFloatBuffer.put(p_set_1_);
        this.uniformFloatBuffer.put(p_set_2_);
        this.uniformFloatBuffer.put(p_set_3_);
        this.uniformFloatBuffer.put(p_set_4_);
        this.uniformFloatBuffer.flip();
        this.markDirty();
    }

    public void setSafe(float p_setSafe_1_, float p_setSafe_2_, float p_setSafe_3_, float p_setSafe_4_) {
        this.uniformFloatBuffer.position(0);
        if (this.uniformType >= 4) {
            this.uniformFloatBuffer.put(0, p_setSafe_1_);
        }
        if (this.uniformType >= 5) {
            this.uniformFloatBuffer.put(1, p_setSafe_2_);
        }
        if (this.uniformType >= 6) {
            this.uniformFloatBuffer.put(2, p_setSafe_3_);
        }
        if (this.uniformType >= 7) {
            this.uniformFloatBuffer.put(3, p_setSafe_4_);
        }
        this.markDirty();
    }

    public void set(int p_set_1_, int p_set_2_, int p_set_3_, int p_set_4_) {
        this.uniformIntBuffer.position(0);
        if (this.uniformType >= 0) {
            this.uniformIntBuffer.put(0, p_set_1_);
        }
        if (this.uniformType >= 1) {
            this.uniformIntBuffer.put(1, p_set_2_);
        }
        if (this.uniformType >= 2) {
            this.uniformIntBuffer.put(2, p_set_3_);
        }
        if (this.uniformType >= 3) {
            this.uniformIntBuffer.put(3, p_set_4_);
        }
        this.markDirty();
    }

    public void set(float[] p_set_1_) {
        if (p_set_1_.length < this.uniformCount) {
            LOGGER.warn("Uniform.set called with a too-small value array (expected {}, got {}). Ignoring.", new Object[]{this.uniformCount, p_set_1_.length});
            return;
        }
        this.uniformFloatBuffer.position(0);
        this.uniformFloatBuffer.put(p_set_1_);
        this.uniformFloatBuffer.position(0);
        this.markDirty();
    }

    public void set(float p_set_1_, float p_set_2_, float p_set_3_, float p_set_4_, float p_set_5_, float p_set_6_, float p_set_7_, float p_set_8_, float p_set_9_, float p_set_10_, float p_set_11_, float p_set_12_, float p_set_13_, float p_set_14_, float p_set_15_, float p_set_16_) {
        this.uniformFloatBuffer.position(0);
        this.uniformFloatBuffer.put(0, p_set_1_);
        this.uniformFloatBuffer.put(1, p_set_2_);
        this.uniformFloatBuffer.put(2, p_set_3_);
        this.uniformFloatBuffer.put(3, p_set_4_);
        this.uniformFloatBuffer.put(4, p_set_5_);
        this.uniformFloatBuffer.put(5, p_set_6_);
        this.uniformFloatBuffer.put(6, p_set_7_);
        this.uniformFloatBuffer.put(7, p_set_8_);
        this.uniformFloatBuffer.put(8, p_set_9_);
        this.uniformFloatBuffer.put(9, p_set_10_);
        this.uniformFloatBuffer.put(10, p_set_11_);
        this.uniformFloatBuffer.put(11, p_set_12_);
        this.uniformFloatBuffer.put(12, p_set_13_);
        this.uniformFloatBuffer.put(13, p_set_14_);
        this.uniformFloatBuffer.put(14, p_set_15_);
        this.uniformFloatBuffer.put(15, p_set_16_);
        this.markDirty();
    }

    public void set(Matrix4f p_set_1_) {
        this.set(p_set_1_.m00, p_set_1_.m01, p_set_1_.m02, p_set_1_.m03, p_set_1_.m10, p_set_1_.m11, p_set_1_.m12, p_set_1_.m13, p_set_1_.m20, p_set_1_.m21, p_set_1_.m22, p_set_1_.m23, p_set_1_.m30, p_set_1_.m31, p_set_1_.m32, p_set_1_.m33);
    }

    public void upload() {
        if (!this.dirty) {
            // empty if block
        }
        this.dirty = false;
        if (this.uniformType <= 3) {
            this.uploadInt();
        } else if (this.uniformType <= 7) {
            this.uploadFloat();
        } else if (this.uniformType <= 10) {
            this.uploadFloatMatrix();
        } else {
            LOGGER.warn("Uniform.upload called, but type value ({}) is not a valid type. Ignoring.", new Object[]{this.uniformType});
            return;
        }
    }

    private void uploadInt() {
        switch (this.uniformType) {
            case 0: {
                OpenGlHelper.glUniform1(this.uniformLocation, this.uniformIntBuffer);
                break;
            }
            case 1: {
                OpenGlHelper.glUniform2(this.uniformLocation, this.uniformIntBuffer);
                break;
            }
            case 2: {
                OpenGlHelper.glUniform3(this.uniformLocation, this.uniformIntBuffer);
                break;
            }
            case 3: {
                OpenGlHelper.glUniform4(this.uniformLocation, this.uniformIntBuffer);
                break;
            }
            default: {
                LOGGER.warn("Uniform.upload called, but count value ({}) is  not in the range of 1 to 4. Ignoring.", new Object[]{this.uniformCount});
            }
        }
    }

    private void uploadFloat() {
        switch (this.uniformType) {
            case 4: {
                OpenGlHelper.glUniform1(this.uniformLocation, this.uniformFloatBuffer);
                break;
            }
            case 5: {
                OpenGlHelper.glUniform2(this.uniformLocation, this.uniformFloatBuffer);
                break;
            }
            case 6: {
                OpenGlHelper.glUniform3(this.uniformLocation, this.uniformFloatBuffer);
                break;
            }
            case 7: {
                OpenGlHelper.glUniform4(this.uniformLocation, this.uniformFloatBuffer);
                break;
            }
            default: {
                LOGGER.warn("Uniform.upload called, but count value ({}) is not in the range of 1 to 4. Ignoring.", new Object[]{this.uniformCount});
            }
        }
    }

    private void uploadFloatMatrix() {
        switch (this.uniformType) {
            case 8: {
                OpenGlHelper.glUniformMatrix2(this.uniformLocation, true, this.uniformFloatBuffer);
                break;
            }
            case 9: {
                OpenGlHelper.glUniformMatrix3(this.uniformLocation, true, this.uniformFloatBuffer);
                break;
            }
            case 10: {
                OpenGlHelper.glUniformMatrix4(this.uniformLocation, true, this.uniformFloatBuffer);
            }
        }
    }
}

