/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.util;

import com.google.gson.JsonObject;
import java.util.Locale;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class JsonBlendingMode {
    private static JsonBlendingMode lastApplied;
    private final int srcColorFactor;
    private final int srcAlphaFactor;
    private final int destColorFactor;
    private final int destAlphaFactor;
    private final int blendFunction;
    private final boolean separateBlend;
    private final boolean opaque;

    private JsonBlendingMode(boolean p_i45084_1_, boolean p_i45084_2_, int p_i45084_3_, int p_i45084_4_, int p_i45084_5_, int p_i45084_6_, int p_i45084_7_) {
        this.separateBlend = p_i45084_1_;
        this.srcColorFactor = p_i45084_3_;
        this.destColorFactor = p_i45084_4_;
        this.srcAlphaFactor = p_i45084_5_;
        this.destAlphaFactor = p_i45084_6_;
        this.opaque = p_i45084_2_;
        this.blendFunction = p_i45084_7_;
    }

    public JsonBlendingMode() {
        this(false, true, 1, 0, 1, 0, 32774);
    }

    public JsonBlendingMode(int p_i45085_1_, int p_i45085_2_, int p_i45085_3_) {
        this(false, false, p_i45085_1_, p_i45085_2_, p_i45085_1_, p_i45085_2_, p_i45085_3_);
    }

    public JsonBlendingMode(int p_i45086_1_, int p_i45086_2_, int p_i45086_3_, int p_i45086_4_, int p_i45086_5_) {
        this(true, false, p_i45086_1_, p_i45086_2_, p_i45086_3_, p_i45086_4_, p_i45086_5_);
    }

    public void apply() {
        if (this.equals(lastApplied)) {
            return;
        }
        if (lastApplied == null || this.opaque != lastApplied.isOpaque()) {
            lastApplied = this;
            if (this.opaque) {
                GlStateManager.disableBlend();
                return;
            }
            GlStateManager.enableBlend();
        }
        GlStateManager.glBlendEquation(this.blendFunction);
        if (this.separateBlend) {
            GlStateManager.tryBlendFuncSeparate(this.srcColorFactor, this.destColorFactor, this.srcAlphaFactor, this.destAlphaFactor);
        } else {
            GlStateManager.blendFunc(this.srcColorFactor, this.destColorFactor);
        }
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (!(p_equals_1_ instanceof JsonBlendingMode)) {
            return false;
        }
        JsonBlendingMode lvt_2_1_ = (JsonBlendingMode)p_equals_1_;
        if (this.blendFunction != lvt_2_1_.blendFunction) {
            return false;
        }
        if (this.destAlphaFactor != lvt_2_1_.destAlphaFactor) {
            return false;
        }
        if (this.destColorFactor != lvt_2_1_.destColorFactor) {
            return false;
        }
        if (this.opaque != lvt_2_1_.opaque) {
            return false;
        }
        if (this.separateBlend != lvt_2_1_.separateBlend) {
            return false;
        }
        if (this.srcAlphaFactor != lvt_2_1_.srcAlphaFactor) {
            return false;
        }
        return this.srcColorFactor == lvt_2_1_.srcColorFactor;
    }

    public int hashCode() {
        int lvt_1_1_ = this.srcColorFactor;
        lvt_1_1_ = 31 * lvt_1_1_ + this.srcAlphaFactor;
        lvt_1_1_ = 31 * lvt_1_1_ + this.destColorFactor;
        lvt_1_1_ = 31 * lvt_1_1_ + this.destAlphaFactor;
        lvt_1_1_ = 31 * lvt_1_1_ + this.blendFunction;
        lvt_1_1_ = 31 * lvt_1_1_ + (this.separateBlend ? 1 : 0);
        lvt_1_1_ = 31 * lvt_1_1_ + (this.opaque ? 1 : 0);
        return lvt_1_1_;
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    public static JsonBlendingMode parseBlendNode(JsonObject p_parseBlendNode_0_) {
        if (p_parseBlendNode_0_ == null) {
            return new JsonBlendingMode();
        }
        int lvt_1_1_ = 32774;
        int lvt_2_1_ = 1;
        int lvt_3_1_ = 0;
        int lvt_4_1_ = 1;
        int lvt_5_1_ = 0;
        boolean lvt_6_1_ = true;
        boolean lvt_7_1_ = false;
        if (JsonUtils.isString(p_parseBlendNode_0_, "func") && (lvt_1_1_ = JsonBlendingMode.stringToBlendFunction(p_parseBlendNode_0_.get("func").getAsString())) != 32774) {
            lvt_6_1_ = false;
        }
        if (JsonUtils.isString(p_parseBlendNode_0_, "srcrgb") && (lvt_2_1_ = JsonBlendingMode.stringToBlendFactor(p_parseBlendNode_0_.get("srcrgb").getAsString())) != 1) {
            lvt_6_1_ = false;
        }
        if (JsonUtils.isString(p_parseBlendNode_0_, "dstrgb") && (lvt_3_1_ = JsonBlendingMode.stringToBlendFactor(p_parseBlendNode_0_.get("dstrgb").getAsString())) != 0) {
            lvt_6_1_ = false;
        }
        if (JsonUtils.isString(p_parseBlendNode_0_, "srcalpha")) {
            lvt_4_1_ = JsonBlendingMode.stringToBlendFactor(p_parseBlendNode_0_.get("srcalpha").getAsString());
            if (lvt_4_1_ != 1) {
                lvt_6_1_ = false;
            }
            lvt_7_1_ = true;
        }
        if (JsonUtils.isString(p_parseBlendNode_0_, "dstalpha")) {
            lvt_5_1_ = JsonBlendingMode.stringToBlendFactor(p_parseBlendNode_0_.get("dstalpha").getAsString());
            if (lvt_5_1_ != 0) {
                lvt_6_1_ = false;
            }
            lvt_7_1_ = true;
        }
        if (lvt_6_1_) {
            return new JsonBlendingMode();
        }
        if (lvt_7_1_) {
            return new JsonBlendingMode(lvt_2_1_, lvt_3_1_, lvt_4_1_, lvt_5_1_, lvt_1_1_);
        }
        return new JsonBlendingMode(lvt_2_1_, lvt_3_1_, lvt_1_1_);
    }

    private static int stringToBlendFunction(String p_stringToBlendFunction_0_) {
        String lvt_1_1_ = p_stringToBlendFunction_0_.trim().toLowerCase(Locale.ROOT);
        if ("add".equals(lvt_1_1_)) {
            return 32774;
        }
        if ("subtract".equals(lvt_1_1_)) {
            return 32778;
        }
        if ("reversesubtract".equals(lvt_1_1_)) {
            return 32779;
        }
        if ("reverse_subtract".equals(lvt_1_1_)) {
            return 32779;
        }
        if ("min".equals(lvt_1_1_)) {
            return 32775;
        }
        if ("max".equals(lvt_1_1_)) {
            return 32776;
        }
        return 32774;
    }

    private static int stringToBlendFactor(String p_stringToBlendFactor_0_) {
        String lvt_1_1_ = p_stringToBlendFactor_0_.trim().toLowerCase(Locale.ROOT);
        lvt_1_1_ = lvt_1_1_.replaceAll("_", "");
        lvt_1_1_ = lvt_1_1_.replaceAll("one", "1");
        lvt_1_1_ = lvt_1_1_.replaceAll("zero", "0");
        if ("0".equals(lvt_1_1_ = lvt_1_1_.replaceAll("minus", "-"))) {
            return 0;
        }
        if ("1".equals(lvt_1_1_)) {
            return 1;
        }
        if ("srccolor".equals(lvt_1_1_)) {
            return 768;
        }
        if ("1-srccolor".equals(lvt_1_1_)) {
            return 769;
        }
        if ("dstcolor".equals(lvt_1_1_)) {
            return 774;
        }
        if ("1-dstcolor".equals(lvt_1_1_)) {
            return 775;
        }
        if ("srcalpha".equals(lvt_1_1_)) {
            return 770;
        }
        if ("1-srcalpha".equals(lvt_1_1_)) {
            return 771;
        }
        if ("dstalpha".equals(lvt_1_1_)) {
            return 772;
        }
        if ("1-dstalpha".equals(lvt_1_1_)) {
            return 773;
        }
        return -1;
    }
}

