/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.util;

import com.google.common.collect.Lists;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;

@SideOnly(value=Side.CLIENT)
public class JsonException
extends IOException {
    private final List<Entry> entries = Lists.newArrayList();
    private final String message;

    public JsonException(String p_i45279_1_) {
        this.entries.add(new Entry());
        this.message = p_i45279_1_;
    }

    public JsonException(String p_i45280_1_, Throwable p_i45280_2_) {
        super(p_i45280_2_);
        this.entries.add(new Entry());
        this.message = p_i45280_1_;
    }

    public void prependJsonKey(String p_prependJsonKey_1_) {
        this.entries.get(0).addJsonKey(p_prependJsonKey_1_);
    }

    public void setFilenameAndFlush(String p_setFilenameAndFlush_1_) {
        this.entries.get(0).filename = p_setFilenameAndFlush_1_;
        this.entries.add(0, new Entry());
    }

    @Override
    public String getMessage() {
        return "Invalid " + this.entries.get(this.entries.size() - 1) + ": " + this.message;
    }

    public static JsonException forException(Exception p_forException_0_) {
        if (p_forException_0_ instanceof JsonException) {
            return (JsonException)p_forException_0_;
        }
        String lvt_1_1_ = p_forException_0_.getMessage();
        if (p_forException_0_ instanceof FileNotFoundException) {
            lvt_1_1_ = "File not found";
        }
        return new JsonException(lvt_1_1_, p_forException_0_);
    }

    @SideOnly(value=Side.CLIENT)
    public static class Entry {
        private String filename;
        private final List<String> jsonKeys = Lists.newArrayList();

        private Entry() {
        }

        private void addJsonKey(String p_addJsonKey_1_) {
            this.jsonKeys.add(0, p_addJsonKey_1_);
        }

        public String getJsonKeys() {
            return StringUtils.join(this.jsonKeys, (String)"->");
        }

        public String toString() {
            if (this.filename != null) {
                if (this.jsonKeys.isEmpty()) {
                    return this.filename;
                }
                return this.filename + " " + this.getJsonKeys();
            }
            if (this.jsonKeys.isEmpty()) {
                return "(Unknown file)";
            }
            return "(Unknown file) " + this.getJsonKeys();
        }
    }
}

