/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Doubles;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandException;
import net.minecraft.command.EntityNotFoundException;
import net.minecraft.command.EntitySelector;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandListener;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.InvalidBlockStateException;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.command.SyntaxErrorException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.ForgeHooks;
import org.apache.commons.lang3.exception.ExceptionUtils;

public abstract class CommandBase
implements ICommand {
    private static ICommandListener commandListener;
    private static final Splitter COMMA_SPLITTER;
    private static final Splitter EQUAL_SPLITTER;

    protected static SyntaxErrorException toSyntaxException(JsonParseException p_toSyntaxException_0_) {
        Throwable throwable = ExceptionUtils.getRootCause((Throwable)p_toSyntaxException_0_);
        String s = "";
        if (throwable != null && (s = throwable.getMessage()).contains("setLenient")) {
            s = s.substring(s.indexOf("to accept ") + 10);
        }
        return new SyntaxErrorException("commands.tellraw.jsonException", s);
    }

    protected static NBTTagCompound entityToNBT(Entity p_entityToNBT_0_) {
        ItemStack itemstack;
        NBTTagCompound nbttagcompound = p_entityToNBT_0_.writeToNBT(new NBTTagCompound());
        if (p_entityToNBT_0_ instanceof EntityPlayer && !(itemstack = ((EntityPlayer)p_entityToNBT_0_).inventory.getCurrentItem()).isEmpty()) {
            nbttagcompound.setTag("SelectedItem", itemstack.writeToNBT(new NBTTagCompound()));
        }
        return nbttagcompound;
    }

    public int getRequiredPermissionLevel() {
        return 4;
    }

    @Override
    public List<String> getAliases() {
        return Collections.emptyList();
    }

    @Override
    public boolean checkPermission(MinecraftServer p_checkPermission_1_, ICommandSender p_checkPermission_2_) {
        return p_checkPermission_2_.canUseCommand(this.getRequiredPermissionLevel(), this.getName());
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer p_getTabCompletions_1_, ICommandSender p_getTabCompletions_2_, String[] p_getTabCompletions_3_, BlockPos p_getTabCompletions_4_) {
        return Collections.emptyList();
    }

    public static int parseInt(String p_parseInt_0_) throws NumberInvalidException {
        try {
            return Integer.parseInt(p_parseInt_0_);
        }
        catch (NumberFormatException var2) {
            throw new NumberInvalidException("commands.generic.num.invalid", p_parseInt_0_);
        }
    }

    public static int parseInt(String p_parseInt_0_, int p_parseInt_1_) throws NumberInvalidException {
        return CommandBase.parseInt(p_parseInt_0_, p_parseInt_1_, Integer.MAX_VALUE);
    }

    public static int parseInt(String p_parseInt_0_, int p_parseInt_1_, int p_parseInt_2_) throws NumberInvalidException {
        int i = CommandBase.parseInt(p_parseInt_0_);
        if (i < p_parseInt_1_) {
            throw new NumberInvalidException("commands.generic.num.tooSmall", i, p_parseInt_1_);
        }
        if (i > p_parseInt_2_) {
            throw new NumberInvalidException("commands.generic.num.tooBig", i, p_parseInt_2_);
        }
        return i;
    }

    public static long parseLong(String p_parseLong_0_) throws NumberInvalidException {
        try {
            return Long.parseLong(p_parseLong_0_);
        }
        catch (NumberFormatException var2) {
            throw new NumberInvalidException("commands.generic.num.invalid", p_parseLong_0_);
        }
    }

    public static long parseLong(String p_parseLong_0_, long p_parseLong_1_, long p_parseLong_3_) throws NumberInvalidException {
        long i = CommandBase.parseLong(p_parseLong_0_);
        if (i < p_parseLong_1_) {
            throw new NumberInvalidException("commands.generic.num.tooSmall", i, p_parseLong_1_);
        }
        if (i > p_parseLong_3_) {
            throw new NumberInvalidException("commands.generic.num.tooBig", i, p_parseLong_3_);
        }
        return i;
    }

    public static BlockPos parseBlockPos(ICommandSender p_parseBlockPos_0_, String[] p_parseBlockPos_1_, int p_parseBlockPos_2_, boolean p_parseBlockPos_3_) throws NumberInvalidException {
        BlockPos blockpos = p_parseBlockPos_0_.getPosition();
        return new BlockPos(CommandBase.parseDouble(blockpos.getX(), p_parseBlockPos_1_[p_parseBlockPos_2_], -30000000, 30000000, p_parseBlockPos_3_), CommandBase.parseDouble(blockpos.getY(), p_parseBlockPos_1_[p_parseBlockPos_2_ + 1], 0, 256, false), CommandBase.parseDouble(blockpos.getZ(), p_parseBlockPos_1_[p_parseBlockPos_2_ + 2], -30000000, 30000000, p_parseBlockPos_3_));
    }

    public static double parseDouble(String p_parseDouble_0_) throws NumberInvalidException {
        try {
            double d0 = Double.parseDouble(p_parseDouble_0_);
            if (!Doubles.isFinite((double)d0)) {
                throw new NumberInvalidException("commands.generic.num.invalid", p_parseDouble_0_);
            }
            return d0;
        }
        catch (NumberFormatException var3) {
            throw new NumberInvalidException("commands.generic.num.invalid", p_parseDouble_0_);
        }
    }

    public static double parseDouble(String p_parseDouble_0_, double p_parseDouble_1_) throws NumberInvalidException {
        return CommandBase.parseDouble(p_parseDouble_0_, p_parseDouble_1_, Double.MAX_VALUE);
    }

    public static double parseDouble(String p_parseDouble_0_, double p_parseDouble_1_, double p_parseDouble_3_) throws NumberInvalidException {
        double d0 = CommandBase.parseDouble(p_parseDouble_0_);
        if (d0 < p_parseDouble_1_) {
            throw new NumberInvalidException("commands.generic.num.tooSmall", String.format("%.2f", d0), String.format("%.2f", p_parseDouble_1_));
        }
        if (d0 > p_parseDouble_3_) {
            throw new NumberInvalidException("commands.generic.num.tooBig", String.format("%.2f", d0), String.format("%.2f", p_parseDouble_3_));
        }
        return d0;
    }

    public static boolean parseBoolean(String p_parseBoolean_0_) throws CommandException {
        if (!"true".equals(p_parseBoolean_0_) && !"1".equals(p_parseBoolean_0_)) {
            if (!"false".equals(p_parseBoolean_0_) && !"0".equals(p_parseBoolean_0_)) {
                throw new CommandException("commands.generic.boolean.invalid", p_parseBoolean_0_);
            }
            return false;
        }
        return true;
    }

    public static EntityPlayerMP getCommandSenderAsPlayer(ICommandSender p_getCommandSenderAsPlayer_0_) throws PlayerNotFoundException {
        if (p_getCommandSenderAsPlayer_0_ instanceof EntityPlayerMP) {
            return (EntityPlayerMP)p_getCommandSenderAsPlayer_0_;
        }
        throw new PlayerNotFoundException("commands.generic.player.unspecified");
    }

    public static EntityPlayerMP getPlayer(MinecraftServer p_getPlayer_0_, ICommandSender p_getPlayer_1_, String p_getPlayer_2_) throws PlayerNotFoundException, CommandException {
        EntityPlayerMP entityplayermp = EntitySelector.matchOnePlayer(p_getPlayer_1_, p_getPlayer_2_);
        if (entityplayermp == null) {
            try {
                entityplayermp = p_getPlayer_0_.getPlayerList().getPlayerByUUID(UUID.fromString(p_getPlayer_2_));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (entityplayermp == null) {
            entityplayermp = p_getPlayer_0_.getPlayerList().getPlayerByUsername(p_getPlayer_2_);
        }
        if (entityplayermp == null) {
            throw new PlayerNotFoundException("commands.generic.player.notFound", p_getPlayer_2_);
        }
        return entityplayermp;
    }

    public static Entity getEntity(MinecraftServer p_getEntity_0_, ICommandSender p_getEntity_1_, String p_getEntity_2_) throws EntityNotFoundException, CommandException {
        return CommandBase.getEntity(p_getEntity_0_, p_getEntity_1_, p_getEntity_2_, Entity.class);
    }

    public static <T extends Entity> T getEntity(MinecraftServer p_getEntity_0_, ICommandSender p_getEntity_1_, String p_getEntity_2_, Class<? extends T> p_getEntity_3_) throws EntityNotFoundException, CommandException {
        Object entity;
        block6: {
            entity = EntitySelector.matchOneEntity(p_getEntity_1_, p_getEntity_2_, p_getEntity_3_);
            if (entity == null) {
                entity = p_getEntity_0_.getPlayerList().getPlayerByUsername(p_getEntity_2_);
            }
            if (entity == null) {
                try {
                    UUID uuid = UUID.fromString(p_getEntity_2_);
                    entity = p_getEntity_0_.getEntityFromUuid(uuid);
                    if (entity == null) {
                        entity = p_getEntity_0_.getPlayerList().getPlayerByUUID(uuid);
                    }
                }
                catch (IllegalArgumentException var6) {
                    if (p_getEntity_2_.split("-").length != 5) break block6;
                    throw new EntityNotFoundException("commands.generic.entity.invalidUuid", p_getEntity_2_);
                }
            }
        }
        if (entity != null && p_getEntity_3_.isAssignableFrom(entity.getClass())) {
            return entity;
        }
        throw new EntityNotFoundException(p_getEntity_2_);
    }

    public static List<Entity> getEntityList(MinecraftServer p_getEntityList_0_, ICommandSender p_getEntityList_1_, String p_getEntityList_2_) throws EntityNotFoundException, CommandException {
        return EntitySelector.isSelector(p_getEntityList_2_) ? EntitySelector.matchEntities(p_getEntityList_1_, p_getEntityList_2_, Entity.class) : Lists.newArrayList((Object[])new Entity[]{CommandBase.getEntity(p_getEntityList_0_, p_getEntityList_1_, p_getEntityList_2_)});
    }

    public static String getPlayerName(MinecraftServer p_getPlayerName_0_, ICommandSender p_getPlayerName_1_, String p_getPlayerName_2_) throws PlayerNotFoundException, CommandException {
        try {
            return CommandBase.getPlayer(p_getPlayerName_0_, p_getPlayerName_1_, p_getPlayerName_2_).getName();
        }
        catch (CommandException commandexception) {
            if (EntitySelector.isSelector(p_getPlayerName_2_)) {
                throw commandexception;
            }
            return p_getPlayerName_2_;
        }
    }

    public static String getEntityName(MinecraftServer p_getEntityName_0_, ICommandSender p_getEntityName_1_, String p_getEntityName_2_) throws EntityNotFoundException, CommandException {
        try {
            return CommandBase.getPlayer(p_getEntityName_0_, p_getEntityName_1_, p_getEntityName_2_).getName();
        }
        catch (PlayerNotFoundException var6) {
            try {
                return CommandBase.getEntity(p_getEntityName_0_, p_getEntityName_1_, p_getEntityName_2_).getCachedUniqueIdString();
            }
            catch (EntityNotFoundException entitynotfoundexception) {
                if (EntitySelector.isSelector(p_getEntityName_2_)) {
                    throw entitynotfoundexception;
                }
                return p_getEntityName_2_;
            }
        }
    }

    public static ITextComponent getChatComponentFromNthArg(ICommandSender p_getChatComponentFromNthArg_0_, String[] p_getChatComponentFromNthArg_1_, int p_getChatComponentFromNthArg_2_) throws CommandException, PlayerNotFoundException {
        return CommandBase.getChatComponentFromNthArg(p_getChatComponentFromNthArg_0_, p_getChatComponentFromNthArg_1_, p_getChatComponentFromNthArg_2_, false);
    }

    public static ITextComponent getChatComponentFromNthArg(ICommandSender p_getChatComponentFromNthArg_0_, String[] p_getChatComponentFromNthArg_1_, int p_getChatComponentFromNthArg_2_, boolean p_getChatComponentFromNthArg_3_) throws PlayerNotFoundException, CommandException {
        TextComponentString itextcomponent = new TextComponentString("");
        for (int i = p_getChatComponentFromNthArg_2_; i < p_getChatComponentFromNthArg_1_.length; ++i) {
            if (i > p_getChatComponentFromNthArg_2_) {
                itextcomponent.appendText(" ");
            }
            ITextComponent itextcomponent1 = ForgeHooks.newChatWithLinks(p_getChatComponentFromNthArg_1_[i]);
            if (p_getChatComponentFromNthArg_3_) {
                ITextComponent itextcomponent2 = EntitySelector.matchEntitiesToTextComponent(p_getChatComponentFromNthArg_0_, p_getChatComponentFromNthArg_1_[i]);
                if (itextcomponent2 == null) {
                    if (EntitySelector.isSelector(p_getChatComponentFromNthArg_1_[i])) {
                        throw new PlayerNotFoundException("commands.generic.selector.notFound", p_getChatComponentFromNthArg_1_[i]);
                    }
                } else {
                    itextcomponent1 = itextcomponent2;
                }
            }
            itextcomponent.appendSibling(itextcomponent1);
        }
        return itextcomponent;
    }

    public static String buildString(String[] p_buildString_0_, int p_buildString_1_) {
        StringBuilder stringbuilder = new StringBuilder();
        for (int i = p_buildString_1_; i < p_buildString_0_.length; ++i) {
            if (i > p_buildString_1_) {
                stringbuilder.append(" ");
            }
            String s = p_buildString_0_[i];
            stringbuilder.append(s);
        }
        return stringbuilder.toString();
    }

    public static CoordinateArg parseCoordinate(double p_parseCoordinate_0_, String p_parseCoordinate_2_, boolean p_parseCoordinate_3_) throws NumberInvalidException {
        return CommandBase.parseCoordinate(p_parseCoordinate_0_, p_parseCoordinate_2_, -30000000, 30000000, p_parseCoordinate_3_);
    }

    public static CoordinateArg parseCoordinate(double p_parseCoordinate_0_, String p_parseCoordinate_2_, int p_parseCoordinate_3_, int p_parseCoordinate_4_, boolean p_parseCoordinate_5_) throws NumberInvalidException {
        boolean flag = p_parseCoordinate_2_.startsWith("~");
        if (flag && Double.isNaN(p_parseCoordinate_0_)) {
            throw new NumberInvalidException("commands.generic.num.invalid", p_parseCoordinate_0_);
        }
        double d0 = 0.0;
        if (!flag || p_parseCoordinate_2_.length() > 1) {
            boolean flag1 = p_parseCoordinate_2_.contains(".");
            if (flag) {
                p_parseCoordinate_2_ = p_parseCoordinate_2_.substring(1);
            }
            d0 += CommandBase.parseDouble(p_parseCoordinate_2_);
            if (!flag1 && !flag && p_parseCoordinate_5_) {
                d0 += 0.5;
            }
        }
        double d1 = d0 + (flag ? p_parseCoordinate_0_ : 0.0);
        if (p_parseCoordinate_3_ != 0 || p_parseCoordinate_4_ != 0) {
            if (d1 < (double)p_parseCoordinate_3_) {
                throw new NumberInvalidException("commands.generic.num.tooSmall", String.format("%.2f", d1), p_parseCoordinate_3_);
            }
            if (d1 > (double)p_parseCoordinate_4_) {
                throw new NumberInvalidException("commands.generic.num.tooBig", String.format("%.2f", d1), p_parseCoordinate_4_);
            }
        }
        return new CoordinateArg(d1, d0, flag);
    }

    public static double parseDouble(double p_parseDouble_0_, String p_parseDouble_2_, boolean p_parseDouble_3_) throws NumberInvalidException {
        return CommandBase.parseDouble(p_parseDouble_0_, p_parseDouble_2_, -30000000, 30000000, p_parseDouble_3_);
    }

    public static double parseDouble(double p_parseDouble_0_, String p_parseDouble_2_, int p_parseDouble_3_, int p_parseDouble_4_, boolean p_parseDouble_5_) throws NumberInvalidException {
        double d0;
        boolean flag = p_parseDouble_2_.startsWith("~");
        if (flag && Double.isNaN(p_parseDouble_0_)) {
            throw new NumberInvalidException("commands.generic.num.invalid", p_parseDouble_0_);
        }
        double d = d0 = flag ? p_parseDouble_0_ : 0.0;
        if (!flag || p_parseDouble_2_.length() > 1) {
            boolean flag1 = p_parseDouble_2_.contains(".");
            if (flag) {
                p_parseDouble_2_ = p_parseDouble_2_.substring(1);
            }
            d0 += CommandBase.parseDouble(p_parseDouble_2_);
            if (!flag1 && !flag && p_parseDouble_5_) {
                d0 += 0.5;
            }
        }
        if (p_parseDouble_3_ != 0 || p_parseDouble_4_ != 0) {
            if (d0 < (double)p_parseDouble_3_) {
                throw new NumberInvalidException("commands.generic.num.tooSmall", String.format("%.2f", d0), p_parseDouble_3_);
            }
            if (d0 > (double)p_parseDouble_4_) {
                throw new NumberInvalidException("commands.generic.num.tooBig", String.format("%.2f", d0), p_parseDouble_4_);
            }
        }
        return d0;
    }

    public static Item getItemByText(ICommandSender p_getItemByText_0_, String p_getItemByText_1_) throws NumberInvalidException {
        ResourceLocation resourcelocation = new ResourceLocation(p_getItemByText_1_);
        Item item = Item.REGISTRY.getObject(resourcelocation);
        if (item == null) {
            throw new NumberInvalidException("commands.give.item.notFound", resourcelocation);
        }
        return item;
    }

    public static Block getBlockByText(ICommandSender p_getBlockByText_0_, String p_getBlockByText_1_) throws NumberInvalidException {
        ResourceLocation resourcelocation = new ResourceLocation(p_getBlockByText_1_);
        if (!Block.REGISTRY.containsKey(resourcelocation)) {
            throw new NumberInvalidException("commands.give.block.notFound", resourcelocation);
        }
        return Block.REGISTRY.getObject(resourcelocation);
    }

    public static IBlockState convertArgToBlockState(Block p_convertArgToBlockState_0_, String p_convertArgToBlockState_1_) throws NumberInvalidException, InvalidBlockStateException {
        try {
            int i = Integer.parseInt(p_convertArgToBlockState_1_);
            if (i < 0) {
                throw new NumberInvalidException("commands.generic.num.tooSmall", i, 0);
            }
            if (i > 15) {
                throw new NumberInvalidException("commands.generic.num.tooBig", i, 15);
            }
            return p_convertArgToBlockState_0_.getStateFromMeta(Integer.parseInt(p_convertArgToBlockState_1_));
        }
        catch (RuntimeException var7) {
            try {
                Map<IProperty<?>, Comparable<?>> map = CommandBase.getBlockStatePropertyValueMap(p_convertArgToBlockState_0_, p_convertArgToBlockState_1_);
                IBlockState iblockstate = p_convertArgToBlockState_0_.getDefaultState();
                for (Map.Entry<IProperty<?>, Comparable<?>> entry : map.entrySet()) {
                    iblockstate = CommandBase.getBlockState(iblockstate, entry.getKey(), entry.getValue());
                }
                return iblockstate;
            }
            catch (RuntimeException var6) {
                throw new InvalidBlockStateException("commands.generic.blockstate.invalid", p_convertArgToBlockState_1_, Block.REGISTRY.getNameForObject(p_convertArgToBlockState_0_));
            }
        }
    }

    private static <T extends Comparable<T>> IBlockState getBlockState(IBlockState p_getBlockState_0_, IProperty<T> p_getBlockState_1_, Comparable<?> p_getBlockState_2_) {
        return p_getBlockState_0_.withProperty(p_getBlockState_1_, p_getBlockState_2_);
    }

    public static Predicate<IBlockState> convertArgToBlockStatePredicate(final Block p_convertArgToBlockStatePredicate_0_, String p_convertArgToBlockStatePredicate_1_) throws InvalidBlockStateException {
        if (!"*".equals(p_convertArgToBlockStatePredicate_1_) && !"-1".equals(p_convertArgToBlockStatePredicate_1_)) {
            try {
                final int i = Integer.parseInt(p_convertArgToBlockStatePredicate_1_);
                return new Predicate<IBlockState>(){

                    public boolean apply(IBlockState p_apply_1_) {
                        return i == p_apply_1_.getBlock().getMetaFromState(p_apply_1_);
                    }
                };
            }
            catch (RuntimeException var3) {
                final Map<IProperty<?>, Comparable<?>> map = CommandBase.getBlockStatePropertyValueMap(p_convertArgToBlockStatePredicate_0_, p_convertArgToBlockStatePredicate_1_);
                return new Predicate<IBlockState>(){

                    public boolean apply(IBlockState p_apply_1_) {
                        if (p_apply_1_ != null && p_convertArgToBlockStatePredicate_0_ == p_apply_1_.getBlock()) {
                            for (Map.Entry entry : map.entrySet()) {
                                if (p_apply_1_.getValue((IProperty)entry.getKey()).equals(entry.getValue())) continue;
                                return false;
                            }
                            return true;
                        }
                        return false;
                    }
                };
            }
        }
        return Predicates.alwaysTrue();
    }

    private static Map<IProperty<?>, Comparable<?>> getBlockStatePropertyValueMap(Block p_getBlockStatePropertyValueMap_0_, String p_getBlockStatePropertyValueMap_1_) throws InvalidBlockStateException {
        HashMap map = Maps.newHashMap();
        if ("default".equals(p_getBlockStatePropertyValueMap_1_)) {
            return p_getBlockStatePropertyValueMap_0_.getDefaultState().getProperties();
        }
        BlockStateContainer blockstatecontainer = p_getBlockStatePropertyValueMap_0_.getBlockState();
        Iterator iterator = COMMA_SPLITTER.split((CharSequence)p_getBlockStatePropertyValueMap_1_).iterator();
        while (true) {
            Object comparable;
            IProperty<?> iproperty;
            if (!iterator.hasNext()) {
                return map;
            }
            String s = (String)iterator.next();
            Iterator iterator1 = EQUAL_SPLITTER.split((CharSequence)s).iterator();
            if (!iterator1.hasNext() || (iproperty = blockstatecontainer.getProperty((String)iterator1.next())) == null || !iterator1.hasNext() || (comparable = CommandBase.getValueHelper(iproperty, (String)iterator1.next())) == null) break;
            map.put(iproperty, comparable);
        }
        throw new InvalidBlockStateException("commands.generic.blockstate.invalid", p_getBlockStatePropertyValueMap_1_, Block.REGISTRY.getNameForObject(p_getBlockStatePropertyValueMap_0_));
    }

    @Nullable
    private static <T extends Comparable<T>> T getValueHelper(IProperty<T> p_getValueHelper_0_, String p_getValueHelper_1_) {
        return (T)((Comparable)p_getValueHelper_0_.parseValue(p_getValueHelper_1_).orNull());
    }

    public static String joinNiceString(Object[] p_joinNiceString_0_) {
        StringBuilder stringbuilder = new StringBuilder();
        for (int i = 0; i < p_joinNiceString_0_.length; ++i) {
            String s = p_joinNiceString_0_[i].toString();
            if (i > 0) {
                if (i == p_joinNiceString_0_.length - 1) {
                    stringbuilder.append(" and ");
                } else {
                    stringbuilder.append(", ");
                }
            }
            stringbuilder.append(s);
        }
        return stringbuilder.toString();
    }

    public static ITextComponent join(List<ITextComponent> p_join_0_) {
        TextComponentString itextcomponent = new TextComponentString("");
        for (int i = 0; i < p_join_0_.size(); ++i) {
            if (i > 0) {
                if (i == p_join_0_.size() - 1) {
                    itextcomponent.appendText(" and ");
                } else if (i > 0) {
                    itextcomponent.appendText(", ");
                }
            }
            itextcomponent.appendSibling(p_join_0_.get(i));
        }
        return itextcomponent;
    }

    public static String joinNiceStringFromCollection(Collection<String> p_joinNiceStringFromCollection_0_) {
        return CommandBase.joinNiceString(p_joinNiceStringFromCollection_0_.toArray(new String[p_joinNiceStringFromCollection_0_.size()]));
    }

    public static List<String> getTabCompletionCoordinate(String[] p_getTabCompletionCoordinate_0_, int p_getTabCompletionCoordinate_1_, BlockPos p_getTabCompletionCoordinate_2_) {
        String s;
        if (p_getTabCompletionCoordinate_2_ == null) {
            return Lists.newArrayList((Object[])new String[]{"~"});
        }
        int i = p_getTabCompletionCoordinate_0_.length - 1;
        if (i == p_getTabCompletionCoordinate_1_) {
            s = Integer.toString(p_getTabCompletionCoordinate_2_.getX());
        } else if (i == p_getTabCompletionCoordinate_1_ + 1) {
            s = Integer.toString(p_getTabCompletionCoordinate_2_.getY());
        } else {
            if (i != p_getTabCompletionCoordinate_1_ + 2) {
                return Collections.emptyList();
            }
            s = Integer.toString(p_getTabCompletionCoordinate_2_.getZ());
        }
        return Lists.newArrayList((Object[])new String[]{s});
    }

    public static List<String> getTabCompletionCoordinateXZ(String[] p_getTabCompletionCoordinateXZ_0_, int p_getTabCompletionCoordinateXZ_1_, BlockPos p_getTabCompletionCoordinateXZ_2_) {
        String s;
        if (p_getTabCompletionCoordinateXZ_2_ == null) {
            return Lists.newArrayList((Object[])new String[]{"~"});
        }
        int i = p_getTabCompletionCoordinateXZ_0_.length - 1;
        if (i == p_getTabCompletionCoordinateXZ_1_) {
            s = Integer.toString(p_getTabCompletionCoordinateXZ_2_.getX());
        } else {
            if (i != p_getTabCompletionCoordinateXZ_1_ + 1) {
                return Collections.emptyList();
            }
            s = Integer.toString(p_getTabCompletionCoordinateXZ_2_.getZ());
        }
        return Lists.newArrayList((Object[])new String[]{s});
    }

    public static boolean doesStringStartWith(String p_doesStringStartWith_0_, String p_doesStringStartWith_1_) {
        return p_doesStringStartWith_1_.regionMatches(true, 0, p_doesStringStartWith_0_, 0, p_doesStringStartWith_0_.length());
    }

    public static List<String> getListOfStringsMatchingLastWord(String[] p_getListOfStringsMatchingLastWord_0_, String ... p_getListOfStringsMatchingLastWord_1_) {
        return CommandBase.getListOfStringsMatchingLastWord(p_getListOfStringsMatchingLastWord_0_, Arrays.asList(p_getListOfStringsMatchingLastWord_1_));
    }

    public static List<String> getListOfStringsMatchingLastWord(String[] p_getListOfStringsMatchingLastWord_0_, Collection<?> p_getListOfStringsMatchingLastWord_1_) {
        String s = p_getListOfStringsMatchingLastWord_0_[p_getListOfStringsMatchingLastWord_0_.length - 1];
        ArrayList list = Lists.newArrayList();
        if (!p_getListOfStringsMatchingLastWord_1_.isEmpty()) {
            for (String s1 : Iterables.transform(p_getListOfStringsMatchingLastWord_1_, (Function)Functions.toStringFunction())) {
                if (!CommandBase.doesStringStartWith(s, s1)) continue;
                list.add(s1);
            }
            if (list.isEmpty()) {
                for (Object object : p_getListOfStringsMatchingLastWord_1_) {
                    if (!(object instanceof ResourceLocation) || !CommandBase.doesStringStartWith(s, ((ResourceLocation)object).getResourcePath())) continue;
                    list.add(String.valueOf(object));
                }
            }
        }
        return list;
    }

    @Override
    public boolean isUsernameIndex(String[] p_isUsernameIndex_1_, int p_isUsernameIndex_2_) {
        return false;
    }

    public static void notifyCommandListener(ICommandSender p_notifyCommandListener_0_, ICommand p_notifyCommandListener_1_, String p_notifyCommandListener_2_, Object ... p_notifyCommandListener_3_) {
        CommandBase.notifyCommandListener(p_notifyCommandListener_0_, p_notifyCommandListener_1_, 0, p_notifyCommandListener_2_, p_notifyCommandListener_3_);
    }

    public static void notifyCommandListener(ICommandSender p_notifyCommandListener_0_, ICommand p_notifyCommandListener_1_, int p_notifyCommandListener_2_, String p_notifyCommandListener_3_, Object ... p_notifyCommandListener_4_) {
        if (commandListener != null) {
            commandListener.notifyListener(p_notifyCommandListener_0_, p_notifyCommandListener_1_, p_notifyCommandListener_2_, p_notifyCommandListener_3_, p_notifyCommandListener_4_);
        }
    }

    public static void setCommandListener(ICommandListener p_setCommandListener_0_) {
        commandListener = p_setCommandListener_0_;
    }

    @Override
    public int compareTo(ICommand p_compareTo_1_) {
        return this.getName().compareTo(p_compareTo_1_.getName());
    }

    static {
        COMMA_SPLITTER = Splitter.on((char)',');
        EQUAL_SPLITTER = Splitter.on((char)'=').limit(2);
    }

    public static class CoordinateArg {
        private final double result;
        private final double amount;
        private final boolean isRelative;

        protected CoordinateArg(double p_i46051_1_, double p_i46051_3_, boolean p_i46051_5_) {
            this.result = p_i46051_1_;
            this.amount = p_i46051_3_;
            this.isRelative = p_i46051_5_;
        }

        public double getResult() {
            return this.result;
        }

        public double getAmount() {
            return this.amount;
        }

        public boolean isRelative() {
            return this.isRelative;
        }
    }
}

