/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import java.util.Collections;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CommandBlockData
extends CommandBase {
    @Override
    public String getName() {
        return "blockdata";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public String getUsage(ICommandSender p_getUsage_1_) {
        return "commands.blockdata.usage";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void execute(MinecraftServer p_execute_1_, ICommandSender p_execute_2_, String[] p_execute_3_) throws CommandException {
        void lvt_10_2_;
        if (p_execute_3_.length < 4) {
            throw new WrongUsageException("commands.blockdata.usage", new Object[0]);
        }
        p_execute_2_.setCommandStat(CommandResultStats.Type.AFFECTED_BLOCKS, 0);
        BlockPos lvt_4_1_ = CommandBlockData.parseBlockPos(p_execute_2_, p_execute_3_, 0, false);
        World lvt_5_1_ = p_execute_2_.getEntityWorld();
        if (!lvt_5_1_.isBlockLoaded(lvt_4_1_)) {
            throw new CommandException("commands.blockdata.outOfWorld", new Object[0]);
        }
        IBlockState lvt_6_1_ = lvt_5_1_.getBlockState(lvt_4_1_);
        TileEntity lvt_7_1_ = lvt_5_1_.getTileEntity(lvt_4_1_);
        if (lvt_7_1_ == null) {
            throw new CommandException("commands.blockdata.notValid", new Object[0]);
        }
        NBTTagCompound lvt_8_1_ = lvt_7_1_.writeToNBT(new NBTTagCompound());
        NBTTagCompound lvt_9_1_ = lvt_8_1_.copy();
        try {
            NBTTagCompound lvt_10_1_ = JsonToNBT.getTagFromJson(CommandBlockData.getChatComponentFromNthArg(p_execute_2_, p_execute_3_, 3).getUnformattedText());
        }
        catch (NBTException lvt_11_1_) {
            throw new CommandException("commands.blockdata.tagError", lvt_11_1_.getMessage());
        }
        lvt_8_1_.merge((NBTTagCompound)lvt_10_2_);
        lvt_8_1_.setInteger("x", lvt_4_1_.getX());
        lvt_8_1_.setInteger("y", lvt_4_1_.getY());
        lvt_8_1_.setInteger("z", lvt_4_1_.getZ());
        if (lvt_8_1_.equals(lvt_9_1_)) {
            throw new CommandException("commands.blockdata.failed", lvt_8_1_.toString());
        }
        lvt_7_1_.readFromNBT(lvt_8_1_);
        lvt_7_1_.markDirty();
        lvt_5_1_.notifyBlockUpdate(lvt_4_1_, lvt_6_1_, lvt_6_1_, 3);
        p_execute_2_.setCommandStat(CommandResultStats.Type.AFFECTED_BLOCKS, 1);
        CommandBlockData.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.blockdata.success", lvt_8_1_.toString());
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer p_getTabCompletions_1_, ICommandSender p_getTabCompletions_2_, String[] p_getTabCompletions_3_, BlockPos p_getTabCompletions_4_) {
        if (p_getTabCompletions_3_.length > 0 && p_getTabCompletions_3_.length <= 3) {
            return CommandBlockData.getTabCompletionCoordinate(p_getTabCompletions_3_, 0, p_getTabCompletions_4_);
        }
        return Collections.emptyList();
    }
}

