/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;

public class CommandClearInventory
extends CommandBase {
    @Override
    public String getName() {
        return "clear";
    }

    @Override
    public String getUsage(ICommandSender p_getUsage_1_) {
        return "commands.clear.usage";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public void execute(MinecraftServer p_execute_1_, ICommandSender p_execute_2_, String[] p_execute_3_) throws CommandException {
        EntityPlayerMP lvt_4_1_ = p_execute_3_.length == 0 ? CommandClearInventory.getCommandSenderAsPlayer(p_execute_2_) : CommandClearInventory.getPlayer(p_execute_1_, p_execute_2_, p_execute_3_[0]);
        Item lvt_5_1_ = p_execute_3_.length >= 2 ? CommandClearInventory.getItemByText(p_execute_2_, p_execute_3_[1]) : null;
        int lvt_6_1_ = p_execute_3_.length >= 3 ? CommandClearInventory.parseInt(p_execute_3_[2], -1) : -1;
        int lvt_7_1_ = p_execute_3_.length >= 4 ? CommandClearInventory.parseInt(p_execute_3_[3], -1) : -1;
        NBTTagCompound lvt_8_1_ = null;
        if (p_execute_3_.length >= 5) {
            try {
                lvt_8_1_ = JsonToNBT.getTagFromJson(CommandClearInventory.buildString(p_execute_3_, 4));
            }
            catch (NBTException lvt_9_1_) {
                throw new CommandException("commands.clear.tagError", lvt_9_1_.getMessage());
            }
        }
        if (p_execute_3_.length >= 2 && lvt_5_1_ == null) {
            throw new CommandException("commands.clear.failure", lvt_4_1_.getName());
        }
        int lvt_9_2_ = lvt_4_1_.inventory.clearMatchingItems(lvt_5_1_, lvt_6_1_, lvt_7_1_, lvt_8_1_);
        lvt_4_1_.inventoryContainer.detectAndSendChanges();
        if (!lvt_4_1_.capabilities.isCreativeMode) {
            lvt_4_1_.updateHeldItem();
        }
        p_execute_2_.setCommandStat(CommandResultStats.Type.AFFECTED_ITEMS, lvt_9_2_);
        if (lvt_9_2_ == 0) {
            throw new CommandException("commands.clear.failure", lvt_4_1_.getName());
        }
        if (lvt_7_1_ == 0) {
            p_execute_2_.sendMessage(new TextComponentTranslation("commands.clear.testing", lvt_4_1_.getName(), lvt_9_2_));
        } else {
            CommandClearInventory.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.clear.success", lvt_4_1_.getName(), lvt_9_2_);
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer p_getTabCompletions_1_, ICommandSender p_getTabCompletions_2_, String[] p_getTabCompletions_3_, BlockPos p_getTabCompletions_4_) {
        if (p_getTabCompletions_3_.length == 1) {
            return CommandClearInventory.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, p_getTabCompletions_1_.getOnlinePlayerNames());
        }
        if (p_getTabCompletions_3_.length == 2) {
            return CommandClearInventory.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, Item.REGISTRY.getKeys());
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(String[] p_isUsernameIndex_1_, int p_isUsernameIndex_2_) {
        return p_isUsernameIndex_2_ == 0;
    }
}

