/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class CommandClone
extends CommandBase {
    @Override
    public String getName() {
        return "clone";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public String getUsage(ICommandSender p_getUsage_1_) {
        return "commands.clone.usage";
    }

    @Override
    public void execute(MinecraftServer p_execute_1_, ICommandSender p_execute_2_, String[] p_execute_3_) throws CommandException {
        if (p_execute_3_.length < 9) {
            throw new WrongUsageException("commands.clone.usage", new Object[0]);
        }
        p_execute_2_.setCommandStat(CommandResultStats.Type.AFFECTED_BLOCKS, 0);
        BlockPos lvt_4_1_ = CommandClone.parseBlockPos(p_execute_2_, p_execute_3_, 0, false);
        BlockPos lvt_5_1_ = CommandClone.parseBlockPos(p_execute_2_, p_execute_3_, 3, false);
        BlockPos lvt_6_1_ = CommandClone.parseBlockPos(p_execute_2_, p_execute_3_, 6, false);
        StructureBoundingBox lvt_7_1_ = new StructureBoundingBox(lvt_4_1_, lvt_5_1_);
        StructureBoundingBox lvt_8_1_ = new StructureBoundingBox(lvt_6_1_, lvt_6_1_.add(lvt_7_1_.getLength()));
        int lvt_9_1_ = lvt_7_1_.getXSize() * lvt_7_1_.getYSize() * lvt_7_1_.getZSize();
        if (lvt_9_1_ > 32768) {
            throw new CommandException("commands.clone.tooManyBlocks", lvt_9_1_, 32768);
        }
        boolean lvt_10_1_ = false;
        Block lvt_11_1_ = null;
        Predicate<IBlockState> lvt_12_1_ = null;
        if ((p_execute_3_.length < 11 || !"force".equals(p_execute_3_[10]) && !"move".equals(p_execute_3_[10])) && lvt_7_1_.intersectsWith(lvt_8_1_)) {
            throw new CommandException("commands.clone.noOverlap", new Object[0]);
        }
        if (p_execute_3_.length >= 11 && "move".equals(p_execute_3_[10])) {
            lvt_10_1_ = true;
        }
        if (lvt_7_1_.minY < 0 || lvt_7_1_.maxY >= 256 || lvt_8_1_.minY < 0 || lvt_8_1_.maxY >= 256) {
            throw new CommandException("commands.clone.outOfWorld", new Object[0]);
        }
        World lvt_13_1_ = p_execute_2_.getEntityWorld();
        if (!lvt_13_1_.isAreaLoaded(lvt_7_1_) || !lvt_13_1_.isAreaLoaded(lvt_8_1_)) {
            throw new CommandException("commands.clone.outOfWorld", new Object[0]);
        }
        boolean lvt_14_1_ = false;
        if (p_execute_3_.length >= 10) {
            if ("masked".equals(p_execute_3_[9])) {
                lvt_14_1_ = true;
            } else if ("filtered".equals(p_execute_3_[9])) {
                if (p_execute_3_.length < 12) {
                    throw new WrongUsageException("commands.clone.usage", new Object[0]);
                }
                lvt_11_1_ = CommandClone.getBlockByText(p_execute_2_, p_execute_3_[11]);
                if (p_execute_3_.length >= 13) {
                    lvt_12_1_ = CommandClone.convertArgToBlockStatePredicate(lvt_11_1_, p_execute_3_[12]);
                }
            }
        }
        ArrayList lvt_15_1_ = Lists.newArrayList();
        ArrayList lvt_16_1_ = Lists.newArrayList();
        ArrayList lvt_17_1_ = Lists.newArrayList();
        LinkedList lvt_18_1_ = Lists.newLinkedList();
        BlockPos lvt_19_1_ = new BlockPos(lvt_8_1_.minX - lvt_7_1_.minX, lvt_8_1_.minY - lvt_7_1_.minY, lvt_8_1_.minZ - lvt_7_1_.minZ);
        for (int lvt_20_1_ = lvt_7_1_.minZ; lvt_20_1_ <= lvt_7_1_.maxZ; ++lvt_20_1_) {
            for (int lvt_21_1_ = lvt_7_1_.minY; lvt_21_1_ <= lvt_7_1_.maxY; ++lvt_21_1_) {
                for (int lvt_22_1_ = lvt_7_1_.minX; lvt_22_1_ <= lvt_7_1_.maxX; ++lvt_22_1_) {
                    BlockPos lvt_23_1_ = new BlockPos(lvt_22_1_, lvt_21_1_, lvt_20_1_);
                    BlockPos lvt_24_1_ = lvt_23_1_.add(lvt_19_1_);
                    IBlockState lvt_25_1_ = lvt_13_1_.getBlockState(lvt_23_1_);
                    if (lvt_14_1_ && lvt_25_1_.getBlock() == Blocks.AIR || lvt_11_1_ != null && (lvt_25_1_.getBlock() != lvt_11_1_ || lvt_12_1_ != null && !lvt_12_1_.apply((Object)lvt_25_1_))) continue;
                    TileEntity lvt_26_1_ = lvt_13_1_.getTileEntity(lvt_23_1_);
                    if (lvt_26_1_ != null) {
                        NBTTagCompound lvt_27_1_ = lvt_26_1_.writeToNBT(new NBTTagCompound());
                        lvt_16_1_.add(new StaticCloneData(lvt_24_1_, lvt_25_1_, lvt_27_1_));
                        lvt_18_1_.addLast(lvt_23_1_);
                        continue;
                    }
                    if (lvt_25_1_.isFullBlock() || lvt_25_1_.isFullCube()) {
                        lvt_15_1_.add(new StaticCloneData(lvt_24_1_, lvt_25_1_, null));
                        lvt_18_1_.addLast(lvt_23_1_);
                        continue;
                    }
                    lvt_17_1_.add(new StaticCloneData(lvt_24_1_, lvt_25_1_, null));
                    lvt_18_1_.addFirst(lvt_23_1_);
                }
            }
        }
        if (lvt_10_1_) {
            for (BlockPos lvt_21_2_ : lvt_18_1_) {
                TileEntity lvt_22_2_ = lvt_13_1_.getTileEntity(lvt_21_2_);
                if (lvt_22_2_ instanceof IInventory) {
                    ((IInventory)((Object)lvt_22_2_)).clear();
                }
                lvt_13_1_.setBlockState(lvt_21_2_, Blocks.BARRIER.getDefaultState(), 2);
            }
            for (BlockPos lvt_21_3_ : lvt_18_1_) {
                lvt_13_1_.setBlockState(lvt_21_3_, Blocks.AIR.getDefaultState(), 3);
            }
        }
        ArrayList lvt_20_2_ = Lists.newArrayList();
        lvt_20_2_.addAll(lvt_15_1_);
        lvt_20_2_.addAll(lvt_16_1_);
        lvt_20_2_.addAll(lvt_17_1_);
        List lvt_21_4_ = Lists.reverse((List)lvt_20_2_);
        for (StaticCloneData lvt_23_2_ : lvt_21_4_) {
            TileEntity lvt_24_2_ = lvt_13_1_.getTileEntity(lvt_23_2_.pos);
            if (lvt_24_2_ instanceof IInventory) {
                ((IInventory)((Object)lvt_24_2_)).clear();
            }
            lvt_13_1_.setBlockState(lvt_23_2_.pos, Blocks.BARRIER.getDefaultState(), 2);
        }
        lvt_9_1_ = 0;
        for (StaticCloneData lvt_23_3_ : lvt_20_2_) {
            if (!lvt_13_1_.setBlockState(lvt_23_3_.pos, lvt_23_3_.blockState, 2)) continue;
            ++lvt_9_1_;
        }
        for (StaticCloneData lvt_23_4_ : lvt_16_1_) {
            TileEntity lvt_24_3_ = lvt_13_1_.getTileEntity(lvt_23_4_.pos);
            if (lvt_23_4_.nbt != null && lvt_24_3_ != null) {
                lvt_23_4_.nbt.setInteger("x", lvt_23_4_.pos.getX());
                lvt_23_4_.nbt.setInteger("y", lvt_23_4_.pos.getY());
                lvt_23_4_.nbt.setInteger("z", lvt_23_4_.pos.getZ());
                lvt_24_3_.readFromNBT(lvt_23_4_.nbt);
                lvt_24_3_.markDirty();
            }
            lvt_13_1_.setBlockState(lvt_23_4_.pos, lvt_23_4_.blockState, 2);
        }
        for (StaticCloneData lvt_23_5_ : lvt_21_4_) {
            lvt_13_1_.notifyNeighborsRespectDebug(lvt_23_5_.pos, lvt_23_5_.blockState.getBlock(), false);
        }
        List<NextTickListEntry> lvt_22_3_ = lvt_13_1_.getPendingBlockUpdates(lvt_7_1_, false);
        if (lvt_22_3_ != null) {
            for (NextTickListEntry lvt_24_4_ : lvt_22_3_) {
                if (!lvt_7_1_.isVecInside(lvt_24_4_.position)) continue;
                BlockPos lvt_25_2_ = lvt_24_4_.position.add(lvt_19_1_);
                lvt_13_1_.scheduleBlockUpdate(lvt_25_2_, lvt_24_4_.getBlock(), (int)(lvt_24_4_.scheduledTime - lvt_13_1_.getWorldInfo().getWorldTotalTime()), lvt_24_4_.priority);
            }
        }
        if (lvt_9_1_ <= 0) {
            throw new CommandException("commands.clone.failed", new Object[0]);
        }
        p_execute_2_.setCommandStat(CommandResultStats.Type.AFFECTED_BLOCKS, lvt_9_1_);
        CommandClone.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.clone.success", lvt_9_1_);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer p_getTabCompletions_1_, ICommandSender p_getTabCompletions_2_, String[] p_getTabCompletions_3_, BlockPos p_getTabCompletions_4_) {
        if (p_getTabCompletions_3_.length > 0 && p_getTabCompletions_3_.length <= 3) {
            return CommandClone.getTabCompletionCoordinate(p_getTabCompletions_3_, 0, p_getTabCompletions_4_);
        }
        if (p_getTabCompletions_3_.length > 3 && p_getTabCompletions_3_.length <= 6) {
            return CommandClone.getTabCompletionCoordinate(p_getTabCompletions_3_, 3, p_getTabCompletions_4_);
        }
        if (p_getTabCompletions_3_.length > 6 && p_getTabCompletions_3_.length <= 9) {
            return CommandClone.getTabCompletionCoordinate(p_getTabCompletions_3_, 6, p_getTabCompletions_4_);
        }
        if (p_getTabCompletions_3_.length == 10) {
            return CommandClone.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, "replace", "masked", "filtered");
        }
        if (p_getTabCompletions_3_.length == 11) {
            return CommandClone.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, "normal", "force", "move");
        }
        if (p_getTabCompletions_3_.length == 12 && "filtered".equals(p_getTabCompletions_3_[9])) {
            return CommandClone.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, Block.REGISTRY.getKeys());
        }
        return Collections.emptyList();
    }

    static class StaticCloneData {
        public final BlockPos pos;
        public final IBlockState blockState;
        public final NBTTagCompound nbt;

        public StaticCloneData(BlockPos p_i46037_1_, IBlockState p_i46037_2_, NBTTagCompound p_i46037_3_) {
            this.pos = p_i46037_1_;
            this.blockState = p_i46037_2_;
            this.nbt = p_i46037_3_;
        }
    }
}

