/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import java.util.Collections;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class CommandCompare
extends CommandBase {
    @Override
    public String getName() {
        return "testforblocks";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public String getUsage(ICommandSender p_getUsage_1_) {
        return "commands.compare.usage";
    }

    @Override
    public void execute(MinecraftServer p_execute_1_, ICommandSender p_execute_2_, String[] p_execute_3_) throws CommandException {
        if (p_execute_3_.length < 9) {
            throw new WrongUsageException("commands.compare.usage", new Object[0]);
        }
        p_execute_2_.setCommandStat(CommandResultStats.Type.AFFECTED_BLOCKS, 0);
        BlockPos lvt_4_1_ = CommandCompare.parseBlockPos(p_execute_2_, p_execute_3_, 0, false);
        BlockPos lvt_5_1_ = CommandCompare.parseBlockPos(p_execute_2_, p_execute_3_, 3, false);
        BlockPos lvt_6_1_ = CommandCompare.parseBlockPos(p_execute_2_, p_execute_3_, 6, false);
        StructureBoundingBox lvt_7_1_ = new StructureBoundingBox(lvt_4_1_, lvt_5_1_);
        StructureBoundingBox lvt_8_1_ = new StructureBoundingBox(lvt_6_1_, lvt_6_1_.add(lvt_7_1_.getLength()));
        int lvt_9_1_ = lvt_7_1_.getXSize() * lvt_7_1_.getYSize() * lvt_7_1_.getZSize();
        if (lvt_9_1_ > 524288) {
            throw new CommandException("commands.compare.tooManyBlocks", lvt_9_1_, 524288);
        }
        if (lvt_7_1_.minY < 0 || lvt_7_1_.maxY >= 256 || lvt_8_1_.minY < 0 || lvt_8_1_.maxY >= 256) {
            throw new CommandException("commands.compare.outOfWorld", new Object[0]);
        }
        World lvt_10_1_ = p_execute_2_.getEntityWorld();
        if (!lvt_10_1_.isAreaLoaded(lvt_7_1_) || !lvt_10_1_.isAreaLoaded(lvt_8_1_)) {
            throw new CommandException("commands.compare.outOfWorld", new Object[0]);
        }
        boolean lvt_11_1_ = false;
        if (p_execute_3_.length > 9 && "masked".equals(p_execute_3_[9])) {
            lvt_11_1_ = true;
        }
        lvt_9_1_ = 0;
        BlockPos lvt_12_1_ = new BlockPos(lvt_8_1_.minX - lvt_7_1_.minX, lvt_8_1_.minY - lvt_7_1_.minY, lvt_8_1_.minZ - lvt_7_1_.minZ);
        BlockPos.MutableBlockPos lvt_13_1_ = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos lvt_14_1_ = new BlockPos.MutableBlockPos();
        for (int lvt_15_1_ = lvt_7_1_.minZ; lvt_15_1_ <= lvt_7_1_.maxZ; ++lvt_15_1_) {
            for (int lvt_16_1_ = lvt_7_1_.minY; lvt_16_1_ <= lvt_7_1_.maxY; ++lvt_16_1_) {
                for (int lvt_17_1_ = lvt_7_1_.minX; lvt_17_1_ <= lvt_7_1_.maxX; ++lvt_17_1_) {
                    lvt_13_1_.setPos(lvt_17_1_, lvt_16_1_, lvt_15_1_);
                    lvt_14_1_.setPos(lvt_17_1_ + lvt_12_1_.getX(), lvt_16_1_ + lvt_12_1_.getY(), lvt_15_1_ + lvt_12_1_.getZ());
                    boolean lvt_18_1_ = false;
                    IBlockState lvt_19_1_ = lvt_10_1_.getBlockState(lvt_13_1_);
                    if (lvt_11_1_ && lvt_19_1_.getBlock() == Blocks.AIR) continue;
                    if (lvt_19_1_ == lvt_10_1_.getBlockState(lvt_14_1_)) {
                        TileEntity lvt_20_1_ = lvt_10_1_.getTileEntity(lvt_13_1_);
                        TileEntity lvt_21_1_ = lvt_10_1_.getTileEntity(lvt_14_1_);
                        if (lvt_20_1_ != null && lvt_21_1_ != null) {
                            NBTTagCompound lvt_22_1_ = lvt_20_1_.writeToNBT(new NBTTagCompound());
                            lvt_22_1_.removeTag("x");
                            lvt_22_1_.removeTag("y");
                            lvt_22_1_.removeTag("z");
                            NBTTagCompound lvt_23_1_ = lvt_21_1_.writeToNBT(new NBTTagCompound());
                            lvt_23_1_.removeTag("x");
                            lvt_23_1_.removeTag("y");
                            lvt_23_1_.removeTag("z");
                            if (!lvt_22_1_.equals(lvt_23_1_)) {
                                lvt_18_1_ = true;
                            }
                        } else if (lvt_20_1_ != null) {
                            lvt_18_1_ = true;
                        }
                    } else {
                        lvt_18_1_ = true;
                    }
                    ++lvt_9_1_;
                    if (!lvt_18_1_) continue;
                    throw new CommandException("commands.compare.failed", new Object[0]);
                }
            }
        }
        p_execute_2_.setCommandStat(CommandResultStats.Type.AFFECTED_BLOCKS, lvt_9_1_);
        CommandCompare.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.compare.success", lvt_9_1_);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer p_getTabCompletions_1_, ICommandSender p_getTabCompletions_2_, String[] p_getTabCompletions_3_, BlockPos p_getTabCompletions_4_) {
        if (p_getTabCompletions_3_.length > 0 && p_getTabCompletions_3_.length <= 3) {
            return CommandCompare.getTabCompletionCoordinate(p_getTabCompletions_3_, 0, p_getTabCompletions_4_);
        }
        if (p_getTabCompletions_3_.length > 3 && p_getTabCompletions_3_.length <= 6) {
            return CommandCompare.getTabCompletionCoordinate(p_getTabCompletions_3_, 3, p_getTabCompletions_4_);
        }
        if (p_getTabCompletions_3_.length > 6 && p_getTabCompletions_3_.length <= 9) {
            return CommandCompare.getTabCompletionCoordinate(p_getTabCompletions_3_, 6, p_getTabCompletions_4_);
        }
        if (p_getTabCompletions_3_.length == 10) {
            return CommandCompare.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, "masked", "all");
        }
        return Collections.emptyList();
    }
}

