/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.profiler.Profiler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommandDebug
extends CommandBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private long profileStartTime;
    private int profileStartTick;

    @Override
    public String getName() {
        return "debug";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 3;
    }

    @Override
    public String getUsage(ICommandSender p_getUsage_1_) {
        return "commands.debug.usage";
    }

    @Override
    public void execute(MinecraftServer p_execute_1_, ICommandSender p_execute_2_, String[] p_execute_3_) throws CommandException {
        if (p_execute_3_.length < 1) {
            throw new WrongUsageException("commands.debug.usage", new Object[0]);
        }
        if ("start".equals(p_execute_3_[0])) {
            if (p_execute_3_.length != 1) {
                throw new WrongUsageException("commands.debug.usage", new Object[0]);
            }
            CommandDebug.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.debug.start", new Object[0]);
            p_execute_1_.enableProfiling();
            this.profileStartTime = MinecraftServer.getCurrentTimeMillis();
            this.profileStartTick = p_execute_1_.getTickCounter();
        } else if ("stop".equals(p_execute_3_[0])) {
            if (p_execute_3_.length != 1) {
                throw new WrongUsageException("commands.debug.usage", new Object[0]);
            }
            if (!p_execute_1_.theProfiler.profilingEnabled) {
                throw new CommandException("commands.debug.notStarted", new Object[0]);
            }
            long lvt_4_1_ = MinecraftServer.getCurrentTimeMillis();
            int lvt_6_1_ = p_execute_1_.getTickCounter();
            long lvt_7_1_ = lvt_4_1_ - this.profileStartTime;
            int lvt_9_1_ = lvt_6_1_ - this.profileStartTick;
            this.saveProfilerResults(lvt_7_1_, lvt_9_1_, p_execute_1_);
            p_execute_1_.theProfiler.profilingEnabled = false;
            CommandDebug.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.debug.stop", String.format("%.2f", Float.valueOf((float)lvt_7_1_ / 1000.0f)), lvt_9_1_);
        } else {
            throw new WrongUsageException("commands.debug.usage", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveProfilerResults(long p_saveProfilerResults_1_, int p_saveProfilerResults_3_, MinecraftServer p_saveProfilerResults_4_) {
        File lvt_5_1_ = new File(p_saveProfilerResults_4_.getFile("debug"), "profile-results-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + ".txt");
        lvt_5_1_.getParentFile().mkdirs();
        FileWriter lvt_6_1_ = null;
        try {
            lvt_6_1_ = new FileWriter(lvt_5_1_);
            lvt_6_1_.write(this.getProfilerResults(p_saveProfilerResults_1_, p_saveProfilerResults_3_, p_saveProfilerResults_4_));
        }
        catch (Throwable lvt_7_1_) {
            try {
                LOGGER.error("Could not save profiler results to {}", new Object[]{lvt_5_1_, lvt_7_1_});
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(lvt_6_1_);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)lvt_6_1_);
        }
        IOUtils.closeQuietly((Writer)lvt_6_1_);
    }

    private String getProfilerResults(long p_getProfilerResults_1_, int p_getProfilerResults_3_, MinecraftServer p_getProfilerResults_4_) {
        StringBuilder lvt_5_1_ = new StringBuilder();
        lvt_5_1_.append("---- Minecraft Profiler Results ----\n");
        lvt_5_1_.append("// ");
        lvt_5_1_.append(CommandDebug.getWittyComment());
        lvt_5_1_.append("\n\n");
        lvt_5_1_.append("Time span: ").append(p_getProfilerResults_1_).append(" ms\n");
        lvt_5_1_.append("Tick span: ").append(p_getProfilerResults_3_).append(" ticks\n");
        lvt_5_1_.append("// This is approximately ").append(String.format("%.2f", Float.valueOf((float)p_getProfilerResults_3_ / ((float)p_getProfilerResults_1_ / 1000.0f)))).append(" ticks per second. It should be ").append(20).append(" ticks per second\n\n");
        lvt_5_1_.append("--- BEGIN PROFILE DUMP ---\n\n");
        this.appendProfilerResults(0, "root", lvt_5_1_, p_getProfilerResults_4_);
        lvt_5_1_.append("--- END PROFILE DUMP ---\n\n");
        return lvt_5_1_.toString();
    }

    private void appendProfilerResults(int p_appendProfilerResults_1_, String p_appendProfilerResults_2_, StringBuilder p_appendProfilerResults_3_, MinecraftServer p_appendProfilerResults_4_) {
        List<Profiler.Result> lvt_5_1_ = p_appendProfilerResults_4_.theProfiler.getProfilingData(p_appendProfilerResults_2_);
        if (lvt_5_1_ == null || lvt_5_1_.size() < 3) {
            return;
        }
        for (int lvt_6_1_ = 1; lvt_6_1_ < lvt_5_1_.size(); ++lvt_6_1_) {
            Profiler.Result lvt_7_1_ = lvt_5_1_.get(lvt_6_1_);
            p_appendProfilerResults_3_.append(String.format("[%02d] ", p_appendProfilerResults_1_));
            for (int lvt_8_1_ = 0; lvt_8_1_ < p_appendProfilerResults_1_; ++lvt_8_1_) {
                p_appendProfilerResults_3_.append("|   ");
            }
            p_appendProfilerResults_3_.append(lvt_7_1_.profilerName).append(" - ").append(String.format("%.2f", lvt_7_1_.usePercentage)).append("%/").append(String.format("%.2f", lvt_7_1_.totalUsePercentage)).append("%\n");
            if ("unspecified".equals(lvt_7_1_.profilerName)) continue;
            try {
                this.appendProfilerResults(p_appendProfilerResults_1_ + 1, p_appendProfilerResults_2_ + "." + lvt_7_1_.profilerName, p_appendProfilerResults_3_, p_appendProfilerResults_4_);
                continue;
            }
            catch (Exception lvt_8_2_) {
                p_appendProfilerResults_3_.append("[[ EXCEPTION ").append(lvt_8_2_).append(" ]]");
            }
        }
    }

    private static String getWittyComment() {
        String[] lvt_0_1_ = new String[]{"Shiny numbers!", "Am I not running fast enough? :(", "I'm working as hard as I can!", "Will I ever be good enough for you? :(", "Speedy. Zoooooom!", "Hello world", "40% better than a crash report.", "Now with extra numbers", "Now with less numbers", "Now with the same numbers", "You should add flames to things, it makes them go faster!", "Do you feel the need for... optimization?", "*cracks redstone whip*", "Maybe if you treated it better then it'll have more motivation to work faster! Poor server."};
        try {
            return lvt_0_1_[(int)(System.nanoTime() % (long)lvt_0_1_.length)];
        }
        catch (Throwable lvt_1_1_) {
            return "Witty comment unavailable :(";
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer p_getTabCompletions_1_, ICommandSender p_getTabCompletions_2_, String[] p_getTabCompletions_3_, BlockPos p_getTabCompletions_4_) {
        if (p_getTabCompletions_3_.length == 1) {
            return CommandDebug.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, "start", "stop");
        }
        return Collections.emptyList();
    }
}

