/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.EnumDifficulty;

public class CommandDifficulty
extends CommandBase {
    @Override
    public String getName() {
        return "difficulty";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public String getUsage(ICommandSender p_getUsage_1_) {
        return "commands.difficulty.usage";
    }

    @Override
    public void execute(MinecraftServer p_execute_1_, ICommandSender p_execute_2_, String[] p_execute_3_) throws CommandException {
        if (p_execute_3_.length <= 0) {
            throw new WrongUsageException("commands.difficulty.usage", new Object[0]);
        }
        EnumDifficulty lvt_4_1_ = this.getDifficultyFromCommand(p_execute_3_[0]);
        p_execute_1_.setDifficultyForAllWorlds(lvt_4_1_);
        CommandDifficulty.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.difficulty.success", new TextComponentTranslation(lvt_4_1_.getDifficultyResourceKey(), new Object[0]));
    }

    protected EnumDifficulty getDifficultyFromCommand(String p_getDifficultyFromCommand_1_) throws CommandException, NumberInvalidException {
        if ("peaceful".equalsIgnoreCase(p_getDifficultyFromCommand_1_) || "p".equalsIgnoreCase(p_getDifficultyFromCommand_1_)) {
            return EnumDifficulty.PEACEFUL;
        }
        if ("easy".equalsIgnoreCase(p_getDifficultyFromCommand_1_) || "e".equalsIgnoreCase(p_getDifficultyFromCommand_1_)) {
            return EnumDifficulty.EASY;
        }
        if ("normal".equalsIgnoreCase(p_getDifficultyFromCommand_1_) || "n".equalsIgnoreCase(p_getDifficultyFromCommand_1_)) {
            return EnumDifficulty.NORMAL;
        }
        if ("hard".equalsIgnoreCase(p_getDifficultyFromCommand_1_) || "h".equalsIgnoreCase(p_getDifficultyFromCommand_1_)) {
            return EnumDifficulty.HARD;
        }
        return EnumDifficulty.getDifficultyEnum(CommandDifficulty.parseInt(p_getDifficultyFromCommand_1_, 0, 3));
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer p_getTabCompletions_1_, ICommandSender p_getTabCompletions_2_, String[] p_getTabCompletions_3_, BlockPos p_getTabCompletions_4_) {
        if (p_getTabCompletions_3_.length == 1) {
            return CommandDifficulty.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, "peaceful", "easy", "normal", "hard");
        }
        return Collections.emptyList();
    }
}

