/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;

public class CommandEffect
extends CommandBase {
    @Override
    public String getName() {
        return "effect";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public String getUsage(ICommandSender p_getUsage_1_) {
        return "commands.effect.usage";
    }

    @Override
    public void execute(MinecraftServer p_execute_1_, ICommandSender p_execute_2_, String[] p_execute_3_) throws CommandException {
        Potion lvt_5_2_;
        if (p_execute_3_.length < 2) {
            throw new WrongUsageException("commands.effect.usage", new Object[0]);
        }
        EntityLivingBase lvt_4_1_ = CommandEffect.getEntity(p_execute_1_, p_execute_2_, p_execute_3_[0], EntityLivingBase.class);
        if ("clear".equals(p_execute_3_[1])) {
            if (lvt_4_1_.getActivePotionEffects().isEmpty()) {
                throw new CommandException("commands.effect.failure.notActive.all", lvt_4_1_.getName());
            }
            lvt_4_1_.clearActivePotions();
            CommandEffect.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.effect.success.removed.all", lvt_4_1_.getName());
            return;
        }
        try {
            Potion lvt_5_1_ = Potion.getPotionById(CommandEffect.parseInt(p_execute_3_[1], 1));
        }
        catch (NumberInvalidException lvt_6_1_) {
            lvt_5_2_ = Potion.getPotionFromResourceLocation(p_execute_3_[1]);
        }
        if (lvt_5_2_ == null) {
            throw new NumberInvalidException("commands.effect.notFound", p_execute_3_[1]);
        }
        int lvt_6_2_ = 600;
        int lvt_7_1_ = 30;
        int lvt_8_1_ = 0;
        if (p_execute_3_.length >= 3) {
            lvt_7_1_ = CommandEffect.parseInt(p_execute_3_[2], 0, 1000000);
            lvt_6_2_ = lvt_5_2_.isInstant() ? lvt_7_1_ : lvt_7_1_ * 20;
        } else if (lvt_5_2_.isInstant()) {
            lvt_6_2_ = 1;
        }
        if (p_execute_3_.length >= 4) {
            lvt_8_1_ = CommandEffect.parseInt(p_execute_3_[3], 0, 255);
        }
        boolean lvt_9_1_ = true;
        if (p_execute_3_.length >= 5 && "true".equalsIgnoreCase(p_execute_3_[4])) {
            lvt_9_1_ = false;
        }
        if (lvt_7_1_ > 0) {
            PotionEffect lvt_10_1_ = new PotionEffect(lvt_5_2_, lvt_6_2_, lvt_8_1_, false, lvt_9_1_);
            lvt_4_1_.addPotionEffect(lvt_10_1_);
            CommandEffect.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.effect.success", new TextComponentTranslation(lvt_10_1_.getEffectName(), new Object[0]), Potion.getIdFromPotion(lvt_5_2_), lvt_8_1_, lvt_4_1_.getName(), lvt_7_1_);
            return;
        }
        if (!lvt_4_1_.isPotionActive(lvt_5_2_)) {
            throw new CommandException("commands.effect.failure.notActive", new TextComponentTranslation(lvt_5_2_.getName(), new Object[0]), lvt_4_1_.getName());
        }
        lvt_4_1_.removePotionEffect(lvt_5_2_);
        CommandEffect.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.effect.success.removed", new TextComponentTranslation(lvt_5_2_.getName(), new Object[0]), lvt_4_1_.getName());
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer p_getTabCompletions_1_, ICommandSender p_getTabCompletions_2_, String[] p_getTabCompletions_3_, BlockPos p_getTabCompletions_4_) {
        if (p_getTabCompletions_3_.length == 1) {
            return CommandEffect.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, p_getTabCompletions_1_.getOnlinePlayerNames());
        }
        if (p_getTabCompletions_3_.length == 2) {
            return CommandEffect.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, Potion.REGISTRY.getKeys());
        }
        if (p_getTabCompletions_3_.length == 5) {
            return CommandEffect.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, "true", "false");
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(String[] p_isUsernameIndex_1_, int p_isUsernameIndex_2_) {
        return p_isUsernameIndex_2_ == 0;
    }
}

