/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public class CommandEnchant
extends CommandBase {
    @Override
    public String getName() {
        return "enchant";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public String getUsage(ICommandSender p_getUsage_1_) {
        return "commands.enchant.usage";
    }

    @Override
    public void execute(MinecraftServer p_execute_1_, ICommandSender p_execute_2_, String[] p_execute_3_) throws CommandException {
        NBTTagList lvt_8_1_;
        Enchantment lvt_5_2_;
        if (p_execute_3_.length < 2) {
            throw new WrongUsageException("commands.enchant.usage", new Object[0]);
        }
        EntityLivingBase lvt_4_1_ = CommandEnchant.getEntity(p_execute_1_, p_execute_2_, p_execute_3_[0], EntityLivingBase.class);
        p_execute_2_.setCommandStat(CommandResultStats.Type.AFFECTED_ITEMS, 0);
        try {
            Enchantment lvt_5_1_ = Enchantment.getEnchantmentByID(CommandEnchant.parseInt(p_execute_3_[1], 0));
        }
        catch (NumberInvalidException lvt_6_1_) {
            lvt_5_2_ = Enchantment.getEnchantmentByLocation(p_execute_3_[1]);
        }
        if (lvt_5_2_ == null) {
            throw new NumberInvalidException("commands.enchant.notFound", p_execute_3_[1]);
        }
        int lvt_6_2_ = 1;
        ItemStack lvt_7_1_ = lvt_4_1_.getHeldItemMainhand();
        if (lvt_7_1_.isEmpty()) {
            throw new CommandException("commands.enchant.noItem", new Object[0]);
        }
        if (!lvt_5_2_.canApply(lvt_7_1_)) {
            throw new CommandException("commands.enchant.cantEnchant", new Object[0]);
        }
        if (p_execute_3_.length >= 3) {
            lvt_6_2_ = CommandEnchant.parseInt(p_execute_3_[2], lvt_5_2_.getMinLevel(), lvt_5_2_.getMaxLevel());
        }
        if (lvt_7_1_.hasTagCompound() && (lvt_8_1_ = lvt_7_1_.getEnchantmentTagList()) != null) {
            for (int lvt_9_1_ = 0; lvt_9_1_ < lvt_8_1_.tagCount(); ++lvt_9_1_) {
                Enchantment lvt_11_1_;
                short lvt_10_1_ = lvt_8_1_.getCompoundTagAt(lvt_9_1_).getShort("id");
                if (Enchantment.getEnchantmentByID(lvt_10_1_) == null || lvt_5_2_.func_191560_c(lvt_11_1_ = Enchantment.getEnchantmentByID(lvt_10_1_))) continue;
                throw new CommandException("commands.enchant.cantCombine", lvt_5_2_.getTranslatedName(lvt_6_2_), lvt_11_1_.getTranslatedName(lvt_8_1_.getCompoundTagAt(lvt_9_1_).getShort("lvl")));
            }
        }
        lvt_7_1_.addEnchantment(lvt_5_2_, lvt_6_2_);
        CommandEnchant.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.enchant.success", new Object[0]);
        p_execute_2_.setCommandStat(CommandResultStats.Type.AFFECTED_ITEMS, 1);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer p_getTabCompletions_1_, ICommandSender p_getTabCompletions_2_, String[] p_getTabCompletions_3_, BlockPos p_getTabCompletions_4_) {
        if (p_getTabCompletions_3_.length == 1) {
            return CommandEnchant.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, p_getTabCompletions_1_.getOnlinePlayerNames());
        }
        if (p_getTabCompletions_3_.length == 2) {
            return CommandEnchant.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, Enchantment.REGISTRY.getKeys());
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(String[] p_isUsernameIndex_1_, int p_isUsernameIndex_2_) {
        return p_isUsernameIndex_2_ == 0;
    }
}

