/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import java.util.UUID;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;

public class CommandEntityData
extends CommandBase {
    @Override
    public String getName() {
        return "entitydata";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public String getUsage(ICommandSender p_getUsage_1_) {
        return "commands.entitydata.usage";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void execute(MinecraftServer p_execute_1_, ICommandSender p_execute_2_, String[] p_execute_3_) throws CommandException {
        void lvt_7_2_;
        if (p_execute_3_.length < 2) {
            throw new WrongUsageException("commands.entitydata.usage", new Object[0]);
        }
        Entity lvt_4_1_ = CommandEntityData.getEntity(p_execute_1_, p_execute_2_, p_execute_3_[0]);
        if (lvt_4_1_ instanceof EntityPlayer) {
            throw new CommandException("commands.entitydata.noPlayers", lvt_4_1_.getDisplayName());
        }
        NBTTagCompound lvt_5_1_ = CommandEntityData.entityToNBT(lvt_4_1_);
        NBTTagCompound lvt_6_1_ = lvt_5_1_.copy();
        try {
            NBTTagCompound lvt_7_1_ = JsonToNBT.getTagFromJson(CommandEntityData.getChatComponentFromNthArg(p_execute_2_, p_execute_3_, 1).getUnformattedText());
        }
        catch (NBTException lvt_8_1_) {
            throw new CommandException("commands.entitydata.tagError", lvt_8_1_.getMessage());
        }
        UUID lvt_8_2_ = lvt_4_1_.getUniqueID();
        lvt_5_1_.merge((NBTTagCompound)lvt_7_2_);
        lvt_4_1_.setUniqueId(lvt_8_2_);
        if (lvt_5_1_.equals(lvt_6_1_)) {
            throw new CommandException("commands.entitydata.failed", lvt_5_1_.toString());
        }
        lvt_4_1_.readFromNBT(lvt_5_1_);
        CommandEntityData.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.entitydata.success", lvt_5_1_.toString());
    }

    @Override
    public boolean isUsernameIndex(String[] p_isUsernameIndex_1_, int p_isUsernameIndex_2_) {
        return p_isUsernameIndex_2_ == 0;
    }
}

