/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class CommandExecuteAt
extends CommandBase {
    @Override
    public String getName() {
        return "execute";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public String getUsage(ICommandSender p_getUsage_1_) {
        return "commands.execute.usage";
    }

    @Override
    public void execute(final MinecraftServer p_execute_1_, final ICommandSender p_execute_2_, String[] p_execute_3_) throws CommandException {
        if (p_execute_3_.length < 5) {
            throw new WrongUsageException("commands.execute.usage", new Object[0]);
        }
        final Entity lvt_4_1_ = CommandExecuteAt.getEntity(p_execute_1_, p_execute_2_, p_execute_3_[0], Entity.class);
        final double lvt_5_1_ = CommandExecuteAt.parseDouble(lvt_4_1_.posX, p_execute_3_[1], false);
        final double lvt_7_1_ = CommandExecuteAt.parseDouble(lvt_4_1_.posY, p_execute_3_[2], false);
        final double lvt_9_1_ = CommandExecuteAt.parseDouble(lvt_4_1_.posZ, p_execute_3_[3], false);
        final BlockPos lvt_11_1_ = new BlockPos(lvt_5_1_, lvt_7_1_, lvt_9_1_);
        int lvt_12_1_ = 4;
        if ("detect".equals(p_execute_3_[4]) && p_execute_3_.length > 10) {
            World lvt_13_1_ = lvt_4_1_.getEntityWorld();
            double lvt_14_1_ = CommandExecuteAt.parseDouble(lvt_5_1_, p_execute_3_[5], false);
            double lvt_16_1_ = CommandExecuteAt.parseDouble(lvt_7_1_, p_execute_3_[6], false);
            double lvt_18_1_ = CommandExecuteAt.parseDouble(lvt_9_1_, p_execute_3_[7], false);
            Block lvt_20_1_ = CommandExecuteAt.getBlockByText(p_execute_2_, p_execute_3_[8]);
            BlockPos lvt_21_1_ = new BlockPos(lvt_14_1_, lvt_16_1_, lvt_18_1_);
            if (!lvt_13_1_.isBlockLoaded(lvt_21_1_)) {
                throw new CommandException("commands.execute.failed", "detect", lvt_4_1_.getName());
            }
            IBlockState lvt_22_1_ = lvt_13_1_.getBlockState(lvt_21_1_);
            if (lvt_22_1_.getBlock() != lvt_20_1_) {
                throw new CommandException("commands.execute.failed", "detect", lvt_4_1_.getName());
            }
            if (!CommandBase.convertArgToBlockStatePredicate(lvt_20_1_, p_execute_3_[9]).apply((Object)lvt_22_1_)) {
                throw new CommandException("commands.execute.failed", "detect", lvt_4_1_.getName());
            }
            lvt_12_1_ = 10;
        }
        String lvt_13_2_ = CommandExecuteAt.buildString(p_execute_3_, lvt_12_1_);
        ICommandSender lvt_14_2_ = new ICommandSender(){

            @Override
            public String getName() {
                return lvt_4_1_.getName();
            }

            @Override
            public ITextComponent getDisplayName() {
                return lvt_4_1_.getDisplayName();
            }

            @Override
            public void sendMessage(ITextComponent p_sendMessage_1_) {
                p_execute_2_.sendMessage(p_sendMessage_1_);
            }

            @Override
            public boolean canUseCommand(int p_canUseCommand_1_, String p_canUseCommand_2_) {
                return p_execute_2_.canUseCommand(p_canUseCommand_1_, p_canUseCommand_2_);
            }

            @Override
            public BlockPos getPosition() {
                return lvt_11_1_;
            }

            @Override
            public Vec3d getPositionVector() {
                return new Vec3d(lvt_5_1_, lvt_7_1_, lvt_9_1_);
            }

            @Override
            public World getEntityWorld() {
                return lvt_4_1_.world;
            }

            @Override
            public Entity getCommandSenderEntity() {
                return lvt_4_1_;
            }

            @Override
            public boolean sendCommandFeedback() {
                return p_execute_1_ == null || p_execute_1_.worlds[0].getGameRules().getBoolean("commandBlockOutput");
            }

            @Override
            public void setCommandStat(CommandResultStats.Type p_setCommandStat_1_, int p_setCommandStat_2_) {
                lvt_4_1_.setCommandStat(p_setCommandStat_1_, p_setCommandStat_2_);
            }

            @Override
            public MinecraftServer getServer() {
                return lvt_4_1_.getServer();
            }
        };
        ICommandManager lvt_15_1_ = p_execute_1_.getCommandManager();
        try {
            int lvt_16_2_ = lvt_15_1_.executeCommand(lvt_14_2_, lvt_13_2_);
            if (lvt_16_2_ < 1) {
                throw new CommandException("commands.execute.allInvocationsFailed", lvt_13_2_);
            }
        }
        catch (Throwable lvt_16_3_) {
            throw new CommandException("commands.execute.failed", lvt_13_2_, lvt_4_1_.getName());
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer p_getTabCompletions_1_, ICommandSender p_getTabCompletions_2_, String[] p_getTabCompletions_3_, BlockPos p_getTabCompletions_4_) {
        if (p_getTabCompletions_3_.length == 1) {
            return CommandExecuteAt.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, p_getTabCompletions_1_.getOnlinePlayerNames());
        }
        if (p_getTabCompletions_3_.length > 1 && p_getTabCompletions_3_.length <= 4) {
            return CommandExecuteAt.getTabCompletionCoordinate(p_getTabCompletions_3_, 1, p_getTabCompletions_4_);
        }
        if (p_getTabCompletions_3_.length > 5 && p_getTabCompletions_3_.length <= 8 && "detect".equals(p_getTabCompletions_3_[4])) {
            return CommandExecuteAt.getTabCompletionCoordinate(p_getTabCompletions_3_, 5, p_getTabCompletions_4_);
        }
        if (p_getTabCompletions_3_.length == 9 && "detect".equals(p_getTabCompletions_3_[4])) {
            return CommandExecuteAt.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, Block.REGISTRY.getKeys());
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(String[] p_isUsernameIndex_1_, int p_isUsernameIndex_2_) {
        return p_isUsernameIndex_2_ == 0;
    }
}

