/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CommandFill
extends CommandBase {
    @Override
    public String getName() {
        return "fill";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public String getUsage(ICommandSender p_getUsage_1_) {
        return "commands.fill.usage";
    }

    @Override
    public void execute(MinecraftServer p_execute_1_, ICommandSender p_execute_2_, String[] p_execute_3_) throws CommandException {
        int i;
        block22: {
            block17: {
                if (p_execute_3_.length < 7) {
                    throw new WrongUsageException("commands.fill.usage", new Object[0]);
                }
                p_execute_2_.setCommandStat(CommandResultStats.Type.AFFECTED_BLOCKS, 0);
                BlockPos blockpos = CommandFill.parseBlockPos(p_execute_2_, p_execute_3_, 0, false);
                BlockPos blockpos1 = CommandFill.parseBlockPos(p_execute_2_, p_execute_3_, 3, false);
                Block block = CommandBase.getBlockByText(p_execute_2_, p_execute_3_[6]);
                IBlockState iblockstate = p_execute_3_.length >= 8 ? CommandFill.convertArgToBlockState(block, p_execute_3_[7]) : block.getDefaultState();
                BlockPos blockpos2 = new BlockPos(Math.min(blockpos.getX(), blockpos1.getX()), Math.min(blockpos.getY(), blockpos1.getY()), Math.min(blockpos.getZ(), blockpos1.getZ()));
                BlockPos blockpos3 = new BlockPos(Math.max(blockpos.getX(), blockpos1.getX()), Math.max(blockpos.getY(), blockpos1.getY()), Math.max(blockpos.getZ(), blockpos1.getZ()));
                i = (blockpos3.getX() - blockpos2.getX() + 1) * (blockpos3.getY() - blockpos2.getY() + 1) * (blockpos3.getZ() - blockpos2.getZ() + 1);
                if (i > 32768) {
                    throw new CommandException("commands.fill.tooManyBlocks", i, 32768);
                }
                if (blockpos2.getY() < 0 || blockpos3.getY() >= 256) break block17;
                World world = p_execute_2_.getEntityWorld();
                for (int j = blockpos2.getZ(); j <= blockpos3.getZ(); j += 16) {
                    for (int k = blockpos2.getX(); k <= blockpos3.getX(); k += 16) {
                        if (world.isBlockLoaded(new BlockPos(k, blockpos3.getY() - blockpos2.getY(), j))) continue;
                        throw new CommandException("commands.fill.outOfWorld", new Object[0]);
                    }
                }
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                boolean flag = false;
                if (p_execute_3_.length >= 10 && block.hasTileEntity(iblockstate)) {
                    String s = CommandFill.getChatComponentFromNthArg(p_execute_2_, p_execute_3_, 9).getUnformattedText();
                    try {
                        nbttagcompound = JsonToNBT.getTagFromJson(s);
                        flag = true;
                    }
                    catch (NBTException nbtexception) {
                        throw new CommandException("commands.fill.tagError", nbtexception.getMessage());
                    }
                }
                ArrayList list = Lists.newArrayList();
                i = 0;
                for (int l = blockpos2.getZ(); l <= blockpos3.getZ(); ++l) {
                    for (int i1 = blockpos2.getY(); i1 <= blockpos3.getY(); ++i1) {
                        for (int j1 = blockpos2.getX(); j1 <= blockpos3.getX(); ++j1) {
                            TileEntity tileentity;
                            TileEntity tileentity1;
                            BlockPos blockpos4;
                            block18: {
                                block19: {
                                    block21: {
                                        block20: {
                                            blockpos4 = new BlockPos(j1, i1, l);
                                            if (p_execute_3_.length < 9) break block18;
                                            if ("outline".equals(p_execute_3_[8]) || "hollow".equals(p_execute_3_[8])) break block19;
                                            if (!"destroy".equals(p_execute_3_[8])) break block20;
                                            world.destroyBlock(blockpos4, true);
                                            break block18;
                                        }
                                        if (!"keep".equals(p_execute_3_[8])) break block21;
                                        if (!world.isAirBlock(blockpos4)) {
                                            continue;
                                        }
                                        break block18;
                                    }
                                    if (!"replace".equals(p_execute_3_[8]) || block.hasTileEntity(iblockstate) || p_execute_3_.length <= 9) break block18;
                                    Block block1 = CommandBase.getBlockByText(p_execute_2_, p_execute_3_[9]);
                                    if (world.getBlockState(blockpos4).getBlock() != block1 || p_execute_3_.length > 10 && !"-1".equals(p_execute_3_[10]) && !"*".equals(p_execute_3_[10]) && !CommandBase.convertArgToBlockStatePredicate(block1, p_execute_3_[10]).apply((Object)world.getBlockState(blockpos4))) {
                                        continue;
                                    }
                                    break block18;
                                }
                                if (j1 != blockpos2.getX() && j1 != blockpos3.getX() && i1 != blockpos2.getY() && i1 != blockpos3.getY() && l != blockpos2.getZ() && l != blockpos3.getZ()) {
                                    if (!"hollow".equals(p_execute_3_[8])) continue;
                                    world.setBlockState(blockpos4, Blocks.AIR.getDefaultState(), 2);
                                    list.add(blockpos4);
                                    continue;
                                }
                            }
                            if ((tileentity1 = world.getTileEntity(blockpos4)) != null) {
                                if (tileentity1 instanceof IInventory) {
                                    ((IInventory)((Object)tileentity1)).clear();
                                }
                                world.setBlockState(blockpos4, Blocks.BARRIER.getDefaultState(), block == Blocks.BARRIER ? 2 : 4);
                            }
                            if (!world.setBlockState(blockpos4, iblockstate, 2)) continue;
                            list.add(blockpos4);
                            ++i;
                            if (!flag || (tileentity = world.getTileEntity(blockpos4)) == null) continue;
                            nbttagcompound.setInteger("x", blockpos4.getX());
                            nbttagcompound.setInteger("y", blockpos4.getY());
                            nbttagcompound.setInteger("z", blockpos4.getZ());
                            tileentity.readFromNBT(nbttagcompound);
                        }
                    }
                }
                for (BlockPos blockpos5 : list) {
                    Block block2 = world.getBlockState(blockpos5).getBlock();
                    world.notifyNeighborsRespectDebug(blockpos5, block2, false);
                }
                if (i <= 0) {
                    throw new CommandException("commands.fill.failed", new Object[0]);
                }
                break block22;
            }
            throw new CommandException("commands.fill.outOfWorld", new Object[0]);
        }
        p_execute_2_.setCommandStat(CommandResultStats.Type.AFFECTED_BLOCKS, i);
        CommandFill.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.fill.success", i);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer p_getTabCompletions_1_, ICommandSender p_getTabCompletions_2_, String[] p_getTabCompletions_3_, BlockPos p_getTabCompletions_4_) {
        return p_getTabCompletions_3_.length > 0 && p_getTabCompletions_3_.length <= 3 ? CommandFill.getTabCompletionCoordinate(p_getTabCompletions_3_, 0, p_getTabCompletions_4_) : (p_getTabCompletions_3_.length > 3 && p_getTabCompletions_3_.length <= 6 ? CommandFill.getTabCompletionCoordinate(p_getTabCompletions_3_, 3, p_getTabCompletions_4_) : (p_getTabCompletions_3_.length == 7 ? CommandFill.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, Block.REGISTRY.getKeys()) : (p_getTabCompletions_3_.length == 9 ? CommandFill.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, "replace", "destroy", "keep", "hollow", "outline") : (p_getTabCompletions_3_.length == 10 && "replace".equals(p_getTabCompletions_3_[8]) ? CommandFill.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, Block.REGISTRY.getKeys()) : Collections.emptyList()))));
    }
}

