/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldSettings;

public class CommandGameMode
extends CommandBase {
    @Override
    public String getName() {
        return "gamemode";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public String getUsage(ICommandSender p_getUsage_1_) {
        return "commands.gamemode.usage";
    }

    @Override
    public void execute(MinecraftServer p_execute_1_, ICommandSender p_execute_2_, String[] p_execute_3_) throws CommandException {
        if (p_execute_3_.length <= 0) {
            throw new WrongUsageException("commands.gamemode.usage", new Object[0]);
        }
        GameType lvt_4_1_ = this.getGameModeFromCommand(p_execute_2_, p_execute_3_[0]);
        EntityPlayerMP lvt_5_1_ = p_execute_3_.length >= 2 ? CommandGameMode.getPlayer(p_execute_1_, p_execute_2_, p_execute_3_[1]) : CommandGameMode.getCommandSenderAsPlayer(p_execute_2_);
        ((EntityPlayer)lvt_5_1_).setGameType(lvt_4_1_);
        TextComponentTranslation lvt_6_1_ = new TextComponentTranslation("gameMode." + lvt_4_1_.getName(), new Object[0]);
        if (p_execute_2_.getEntityWorld().getGameRules().getBoolean("sendCommandFeedback")) {
            ((Entity)lvt_5_1_).sendMessage(new TextComponentTranslation("gameMode.changed", lvt_6_1_));
        }
        if (lvt_5_1_ == p_execute_2_) {
            CommandGameMode.notifyCommandListener(p_execute_2_, (ICommand)this, 1, "commands.gamemode.success.self", lvt_6_1_);
        } else {
            CommandGameMode.notifyCommandListener(p_execute_2_, (ICommand)this, 1, "commands.gamemode.success.other", lvt_5_1_.getName(), lvt_6_1_);
        }
    }

    protected GameType getGameModeFromCommand(ICommandSender p_getGameModeFromCommand_1_, String p_getGameModeFromCommand_2_) throws CommandException, NumberInvalidException {
        GameType lvt_3_1_ = GameType.parseGameTypeWithDefault(p_getGameModeFromCommand_2_, GameType.NOT_SET);
        return lvt_3_1_ == GameType.NOT_SET ? WorldSettings.getGameTypeById(CommandGameMode.parseInt(p_getGameModeFromCommand_2_, 0, GameType.values().length - 2)) : lvt_3_1_;
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer p_getTabCompletions_1_, ICommandSender p_getTabCompletions_2_, String[] p_getTabCompletions_3_, BlockPos p_getTabCompletions_4_) {
        if (p_getTabCompletions_3_.length == 1) {
            return CommandGameMode.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, "survival", "creative", "adventure", "spectator");
        }
        if (p_getTabCompletions_3_.length == 2) {
            return CommandGameMode.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, p_getTabCompletions_1_.getOnlinePlayerNames());
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(String[] p_isUsernameIndex_1_, int p_isUsernameIndex_2_) {
        return p_isUsernameIndex_2_ == 1;
    }
}

