/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.play.server.SPacketEntityStatus;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.GameRules;

public class CommandGameRule
extends CommandBase {
    @Override
    public String getName() {
        return "gamerule";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public String getUsage(ICommandSender p_getUsage_1_) {
        return "commands.gamerule.usage";
    }

    @Override
    public void execute(MinecraftServer p_execute_1_, ICommandSender p_execute_2_, String[] p_execute_3_) throws CommandException {
        GameRules lvt_4_1_ = this.getOverWorldGameRules(p_execute_1_);
        String lvt_5_1_ = p_execute_3_.length > 0 ? p_execute_3_[0] : "";
        String lvt_6_1_ = p_execute_3_.length > 1 ? CommandGameRule.buildString(p_execute_3_, 1) : "";
        switch (p_execute_3_.length) {
            case 1: {
                if (lvt_4_1_.hasRule(lvt_5_1_)) {
                    String lvt_7_1_ = lvt_4_1_.getString(lvt_5_1_);
                    p_execute_2_.sendMessage(new TextComponentString(lvt_5_1_).appendText(" = ").appendText(lvt_7_1_));
                    p_execute_2_.setCommandStat(CommandResultStats.Type.QUERY_RESULT, lvt_4_1_.getInt(lvt_5_1_));
                    break;
                }
                throw new CommandException("commands.gamerule.norule", lvt_5_1_);
            }
            case 0: {
                p_execute_2_.sendMessage(new TextComponentString(CommandGameRule.joinNiceString(lvt_4_1_.getRules())));
                break;
            }
            default: {
                if (lvt_4_1_.areSameType(lvt_5_1_, GameRules.ValueType.BOOLEAN_VALUE) && !"true".equals(lvt_6_1_) && !"false".equals(lvt_6_1_)) {
                    throw new CommandException("commands.generic.boolean.invalid", lvt_6_1_);
                }
                lvt_4_1_.setOrCreateGameRule(lvt_5_1_, lvt_6_1_);
                CommandGameRule.notifyGameRuleChange(lvt_4_1_, lvt_5_1_, p_execute_1_);
                CommandGameRule.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.gamerule.success", lvt_5_1_, lvt_6_1_);
            }
        }
    }

    public static void notifyGameRuleChange(GameRules p_notifyGameRuleChange_0_, String p_notifyGameRuleChange_1_, MinecraftServer p_notifyGameRuleChange_2_) {
        if ("reducedDebugInfo".equals(p_notifyGameRuleChange_1_)) {
            byte lvt_3_1_ = p_notifyGameRuleChange_0_.getBoolean(p_notifyGameRuleChange_1_) ? (byte)22 : 23;
            for (EntityPlayerMP lvt_5_1_ : p_notifyGameRuleChange_2_.getPlayerList().getPlayers()) {
                lvt_5_1_.connection.sendPacket(new SPacketEntityStatus(lvt_5_1_, lvt_3_1_));
            }
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer p_getTabCompletions_1_, ICommandSender p_getTabCompletions_2_, String[] p_getTabCompletions_3_, BlockPos p_getTabCompletions_4_) {
        GameRules lvt_5_1_;
        if (p_getTabCompletions_3_.length == 1) {
            return CommandGameRule.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, this.getOverWorldGameRules(p_getTabCompletions_1_).getRules());
        }
        if (p_getTabCompletions_3_.length == 2 && (lvt_5_1_ = this.getOverWorldGameRules(p_getTabCompletions_1_)).areSameType(p_getTabCompletions_3_[0], GameRules.ValueType.BOOLEAN_VALUE)) {
            return CommandGameRule.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, "true", "false");
        }
        return Collections.emptyList();
    }

    private GameRules getOverWorldGameRules(MinecraftServer p_getOverWorldGameRules_1_) {
        return p_getOverWorldGameRules_1_.worldServerForDimension(0).getGameRules();
    }
}

