/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;

public class CommandGive
extends CommandBase {
    @Override
    public String getName() {
        return "give";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public String getUsage(ICommandSender p_getUsage_1_) {
        return "commands.give.usage";
    }

    @Override
    public void execute(MinecraftServer p_execute_1_, ICommandSender p_execute_2_, String[] p_execute_3_) throws CommandException {
        boolean lvt_9_2_;
        if (p_execute_3_.length < 2) {
            throw new WrongUsageException("commands.give.usage", new Object[0]);
        }
        EntityPlayerMP lvt_4_1_ = CommandGive.getPlayer(p_execute_1_, p_execute_2_, p_execute_3_[0]);
        Item lvt_5_1_ = CommandGive.getItemByText(p_execute_2_, p_execute_3_[1]);
        int lvt_6_1_ = p_execute_3_.length >= 3 ? CommandGive.parseInt(p_execute_3_[2], 1, 64) : 1;
        int lvt_7_1_ = p_execute_3_.length >= 4 ? CommandGive.parseInt(p_execute_3_[3]) : 0;
        ItemStack lvt_8_1_ = new ItemStack(lvt_5_1_, lvt_6_1_, lvt_7_1_);
        if (p_execute_3_.length >= 5) {
            String lvt_9_1_ = CommandGive.getChatComponentFromNthArg(p_execute_2_, p_execute_3_, 4).getUnformattedText();
            try {
                lvt_8_1_.setTagCompound(JsonToNBT.getTagFromJson(lvt_9_1_));
            }
            catch (NBTException lvt_10_1_) {
                throw new CommandException("commands.give.tagError", lvt_10_1_.getMessage());
            }
        }
        if (lvt_9_2_ = lvt_4_1_.inventory.addItemStackToInventory(lvt_8_1_)) {
            lvt_4_1_.world.playSound(null, lvt_4_1_.posX, lvt_4_1_.posY, lvt_4_1_.posZ, SoundEvents.ENTITY_ITEM_PICKUP, SoundCategory.PLAYERS, 0.2f, ((lvt_4_1_.getRNG().nextFloat() - lvt_4_1_.getRNG().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            lvt_4_1_.inventoryContainer.detectAndSendChanges();
        }
        if (!lvt_9_2_ || !lvt_8_1_.isEmpty()) {
            p_execute_2_.setCommandStat(CommandResultStats.Type.AFFECTED_ITEMS, lvt_6_1_ - lvt_8_1_.getCount());
            EntityItem lvt_10_2_ = lvt_4_1_.dropItem(lvt_8_1_, false);
            if (lvt_10_2_ != null) {
                lvt_10_2_.setNoPickupDelay();
                lvt_10_2_.setOwner(lvt_4_1_.getName());
            }
        } else {
            lvt_8_1_.setCount(1);
            p_execute_2_.setCommandStat(CommandResultStats.Type.AFFECTED_ITEMS, lvt_6_1_);
            EntityItem lvt_10_3_ = lvt_4_1_.dropItem(lvt_8_1_, false);
            if (lvt_10_3_ != null) {
                lvt_10_3_.makeFakeItem();
            }
        }
        CommandGive.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.give.success", lvt_8_1_.getTextComponent(), lvt_6_1_, lvt_4_1_.getName());
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer p_getTabCompletions_1_, ICommandSender p_getTabCompletions_2_, String[] p_getTabCompletions_3_, BlockPos p_getTabCompletions_4_) {
        if (p_getTabCompletions_3_.length == 1) {
            return CommandGive.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, p_getTabCompletions_1_.getOnlinePlayerNames());
        }
        if (p_getTabCompletions_3_.length == 2) {
            return CommandGive.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, Item.REGISTRY.getKeys());
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(String[] p_isUsernameIndex_1_, int p_isUsernameIndex_2_) {
        return p_isUsernameIndex_2_ == 0;
    }
}

