/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.EntitySelector;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.CommandEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class CommandHandler
implements ICommandManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<String, ICommand> commandMap = Maps.newHashMap();
    private final Set<ICommand> commandSet = Sets.newHashSet();

    @Override
    public int executeCommand(ICommandSender p_executeCommand_1_, String p_executeCommand_2_) {
        if ((p_executeCommand_2_ = p_executeCommand_2_.trim()).startsWith("/")) {
            p_executeCommand_2_ = p_executeCommand_2_.substring(1);
        }
        String[] astring = p_executeCommand_2_.split(" ");
        String s = astring[0];
        astring = CommandHandler.dropFirstString(astring);
        ICommand icommand = this.commandMap.get(s);
        int i = 0;
        try {
            int j = this.getUsernameIndex(icommand, astring);
            if (icommand == null) {
                TextComponentTranslation textcomponenttranslation1 = new TextComponentTranslation("commands.generic.notFound", new Object[0]);
                textcomponenttranslation1.getStyle().setColor(TextFormatting.RED);
                p_executeCommand_1_.sendMessage(textcomponenttranslation1);
            } else if (icommand.checkPermission(this.getServer(), p_executeCommand_1_)) {
                CommandEvent event = new CommandEvent(icommand, p_executeCommand_1_, astring);
                if (MinecraftForge.EVENT_BUS.post(event)) {
                    if (event.getException() != null) {
                        Throwables.propagateIfPossible((Throwable)event.getException());
                    }
                    return 1;
                }
                if (event.getParameters() != null) {
                    astring = event.getParameters();
                }
                if (j > -1) {
                    List<Entity> list = EntitySelector.matchEntities(p_executeCommand_1_, astring[j], Entity.class);
                    String s1 = astring[j];
                    p_executeCommand_1_.setCommandStat(CommandResultStats.Type.AFFECTED_ENTITIES, list.size());
                    if (list.isEmpty()) {
                        throw new PlayerNotFoundException("commands.generic.selector.notFound", astring[j]);
                    }
                    for (Entity entity : list) {
                        astring[j] = entity.getCachedUniqueIdString();
                        if (!this.tryExecute(p_executeCommand_1_, astring, icommand, p_executeCommand_2_)) continue;
                        ++i;
                    }
                    astring[j] = s1;
                } else {
                    p_executeCommand_1_.setCommandStat(CommandResultStats.Type.AFFECTED_ENTITIES, 1);
                    if (this.tryExecute(p_executeCommand_1_, astring, icommand, p_executeCommand_2_)) {
                        ++i;
                    }
                }
            } else {
                TextComponentTranslation textcomponenttranslation2 = new TextComponentTranslation("commands.generic.permission", new Object[0]);
                textcomponenttranslation2.getStyle().setColor(TextFormatting.RED);
                p_executeCommand_1_.sendMessage(textcomponenttranslation2);
            }
        }
        catch (CommandException commandexception) {
            TextComponentTranslation textcomponenttranslation = new TextComponentTranslation(commandexception.getMessage(), commandexception.getErrorObjects());
            textcomponenttranslation.getStyle().setColor(TextFormatting.RED);
            p_executeCommand_1_.sendMessage(textcomponenttranslation);
        }
        p_executeCommand_1_.setCommandStat(CommandResultStats.Type.SUCCESS_COUNT, i);
        return i;
    }

    protected boolean tryExecute(ICommandSender p_tryExecute_1_, String[] p_tryExecute_2_, ICommand p_tryExecute_3_, String p_tryExecute_4_) {
        try {
            p_tryExecute_3_.execute(this.getServer(), p_tryExecute_1_, p_tryExecute_2_);
            return true;
        }
        catch (WrongUsageException wrongusageexception) {
            TextComponentTranslation textcomponenttranslation2 = new TextComponentTranslation("commands.generic.usage", new TextComponentTranslation(wrongusageexception.getMessage(), wrongusageexception.getErrorObjects()));
            textcomponenttranslation2.getStyle().setColor(TextFormatting.RED);
            p_tryExecute_1_.sendMessage(textcomponenttranslation2);
        }
        catch (CommandException commandexception) {
            TextComponentTranslation textcomponenttranslation1 = new TextComponentTranslation(commandexception.getMessage(), commandexception.getErrorObjects());
            textcomponenttranslation1.getStyle().setColor(TextFormatting.RED);
            p_tryExecute_1_.sendMessage(textcomponenttranslation1);
        }
        catch (Throwable var9) {
            TextComponentTranslation textcomponenttranslation = new TextComponentTranslation("commands.generic.exception", new Object[0]);
            textcomponenttranslation.getStyle().setColor(TextFormatting.RED);
            p_tryExecute_1_.sendMessage(textcomponenttranslation);
            LOGGER.warn("Couldn't process command: '" + p_tryExecute_4_ + "'", var9);
        }
        return false;
    }

    protected abstract MinecraftServer getServer();

    public ICommand registerCommand(ICommand p_registerCommand_1_) {
        this.commandMap.put(p_registerCommand_1_.getName(), p_registerCommand_1_);
        this.commandSet.add(p_registerCommand_1_);
        for (String s : p_registerCommand_1_.getAliases()) {
            ICommand icommand = this.commandMap.get(s);
            if (icommand != null && icommand.getName().equals(s)) continue;
            this.commandMap.put(s, p_registerCommand_1_);
        }
        return p_registerCommand_1_;
    }

    private static String[] dropFirstString(String[] p_dropFirstString_0_) {
        String[] astring = new String[p_dropFirstString_0_.length - 1];
        System.arraycopy(p_dropFirstString_0_, 1, astring, 0, p_dropFirstString_0_.length - 1);
        return astring;
    }

    @Override
    public List<String> getTabCompletions(ICommandSender p_getTabCompletions_1_, String p_getTabCompletions_2_, BlockPos p_getTabCompletions_3_) {
        ICommand icommand;
        String[] astring = p_getTabCompletions_2_.split(" ", -1);
        String s = astring[0];
        if (astring.length == 1) {
            ArrayList list = Lists.newArrayList();
            for (Map.Entry<String, ICommand> entry : this.commandMap.entrySet()) {
                if (!CommandBase.doesStringStartWith(s, entry.getKey()) || !entry.getValue().checkPermission(this.getServer(), p_getTabCompletions_1_)) continue;
                list.add(entry.getKey());
            }
            return list;
        }
        if (astring.length > 1 && (icommand = this.commandMap.get(s)) != null && icommand.checkPermission(this.getServer(), p_getTabCompletions_1_)) {
            return icommand.getTabCompletions(this.getServer(), p_getTabCompletions_1_, CommandHandler.dropFirstString(astring), p_getTabCompletions_3_);
        }
        return Collections.emptyList();
    }

    @Override
    public List<ICommand> getPossibleCommands(ICommandSender p_getPossibleCommands_1_) {
        ArrayList list = Lists.newArrayList();
        for (ICommand icommand : this.commandSet) {
            if (!icommand.checkPermission(this.getServer(), p_getPossibleCommands_1_)) continue;
            list.add(icommand);
        }
        return list;
    }

    @Override
    public Map<String, ICommand> getCommands() {
        return this.commandMap;
    }

    private int getUsernameIndex(ICommand p_getUsernameIndex_1_, String[] p_getUsernameIndex_2_) throws CommandException {
        if (p_getUsernameIndex_1_ == null) {
            return -1;
        }
        for (int i = 0; i < p_getUsernameIndex_2_.length; ++i) {
            if (!p_getUsernameIndex_1_.isUsernameIndex(p_getUsernameIndex_2_, i) || !EntitySelector.matchesMultiplePlayers(p_getUsernameIndex_2_[i])) continue;
            return i;
        }
        return -1;
    }
}

