/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandNotFoundException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.CommandBlockBaseLogic;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;

public class CommandHelp
extends CommandBase {
    private static final String[] SEARGE_SAYS = new String[]{"Yolo", "/achievement take achievement.understandCommands @p", "Ask for help on twitter", "/deop @p", "Scoreboard deleted, commands blocked", "Contact helpdesk for help", "/testfornoob @p", "/trigger warning", "Oh my god, it's full of stats", "/kill @p[name=!Searge]", "Have you tried turning it off and on again?", "Sorry, no help today"};
    private final Random rand = new Random();

    @Override
    public String getName() {
        return "help";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 0;
    }

    @Override
    public String getUsage(ICommandSender p_getUsage_1_) {
        return "commands.help.usage";
    }

    @Override
    public List<String> getAliases() {
        return Arrays.asList("?");
    }

    @Override
    public void execute(MinecraftServer p_execute_1_, ICommandSender p_execute_2_, String[] p_execute_3_) throws CommandException {
        if (p_execute_2_ instanceof CommandBlockBaseLogic) {
            p_execute_2_.sendMessage(new TextComponentString("Searge says: ").appendText(SEARGE_SAYS[this.rand.nextInt(SEARGE_SAYS.length) % SEARGE_SAYS.length]));
            return;
        }
        List<ICommand> lvt_4_1_ = this.getSortedPossibleCommands(p_execute_2_, p_execute_1_);
        int lvt_5_1_ = 7;
        int lvt_6_1_ = (lvt_4_1_.size() - 1) / 7;
        int lvt_7_1_ = 0;
        try {
            lvt_7_1_ = p_execute_3_.length == 0 ? 0 : CommandHelp.parseInt(p_execute_3_[0], 1, lvt_6_1_ + 1) - 1;
        }
        catch (NumberInvalidException lvt_8_1_) {
            Map<String, ICommand> lvt_9_1_ = this.getCommandMap(p_execute_1_);
            ICommand lvt_10_1_ = lvt_9_1_.get(p_execute_3_[0]);
            if (lvt_10_1_ != null) {
                throw new WrongUsageException(lvt_10_1_.getUsage(p_execute_2_), new Object[0]);
            }
            if (MathHelper.getInt(p_execute_3_[0], -1) != -1 || MathHelper.getInt(p_execute_3_[0], -2) != -2) {
                throw lvt_8_1_;
            }
            throw new CommandNotFoundException();
        }
        int lvt_8_2_ = Math.min((lvt_7_1_ + 1) * 7, lvt_4_1_.size());
        TextComponentTranslation lvt_9_2_ = new TextComponentTranslation("commands.help.header", lvt_7_1_ + 1, lvt_6_1_ + 1);
        lvt_9_2_.getStyle().setColor(TextFormatting.DARK_GREEN);
        p_execute_2_.sendMessage(lvt_9_2_);
        for (int lvt_10_2_ = lvt_7_1_ * 7; lvt_10_2_ < lvt_8_2_; ++lvt_10_2_) {
            ICommand lvt_11_1_ = lvt_4_1_.get(lvt_10_2_);
            TextComponentTranslation lvt_12_1_ = new TextComponentTranslation(lvt_11_1_.getUsage(p_execute_2_), new Object[0]);
            lvt_12_1_.getStyle().setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/" + lvt_11_1_.getName() + " "));
            p_execute_2_.sendMessage(lvt_12_1_);
        }
        if (lvt_7_1_ == 0) {
            TextComponentTranslation lvt_10_3_ = new TextComponentTranslation("commands.help.footer", new Object[0]);
            lvt_10_3_.getStyle().setColor(TextFormatting.GREEN);
            p_execute_2_.sendMessage(lvt_10_3_);
        }
    }

    protected List<ICommand> getSortedPossibleCommands(ICommandSender p_getSortedPossibleCommands_1_, MinecraftServer p_getSortedPossibleCommands_2_) {
        List<ICommand> lvt_3_1_ = p_getSortedPossibleCommands_2_.getCommandManager().getPossibleCommands(p_getSortedPossibleCommands_1_);
        Collections.sort(lvt_3_1_);
        return lvt_3_1_;
    }

    protected Map<String, ICommand> getCommandMap(MinecraftServer p_getCommandMap_1_) {
        return p_getCommandMap_1_.getCommandManager().getCommands();
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer p_getTabCompletions_1_, ICommandSender p_getTabCompletions_2_, String[] p_getTabCompletions_3_, BlockPos p_getTabCompletions_4_) {
        if (p_getTabCompletions_3_.length == 1) {
            Set<String> lvt_5_1_ = this.getCommandMap(p_getTabCompletions_1_).keySet();
            return CommandHelp.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, lvt_5_1_.toArray(new String[lvt_5_1_.size()]));
        }
        return Collections.emptyList();
    }
}

