/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;

public class CommandLocate
extends CommandBase {
    @Override
    public String getName() {
        return "locate";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public String getUsage(ICommandSender p_getUsage_1_) {
        return "commands.locate.usage";
    }

    @Override
    public void execute(MinecraftServer p_execute_1_, ICommandSender p_execute_2_, String[] p_execute_3_) throws CommandException {
        if (p_execute_3_.length != 1) {
            throw new WrongUsageException("commands.locate.usage", new Object[0]);
        }
        String lvt_4_1_ = p_execute_3_[0];
        BlockPos lvt_5_1_ = p_execute_2_.getEntityWorld().findNearestStructure(lvt_4_1_, p_execute_2_.getPosition(), false);
        if (lvt_5_1_ == null) {
            throw new CommandException("commands.locate.failure", lvt_4_1_);
        }
        p_execute_2_.sendMessage(new TextComponentTranslation("commands.locate.success", lvt_4_1_, lvt_5_1_.getX(), lvt_5_1_.getZ()));
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer p_getTabCompletions_1_, ICommandSender p_getTabCompletions_2_, String[] p_getTabCompletions_3_, BlockPos p_getTabCompletions_4_) {
        if (p_getTabCompletions_3_.length == 1) {
            return CommandLocate.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, "Stronghold", "Monument", "Village", "Mansion", "EndCity", "Fortress", "Temple", "Mineshaft");
        }
        return Collections.emptyList();
    }
}

