/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class CommandParticle
extends CommandBase {
    @Override
    public String getName() {
        return "particle";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public String getUsage(ICommandSender p_getUsage_1_) {
        return "commands.particle.usage";
    }

    @Override
    public void execute(MinecraftServer p_execute_1_, ICommandSender p_execute_2_, String[] p_execute_3_) throws CommandException {
        EntityPlayerMP lvt_24_2_;
        if (p_execute_3_.length < 8) {
            throw new WrongUsageException("commands.particle.usage", new Object[0]);
        }
        boolean lvt_4_1_ = false;
        EnumParticleTypes lvt_5_1_ = EnumParticleTypes.getByName(p_execute_3_[0]);
        if (lvt_5_1_ == null) {
            throw new CommandException("commands.particle.notFound", p_execute_3_[0]);
        }
        String lvt_6_1_ = p_execute_3_[0];
        Vec3d lvt_7_1_ = p_execute_2_.getPositionVector();
        double lvt_8_1_ = (float)CommandParticle.parseDouble(lvt_7_1_.xCoord, p_execute_3_[1], true);
        double lvt_10_1_ = (float)CommandParticle.parseDouble(lvt_7_1_.yCoord, p_execute_3_[2], true);
        double lvt_12_1_ = (float)CommandParticle.parseDouble(lvt_7_1_.zCoord, p_execute_3_[3], true);
        double lvt_14_1_ = (float)CommandParticle.parseDouble(p_execute_3_[4]);
        double lvt_16_1_ = (float)CommandParticle.parseDouble(p_execute_3_[5]);
        double lvt_18_1_ = (float)CommandParticle.parseDouble(p_execute_3_[6]);
        double lvt_20_1_ = (float)CommandParticle.parseDouble(p_execute_3_[7]);
        int lvt_22_1_ = 0;
        if (p_execute_3_.length > 8) {
            lvt_22_1_ = CommandParticle.parseInt(p_execute_3_[8], 0);
        }
        boolean lvt_23_1_ = false;
        if (p_execute_3_.length > 9 && "force".equals(p_execute_3_[9])) {
            lvt_23_1_ = true;
        }
        if (p_execute_3_.length > 10) {
            EntityPlayerMP lvt_24_1_ = CommandParticle.getPlayer(p_execute_1_, p_execute_2_, p_execute_3_[10]);
        } else {
            lvt_24_2_ = null;
        }
        int[] lvt_25_1_ = new int[lvt_5_1_.getArgumentCount()];
        for (int lvt_26_1_ = 0; lvt_26_1_ < lvt_25_1_.length; ++lvt_26_1_) {
            if (p_execute_3_.length <= 11 + lvt_26_1_) continue;
            try {
                lvt_25_1_[lvt_26_1_] = Integer.parseInt(p_execute_3_[11 + lvt_26_1_]);
                continue;
            }
            catch (NumberFormatException lvt_27_1_) {
                throw new CommandException("commands.particle.invalidParam", p_execute_3_[11 + lvt_26_1_]);
            }
        }
        World lvt_26_2_ = p_execute_2_.getEntityWorld();
        if (lvt_26_2_ instanceof WorldServer) {
            WorldServer lvt_27_2_ = (WorldServer)lvt_26_2_;
            if (lvt_24_2_ == null) {
                lvt_27_2_.spawnParticle(lvt_5_1_, lvt_23_1_, lvt_8_1_, lvt_10_1_, lvt_12_1_, lvt_22_1_, lvt_14_1_, lvt_16_1_, lvt_18_1_, lvt_20_1_, lvt_25_1_);
            } else {
                lvt_27_2_.spawnParticle(lvt_24_2_, lvt_5_1_, lvt_23_1_, lvt_8_1_, lvt_10_1_, lvt_12_1_, lvt_22_1_, lvt_14_1_, lvt_16_1_, lvt_18_1_, lvt_20_1_, lvt_25_1_);
            }
            CommandParticle.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.particle.success", lvt_6_1_, Math.max(lvt_22_1_, 1));
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer p_getTabCompletions_1_, ICommandSender p_getTabCompletions_2_, String[] p_getTabCompletions_3_, BlockPos p_getTabCompletions_4_) {
        if (p_getTabCompletions_3_.length == 1) {
            return CommandParticle.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, EnumParticleTypes.getParticleNames());
        }
        if (p_getTabCompletions_3_.length > 1 && p_getTabCompletions_3_.length <= 4) {
            return CommandParticle.getTabCompletionCoordinate(p_getTabCompletions_3_, 1, p_getTabCompletions_4_);
        }
        if (p_getTabCompletions_3_.length == 10) {
            return CommandParticle.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, "normal", "force");
        }
        if (p_getTabCompletions_3_.length == 11) {
            return CommandParticle.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, p_getTabCompletions_1_.getOnlinePlayerNames());
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(String[] p_isUsernameIndex_1_, int p_isUsernameIndex_2_) {
        return p_isUsernameIndex_2_ == 10;
    }
}

