/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.play.server.SPacketCustomSound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class CommandPlaySound
extends CommandBase {
    @Override
    public String getName() {
        return "playsound";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public String getUsage(ICommandSender p_getUsage_1_) {
        return "commands.playsound.usage";
    }

    @Override
    public void execute(MinecraftServer p_execute_1_, ICommandSender p_execute_2_, String[] p_execute_3_) throws CommandException {
        String lvt_6_1_;
        SoundCategory lvt_7_1_;
        if (p_execute_3_.length < 2) {
            throw new WrongUsageException(this.getUsage(p_execute_2_), new Object[0]);
        }
        int lvt_4_1_ = 0;
        String lvt_5_1_ = p_execute_3_[lvt_4_1_++];
        if ((lvt_7_1_ = SoundCategory.getByName(lvt_6_1_ = p_execute_3_[lvt_4_1_++])) == null) {
            throw new CommandException("commands.playsound.unknownSoundSource", lvt_6_1_);
        }
        EntityPlayerMP lvt_8_1_ = CommandPlaySound.getPlayer(p_execute_1_, p_execute_2_, p_execute_3_[lvt_4_1_++]);
        Vec3d lvt_9_1_ = p_execute_2_.getPositionVector();
        double lvt_10_1_ = lvt_9_1_.xCoord;
        if (p_execute_3_.length > lvt_4_1_) {
            lvt_10_1_ = CommandPlaySound.parseDouble(lvt_10_1_, p_execute_3_[lvt_4_1_++], true);
        }
        double lvt_12_1_ = lvt_9_1_.yCoord;
        if (p_execute_3_.length > lvt_4_1_) {
            lvt_12_1_ = CommandPlaySound.parseDouble(lvt_12_1_, p_execute_3_[lvt_4_1_++], 0, 0, false);
        }
        double lvt_14_1_ = lvt_9_1_.zCoord;
        if (p_execute_3_.length > lvt_4_1_) {
            lvt_14_1_ = CommandPlaySound.parseDouble(lvt_14_1_, p_execute_3_[lvt_4_1_++], true);
        }
        double lvt_16_1_ = 1.0;
        if (p_execute_3_.length > lvt_4_1_) {
            lvt_16_1_ = CommandPlaySound.parseDouble(p_execute_3_[lvt_4_1_++], 0.0, 3.4028234663852886E38);
        }
        double lvt_18_1_ = 1.0;
        if (p_execute_3_.length > lvt_4_1_) {
            lvt_18_1_ = CommandPlaySound.parseDouble(p_execute_3_[lvt_4_1_++], 0.0, 2.0);
        }
        double lvt_20_1_ = 0.0;
        if (p_execute_3_.length > lvt_4_1_) {
            lvt_20_1_ = CommandPlaySound.parseDouble(p_execute_3_[lvt_4_1_], 0.0, 1.0);
        }
        double lvt_22_1_ = lvt_16_1_ > 1.0 ? lvt_16_1_ * 16.0 : 16.0;
        double lvt_24_1_ = lvt_8_1_.getDistance(lvt_10_1_, lvt_12_1_, lvt_14_1_);
        if (lvt_24_1_ > lvt_22_1_) {
            if (lvt_20_1_ <= 0.0) {
                throw new CommandException("commands.playsound.playerTooFar", lvt_8_1_.getName());
            }
            double lvt_26_1_ = lvt_10_1_ - lvt_8_1_.posX;
            double lvt_28_1_ = lvt_12_1_ - lvt_8_1_.posY;
            double lvt_30_1_ = lvt_14_1_ - lvt_8_1_.posZ;
            double lvt_32_1_ = Math.sqrt(lvt_26_1_ * lvt_26_1_ + lvt_28_1_ * lvt_28_1_ + lvt_30_1_ * lvt_30_1_);
            if (lvt_32_1_ > 0.0) {
                lvt_10_1_ = lvt_8_1_.posX + lvt_26_1_ / lvt_32_1_ * 2.0;
                lvt_12_1_ = lvt_8_1_.posY + lvt_28_1_ / lvt_32_1_ * 2.0;
                lvt_14_1_ = lvt_8_1_.posZ + lvt_30_1_ / lvt_32_1_ * 2.0;
            }
            lvt_16_1_ = lvt_20_1_;
        }
        lvt_8_1_.connection.sendPacket(new SPacketCustomSound(lvt_5_1_, lvt_7_1_, lvt_10_1_, lvt_12_1_, lvt_14_1_, (float)lvt_16_1_, (float)lvt_18_1_));
        CommandPlaySound.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.playsound.success", lvt_5_1_, lvt_8_1_.getName());
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer p_getTabCompletions_1_, ICommandSender p_getTabCompletions_2_, String[] p_getTabCompletions_3_, BlockPos p_getTabCompletions_4_) {
        if (p_getTabCompletions_3_.length == 1) {
            return CommandPlaySound.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, SoundEvent.REGISTRY.getKeys());
        }
        if (p_getTabCompletions_3_.length == 2) {
            return CommandPlaySound.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, SoundCategory.getSoundCategoryNames());
        }
        if (p_getTabCompletions_3_.length == 3) {
            return CommandPlaySound.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, p_getTabCompletions_1_.getOnlinePlayerNames());
        }
        if (p_getTabCompletions_3_.length > 3 && p_getTabCompletions_3_.length <= 6) {
            return CommandPlaySound.getTabCompletionCoordinate(p_getTabCompletions_3_, 3, p_getTabCompletions_4_);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(String[] p_isUsernameIndex_1_, int p_isUsernameIndex_2_) {
        return p_isUsernameIndex_2_ == 2;
    }
}

