/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CommandReplaceItem
extends CommandBase {
    private static final Map<String, Integer> SHORTCUTS = Maps.newHashMap();

    @Override
    public String getName() {
        return "replaceitem";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public String getUsage(ICommandSender p_getUsage_1_) {
        return "commands.replaceitem.usage";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void execute(MinecraftServer p_execute_1_, ICommandSender p_execute_2_, String[] p_execute_3_) throws CommandException {
        void lvt_8_3_;
        int lvt_5_2_;
        void lvt_4_3_;
        if (p_execute_3_.length < 1) {
            throw new WrongUsageException("commands.replaceitem.usage", new Object[0]);
        }
        if ("entity".equals(p_execute_3_[0])) {
            boolean lvt_4_1_ = false;
        } else if ("block".equals(p_execute_3_[0])) {
            boolean lvt_4_2_ = true;
        } else {
            throw new WrongUsageException("commands.replaceitem.usage", new Object[0]);
        }
        if (lvt_4_3_ != false) {
            if (p_execute_3_.length < 6) {
                throw new WrongUsageException("commands.replaceitem.block.usage", new Object[0]);
            }
            int lvt_5_1_ = 4;
        } else {
            if (p_execute_3_.length < 4) {
                throw new WrongUsageException("commands.replaceitem.entity.usage", new Object[0]);
            }
            lvt_5_2_ = 2;
        }
        String lvt_6_1_ = p_execute_3_[lvt_5_2_];
        int lvt_7_1_ = this.getSlotForShortcut(p_execute_3_[lvt_5_2_++]);
        try {
            Item lvt_8_1_ = CommandReplaceItem.getItemByText(p_execute_2_, p_execute_3_[lvt_5_2_]);
        }
        catch (NumberInvalidException lvt_9_1_) {
            if (Block.getBlockFromName(p_execute_3_[lvt_5_2_]) == Blocks.AIR) {
                Object lvt_8_2_ = null;
            }
            throw lvt_9_1_;
        }
        int lvt_9_2_ = p_execute_3_.length > ++lvt_5_2_ ? CommandReplaceItem.parseInt(p_execute_3_[lvt_5_2_++], 1, 64) : 1;
        int lvt_10_1_ = p_execute_3_.length > lvt_5_2_ ? CommandReplaceItem.parseInt(p_execute_3_[lvt_5_2_++]) : 0;
        ItemStack lvt_11_1_ = new ItemStack((Item)lvt_8_3_, lvt_9_2_, lvt_10_1_);
        if (p_execute_3_.length > lvt_5_2_) {
            String lvt_12_1_ = CommandReplaceItem.getChatComponentFromNthArg(p_execute_2_, p_execute_3_, lvt_5_2_).getUnformattedText();
            try {
                lvt_11_1_.setTagCompound(JsonToNBT.getTagFromJson(lvt_12_1_));
            }
            catch (NBTException lvt_13_1_) {
                throw new CommandException("commands.replaceitem.tagError", lvt_13_1_.getMessage());
            }
        }
        if (lvt_4_3_ != false) {
            p_execute_2_.setCommandStat(CommandResultStats.Type.AFFECTED_ITEMS, 0);
            BlockPos lvt_12_2_ = CommandReplaceItem.parseBlockPos(p_execute_2_, p_execute_3_, 1, false);
            World lvt_13_2_ = p_execute_2_.getEntityWorld();
            TileEntity lvt_14_1_ = lvt_13_2_.getTileEntity(lvt_12_2_);
            if (lvt_14_1_ == null || !(lvt_14_1_ instanceof IInventory)) {
                throw new CommandException("commands.replaceitem.noContainer", lvt_12_2_.getX(), lvt_12_2_.getY(), lvt_12_2_.getZ());
            }
            IInventory lvt_15_1_ = (IInventory)((Object)lvt_14_1_);
            if (lvt_7_1_ >= 0 && lvt_7_1_ < lvt_15_1_.getSizeInventory()) {
                lvt_15_1_.setInventorySlotContents(lvt_7_1_, lvt_11_1_);
            }
        } else {
            Entity lvt_12_3_ = CommandReplaceItem.getEntity(p_execute_1_, p_execute_2_, p_execute_3_[1]);
            p_execute_2_.setCommandStat(CommandResultStats.Type.AFFECTED_ITEMS, 0);
            if (lvt_12_3_ instanceof EntityPlayer) {
                ((EntityPlayer)lvt_12_3_).inventoryContainer.detectAndSendChanges();
            }
            if (!lvt_12_3_.replaceItemInInventory(lvt_7_1_, lvt_11_1_)) {
                throw new CommandException("commands.replaceitem.failed", lvt_6_1_, lvt_9_2_, lvt_11_1_.isEmpty() ? "Air" : lvt_11_1_.getTextComponent());
            }
            if (lvt_12_3_ instanceof EntityPlayer) {
                ((EntityPlayer)lvt_12_3_).inventoryContainer.detectAndSendChanges();
            }
        }
        p_execute_2_.setCommandStat(CommandResultStats.Type.AFFECTED_ITEMS, lvt_9_2_);
        CommandReplaceItem.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.replaceitem.success", lvt_6_1_, lvt_9_2_, lvt_11_1_.isEmpty() ? "Air" : lvt_11_1_.getTextComponent());
    }

    private int getSlotForShortcut(String p_getSlotForShortcut_1_) throws CommandException {
        if (!SHORTCUTS.containsKey(p_getSlotForShortcut_1_)) {
            throw new CommandException("commands.generic.parameter.invalid", p_getSlotForShortcut_1_);
        }
        return SHORTCUTS.get(p_getSlotForShortcut_1_);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer p_getTabCompletions_1_, ICommandSender p_getTabCompletions_2_, String[] p_getTabCompletions_3_, BlockPos p_getTabCompletions_4_) {
        if (p_getTabCompletions_3_.length == 1) {
            return CommandReplaceItem.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, "entity", "block");
        }
        if (p_getTabCompletions_3_.length == 2 && "entity".equals(p_getTabCompletions_3_[0])) {
            return CommandReplaceItem.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, p_getTabCompletions_1_.getOnlinePlayerNames());
        }
        if (p_getTabCompletions_3_.length >= 2 && p_getTabCompletions_3_.length <= 4 && "block".equals(p_getTabCompletions_3_[0])) {
            return CommandReplaceItem.getTabCompletionCoordinate(p_getTabCompletions_3_, 1, p_getTabCompletions_4_);
        }
        if (p_getTabCompletions_3_.length == 3 && "entity".equals(p_getTabCompletions_3_[0]) || p_getTabCompletions_3_.length == 5 && "block".equals(p_getTabCompletions_3_[0])) {
            return CommandReplaceItem.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, SHORTCUTS.keySet());
        }
        if (p_getTabCompletions_3_.length == 4 && "entity".equals(p_getTabCompletions_3_[0]) || p_getTabCompletions_3_.length == 6 && "block".equals(p_getTabCompletions_3_[0])) {
            return CommandReplaceItem.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, Item.REGISTRY.getKeys());
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(String[] p_isUsernameIndex_1_, int p_isUsernameIndex_2_) {
        return p_isUsernameIndex_1_.length > 0 && "entity".equals(p_isUsernameIndex_1_[0]) && p_isUsernameIndex_2_ == 1;
    }

    static {
        for (int lvt_0_1_ = 0; lvt_0_1_ < 54; ++lvt_0_1_) {
            SHORTCUTS.put("slot.container." + lvt_0_1_, lvt_0_1_);
        }
        for (int lvt_0_2_ = 0; lvt_0_2_ < 9; ++lvt_0_2_) {
            SHORTCUTS.put("slot.hotbar." + lvt_0_2_, lvt_0_2_);
        }
        for (int lvt_0_3_ = 0; lvt_0_3_ < 27; ++lvt_0_3_) {
            SHORTCUTS.put("slot.inventory." + lvt_0_3_, 9 + lvt_0_3_);
        }
        for (int lvt_0_4_ = 0; lvt_0_4_ < 27; ++lvt_0_4_) {
            SHORTCUTS.put("slot.enderchest." + lvt_0_4_, 200 + lvt_0_4_);
        }
        for (int lvt_0_5_ = 0; lvt_0_5_ < 8; ++lvt_0_5_) {
            SHORTCUTS.put("slot.villager." + lvt_0_5_, 300 + lvt_0_5_);
        }
        for (int lvt_0_6_ = 0; lvt_0_6_ < 15; ++lvt_0_6_) {
            SHORTCUTS.put("slot.horse." + lvt_0_6_, 500 + lvt_0_6_);
        }
        SHORTCUTS.put("slot.weapon", 98);
        SHORTCUTS.put("slot.weapon.mainhand", 98);
        SHORTCUTS.put("slot.weapon.offhand", 99);
        SHORTCUTS.put("slot.armor.head", 100 + EntityEquipmentSlot.HEAD.getIndex());
        SHORTCUTS.put("slot.armor.chest", 100 + EntityEquipmentSlot.CHEST.getIndex());
        SHORTCUTS.put("slot.armor.legs", 100 + EntityEquipmentSlot.LEGS.getIndex());
        SHORTCUTS.put("slot.armor.feet", 100 + EntityEquipmentSlot.FEET.getIndex());
        SHORTCUTS.put("slot.horse.saddle", 400);
        SHORTCUTS.put("slot.horse.armor", 401);
        SHORTCUTS.put("slot.horse.chest", 499);
    }
}

