/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class CommandResultStats {
    private static final int NUM_RESULT_TYPES = Type.values().length;
    private static final String[] STRING_RESULT_TYPES = new String[NUM_RESULT_TYPES];
    private String[] entitiesID = STRING_RESULT_TYPES;
    private String[] objectives = STRING_RESULT_TYPES;

    /*
     * WARNING - void declaration
     */
    public void setCommandStatForSender(MinecraftServer p_setCommandStatForSender_1_, final ICommandSender p_setCommandStatForSender_2_, Type p_setCommandStatForSender_3_, int p_setCommandStatForSender_4_) {
        void lvt_7_2_;
        String lvt_5_1_ = this.entitiesID[p_setCommandStatForSender_3_.getTypeID()];
        if (lvt_5_1_ == null) {
            return;
        }
        ICommandSender lvt_6_1_ = new ICommandSender(){

            @Override
            public String getName() {
                return p_setCommandStatForSender_2_.getName();
            }

            @Override
            public ITextComponent getDisplayName() {
                return p_setCommandStatForSender_2_.getDisplayName();
            }

            @Override
            public void sendMessage(ITextComponent p_sendMessage_1_) {
                p_setCommandStatForSender_2_.sendMessage(p_sendMessage_1_);
            }

            @Override
            public boolean canUseCommand(int p_canUseCommand_1_, String p_canUseCommand_2_) {
                return true;
            }

            @Override
            public BlockPos getPosition() {
                return p_setCommandStatForSender_2_.getPosition();
            }

            @Override
            public Vec3d getPositionVector() {
                return p_setCommandStatForSender_2_.getPositionVector();
            }

            @Override
            public World getEntityWorld() {
                return p_setCommandStatForSender_2_.getEntityWorld();
            }

            @Override
            public Entity getCommandSenderEntity() {
                return p_setCommandStatForSender_2_.getCommandSenderEntity();
            }

            @Override
            public boolean sendCommandFeedback() {
                return p_setCommandStatForSender_2_.sendCommandFeedback();
            }

            @Override
            public void setCommandStat(Type p_setCommandStat_1_, int p_setCommandStat_2_) {
                p_setCommandStatForSender_2_.setCommandStat(p_setCommandStat_1_, p_setCommandStat_2_);
            }

            @Override
            public MinecraftServer getServer() {
                return p_setCommandStatForSender_2_.getServer();
            }
        };
        try {
            String lvt_7_1_ = CommandBase.getEntityName(p_setCommandStatForSender_1_, lvt_6_1_, lvt_5_1_);
        }
        catch (CommandException lvt_8_1_) {
            return;
        }
        String lvt_8_2_ = this.objectives[p_setCommandStatForSender_3_.getTypeID()];
        if (lvt_8_2_ == null) {
            return;
        }
        Scoreboard lvt_9_1_ = p_setCommandStatForSender_2_.getEntityWorld().getScoreboard();
        ScoreObjective lvt_10_1_ = lvt_9_1_.getObjective(lvt_8_2_);
        if (lvt_10_1_ == null) {
            return;
        }
        if (!lvt_9_1_.entityHasObjective((String)lvt_7_2_, lvt_10_1_)) {
            return;
        }
        Score lvt_11_1_ = lvt_9_1_.getOrCreateScore((String)lvt_7_2_, lvt_10_1_);
        lvt_11_1_.setScorePoints(p_setCommandStatForSender_4_);
    }

    public void readStatsFromNBT(NBTTagCompound p_readStatsFromNBT_1_) {
        if (!p_readStatsFromNBT_1_.hasKey("CommandStats", 10)) {
            return;
        }
        NBTTagCompound lvt_2_1_ = p_readStatsFromNBT_1_.getCompoundTag("CommandStats");
        for (Type lvt_6_1_ : Type.values()) {
            String lvt_7_1_ = lvt_6_1_.getTypeName() + "Name";
            String lvt_8_1_ = lvt_6_1_.getTypeName() + "Objective";
            if (!lvt_2_1_.hasKey(lvt_7_1_, 8) || !lvt_2_1_.hasKey(lvt_8_1_, 8)) continue;
            String lvt_9_1_ = lvt_2_1_.getString(lvt_7_1_);
            String lvt_10_1_ = lvt_2_1_.getString(lvt_8_1_);
            CommandResultStats.setScoreBoardStat(this, lvt_6_1_, lvt_9_1_, lvt_10_1_);
        }
    }

    public void writeStatsToNBT(NBTTagCompound p_writeStatsToNBT_1_) {
        NBTTagCompound lvt_2_1_ = new NBTTagCompound();
        for (Type lvt_6_1_ : Type.values()) {
            String lvt_7_1_ = this.entitiesID[lvt_6_1_.getTypeID()];
            String lvt_8_1_ = this.objectives[lvt_6_1_.getTypeID()];
            if (lvt_7_1_ == null || lvt_8_1_ == null) continue;
            lvt_2_1_.setString(lvt_6_1_.getTypeName() + "Name", lvt_7_1_);
            lvt_2_1_.setString(lvt_6_1_.getTypeName() + "Objective", lvt_8_1_);
        }
        if (!lvt_2_1_.hasNoTags()) {
            p_writeStatsToNBT_1_.setTag("CommandStats", lvt_2_1_);
        }
    }

    public static void setScoreBoardStat(CommandResultStats p_setScoreBoardStat_0_, Type p_setScoreBoardStat_1_, String p_setScoreBoardStat_2_, String p_setScoreBoardStat_3_) {
        if (p_setScoreBoardStat_2_ == null || p_setScoreBoardStat_2_.isEmpty() || p_setScoreBoardStat_3_ == null || p_setScoreBoardStat_3_.isEmpty()) {
            CommandResultStats.removeScoreBoardStat(p_setScoreBoardStat_0_, p_setScoreBoardStat_1_);
            return;
        }
        if (p_setScoreBoardStat_0_.entitiesID == STRING_RESULT_TYPES || p_setScoreBoardStat_0_.objectives == STRING_RESULT_TYPES) {
            p_setScoreBoardStat_0_.entitiesID = new String[NUM_RESULT_TYPES];
            p_setScoreBoardStat_0_.objectives = new String[NUM_RESULT_TYPES];
        }
        p_setScoreBoardStat_0_.entitiesID[p_setScoreBoardStat_1_.getTypeID()] = p_setScoreBoardStat_2_;
        p_setScoreBoardStat_0_.objectives[p_setScoreBoardStat_1_.getTypeID()] = p_setScoreBoardStat_3_;
    }

    private static void removeScoreBoardStat(CommandResultStats p_removeScoreBoardStat_0_, Type p_removeScoreBoardStat_1_) {
        if (p_removeScoreBoardStat_0_.entitiesID == STRING_RESULT_TYPES || p_removeScoreBoardStat_0_.objectives == STRING_RESULT_TYPES) {
            return;
        }
        p_removeScoreBoardStat_0_.entitiesID[p_removeScoreBoardStat_1_.getTypeID()] = null;
        p_removeScoreBoardStat_0_.objectives[p_removeScoreBoardStat_1_.getTypeID()] = null;
        boolean lvt_2_1_ = true;
        for (Type lvt_6_1_ : Type.values()) {
            if (p_removeScoreBoardStat_0_.entitiesID[lvt_6_1_.getTypeID()] == null || p_removeScoreBoardStat_0_.objectives[lvt_6_1_.getTypeID()] == null) continue;
            lvt_2_1_ = false;
            break;
        }
        if (lvt_2_1_) {
            p_removeScoreBoardStat_0_.entitiesID = STRING_RESULT_TYPES;
            p_removeScoreBoardStat_0_.objectives = STRING_RESULT_TYPES;
        }
    }

    public void addAllStats(CommandResultStats p_addAllStats_1_) {
        for (Type lvt_5_1_ : Type.values()) {
            CommandResultStats.setScoreBoardStat(this, lvt_5_1_, p_addAllStats_1_.entitiesID[lvt_5_1_.getTypeID()], p_addAllStats_1_.objectives[lvt_5_1_.getTypeID()]);
        }
    }

    public static enum Type {
        SUCCESS_COUNT(0, "SuccessCount"),
        AFFECTED_BLOCKS(1, "AffectedBlocks"),
        AFFECTED_ENTITIES(2, "AffectedEntities"),
        AFFECTED_ITEMS(3, "AffectedItems"),
        QUERY_RESULT(4, "QueryResult");

        final int typeID;
        final String typeName;

        private Type(int p_i46050_3_, String p_i46050_4_) {
            this.typeID = p_i46050_3_;
            this.typeName = p_i46050_4_;
        }

        public int getTypeID() {
            return this.typeID;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public static String[] getTypeNames() {
            String[] lvt_0_1_ = new String[Type.values().length];
            int lvt_1_1_ = 0;
            for (Type lvt_5_1_ : Type.values()) {
                lvt_0_1_[lvt_1_1_++] = lvt_5_1_.getTypeName();
            }
            return lvt_0_1_;
        }

        @Nullable
        public static Type getTypeByName(String p_getTypeByName_0_) {
            for (Type lvt_4_1_ : Type.values()) {
                if (!lvt_4_1_.getTypeName().equals(p_getTypeByName_0_)) continue;
                return lvt_4_1_;
            }
            return null;
        }
    }
}

