/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public class CommandServerKick
extends CommandBase {
    @Override
    public String getName() {
        return "kick";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 3;
    }

    @Override
    public String getUsage(ICommandSender p_getUsage_1_) {
        return "commands.kick.usage";
    }

    @Override
    public void execute(MinecraftServer p_execute_1_, ICommandSender p_execute_2_, String[] p_execute_3_) throws CommandException {
        if (p_execute_3_.length <= 0 || p_execute_3_[0].length() <= 1) {
            throw new WrongUsageException("commands.kick.usage", new Object[0]);
        }
        EntityPlayerMP lvt_4_1_ = p_execute_1_.getPlayerList().getPlayerByUsername(p_execute_3_[0]);
        String lvt_5_1_ = "Kicked by an operator.";
        boolean lvt_6_1_ = false;
        if (lvt_4_1_ == null) {
            throw new PlayerNotFoundException("commands.generic.player.notFound", p_execute_3_[0]);
        }
        if (p_execute_3_.length >= 2) {
            lvt_5_1_ = CommandServerKick.getChatComponentFromNthArg(p_execute_2_, p_execute_3_, 1).getUnformattedText();
            lvt_6_1_ = true;
        }
        lvt_4_1_.connection.disconnect(lvt_5_1_);
        if (lvt_6_1_) {
            CommandServerKick.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.kick.success.reason", lvt_4_1_.getName(), lvt_5_1_);
        } else {
            CommandServerKick.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.kick.success", lvt_4_1_.getName());
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer p_getTabCompletions_1_, ICommandSender p_getTabCompletions_2_, String[] p_getTabCompletions_3_, BlockPos p_getTabCompletions_4_) {
        if (p_getTabCompletions_3_.length >= 1) {
            return CommandServerKick.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, p_getTabCompletions_1_.getOnlinePlayerNames());
        }
        return Collections.emptyList();
    }
}

