/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public class CommandSetSpawnpoint
extends CommandBase {
    @Override
    public String getName() {
        return "spawnpoint";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public String getUsage(ICommandSender p_getUsage_1_) {
        return "commands.spawnpoint.usage";
    }

    @Override
    public void execute(MinecraftServer p_execute_1_, ICommandSender p_execute_2_, String[] p_execute_3_) throws CommandException {
        BlockPos lvt_5_1_;
        if (p_execute_3_.length > 1 && p_execute_3_.length < 4) {
            throw new WrongUsageException("commands.spawnpoint.usage", new Object[0]);
        }
        EntityPlayerMP lvt_4_1_ = p_execute_3_.length > 0 ? CommandSetSpawnpoint.getPlayer(p_execute_1_, p_execute_2_, p_execute_3_[0]) : CommandSetSpawnpoint.getCommandSenderAsPlayer(p_execute_2_);
        BlockPos blockPos = lvt_5_1_ = p_execute_3_.length > 3 ? CommandSetSpawnpoint.parseBlockPos(p_execute_2_, p_execute_3_, 1, true) : lvt_4_1_.getPosition();
        if (lvt_4_1_.world != null) {
            lvt_4_1_.setSpawnPoint(lvt_5_1_, true);
            CommandSetSpawnpoint.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.spawnpoint.success", lvt_4_1_.getName(), lvt_5_1_.getX(), lvt_5_1_.getY(), lvt_5_1_.getZ());
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer p_getTabCompletions_1_, ICommandSender p_getTabCompletions_2_, String[] p_getTabCompletions_3_, BlockPos p_getTabCompletions_4_) {
        if (p_getTabCompletions_3_.length == 1) {
            return CommandSetSpawnpoint.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, p_getTabCompletions_1_.getOnlinePlayerNames());
        }
        if (p_getTabCompletions_3_.length > 1 && p_getTabCompletions_3_.length <= 4) {
            return CommandSetSpawnpoint.getTabCompletionCoordinate(p_getTabCompletions_3_, 1, p_getTabCompletions_4_);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(String[] p_isUsernameIndex_1_, int p_isUsernameIndex_2_) {
        return p_isUsernameIndex_2_ == 0;
    }
}

