/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.EntityNotFoundException;
import net.minecraft.command.EntitySelector;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class CommandSpreadPlayers
extends CommandBase {
    @Override
    public String getName() {
        return "spreadplayers";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public String getUsage(ICommandSender p_getUsage_1_) {
        return "commands.spreadplayers.usage";
    }

    @Override
    public void execute(MinecraftServer p_execute_1_, ICommandSender p_execute_2_, String[] p_execute_3_) throws CommandException {
        if (p_execute_3_.length < 6) {
            throw new WrongUsageException("commands.spreadplayers.usage", new Object[0]);
        }
        int lvt_4_1_ = 0;
        BlockPos lvt_5_1_ = p_execute_2_.getPosition();
        double lvt_6_1_ = CommandSpreadPlayers.parseDouble(lvt_5_1_.getX(), p_execute_3_[lvt_4_1_++], true);
        double lvt_8_1_ = CommandSpreadPlayers.parseDouble(lvt_5_1_.getZ(), p_execute_3_[lvt_4_1_++], true);
        double lvt_10_1_ = CommandSpreadPlayers.parseDouble(p_execute_3_[lvt_4_1_++], 0.0);
        double lvt_12_1_ = CommandSpreadPlayers.parseDouble(p_execute_3_[lvt_4_1_++], lvt_10_1_ + 1.0);
        boolean lvt_14_1_ = CommandSpreadPlayers.parseBoolean(p_execute_3_[lvt_4_1_++]);
        ArrayList lvt_15_1_ = Lists.newArrayList();
        while (lvt_4_1_ < p_execute_3_.length) {
            String lvt_16_1_;
            if (EntitySelector.isSelector(lvt_16_1_ = p_execute_3_[lvt_4_1_++])) {
                List<Entity> lvt_17_1_ = EntitySelector.matchEntities(p_execute_2_, lvt_16_1_, Entity.class);
                if (lvt_17_1_.isEmpty()) {
                    throw new EntityNotFoundException("commands.generic.selector.notFound", lvt_16_1_);
                }
                lvt_15_1_.addAll(lvt_17_1_);
                continue;
            }
            EntityPlayerMP lvt_17_2_ = p_execute_1_.getPlayerList().getPlayerByUsername(lvt_16_1_);
            if (lvt_17_2_ == null) {
                throw new PlayerNotFoundException("commands.generic.player.notFound", lvt_16_1_);
            }
            lvt_15_1_.add(lvt_17_2_);
        }
        p_execute_2_.setCommandStat(CommandResultStats.Type.AFFECTED_ENTITIES, lvt_15_1_.size());
        if (lvt_15_1_.isEmpty()) {
            throw new EntityNotFoundException("commands.spreadplayers.noop");
        }
        p_execute_2_.sendMessage(new TextComponentTranslation("commands.spreadplayers.spreading." + (lvt_14_1_ ? "teams" : "players"), lvt_15_1_.size(), lvt_12_1_, lvt_6_1_, lvt_8_1_, lvt_10_1_));
        this.spread(p_execute_2_, lvt_15_1_, new Position(lvt_6_1_, lvt_8_1_), lvt_10_1_, lvt_12_1_, ((Entity)lvt_15_1_.get((int)0)).world, lvt_14_1_);
    }

    private void spread(ICommandSender p_spread_1_, List<Entity> p_spread_2_, Position p_spread_3_, double p_spread_4_, double p_spread_6_, World p_spread_8_, boolean p_spread_9_) throws CommandException {
        Random lvt_10_1_ = new Random();
        double lvt_11_1_ = p_spread_3_.x - p_spread_6_;
        double lvt_13_1_ = p_spread_3_.z - p_spread_6_;
        double lvt_15_1_ = p_spread_3_.x + p_spread_6_;
        double lvt_17_1_ = p_spread_3_.z + p_spread_6_;
        Position[] lvt_19_1_ = this.createInitialPositions(lvt_10_1_, p_spread_9_ ? this.getNumberOfTeams(p_spread_2_) : p_spread_2_.size(), lvt_11_1_, lvt_13_1_, lvt_15_1_, lvt_17_1_);
        int lvt_20_1_ = this.spreadPositions(p_spread_3_, p_spread_4_, p_spread_8_, lvt_10_1_, lvt_11_1_, lvt_13_1_, lvt_15_1_, lvt_17_1_, lvt_19_1_, p_spread_9_);
        double lvt_21_1_ = this.setPlayerPositions(p_spread_2_, p_spread_8_, lvt_19_1_, p_spread_9_);
        CommandSpreadPlayers.notifyCommandListener(p_spread_1_, (ICommand)this, "commands.spreadplayers.success." + (p_spread_9_ ? "teams" : "players"), lvt_19_1_.length, p_spread_3_.x, p_spread_3_.z);
        if (lvt_19_1_.length > 1) {
            p_spread_1_.sendMessage(new TextComponentTranslation("commands.spreadplayers.info." + (p_spread_9_ ? "teams" : "players"), String.format("%.2f", lvt_21_1_), lvt_20_1_));
        }
    }

    private int getNumberOfTeams(List<Entity> p_getNumberOfTeams_1_) {
        HashSet lvt_2_1_ = Sets.newHashSet();
        for (Entity lvt_4_1_ : p_getNumberOfTeams_1_) {
            if (lvt_4_1_ instanceof EntityPlayer) {
                lvt_2_1_.add(lvt_4_1_.getTeam());
                continue;
            }
            lvt_2_1_.add(null);
        }
        return lvt_2_1_.size();
    }

    private int spreadPositions(Position p_spreadPositions_1_, double p_spreadPositions_2_, World p_spreadPositions_4_, Random p_spreadPositions_5_, double p_spreadPositions_6_, double p_spreadPositions_8_, double p_spreadPositions_10_, double p_spreadPositions_12_, Position[] p_spreadPositions_14_, boolean p_spreadPositions_15_) throws CommandException {
        int lvt_17_1_;
        boolean lvt_16_1_ = true;
        double lvt_18_1_ = 3.4028234663852886E38;
        for (lvt_17_1_ = 0; lvt_17_1_ < 10000 && lvt_16_1_; ++lvt_17_1_) {
            lvt_16_1_ = false;
            lvt_18_1_ = 3.4028234663852886E38;
            for (int lvt_20_1_ = 0; lvt_20_1_ < p_spreadPositions_14_.length; ++lvt_20_1_) {
                Position lvt_21_1_ = p_spreadPositions_14_[lvt_20_1_];
                int lvt_22_1_ = 0;
                Position lvt_23_1_ = new Position();
                for (int lvt_24_1_ = 0; lvt_24_1_ < p_spreadPositions_14_.length; ++lvt_24_1_) {
                    if (lvt_20_1_ == lvt_24_1_) continue;
                    Position lvt_25_1_ = p_spreadPositions_14_[lvt_24_1_];
                    double lvt_26_1_ = lvt_21_1_.dist(lvt_25_1_);
                    lvt_18_1_ = Math.min(lvt_26_1_, lvt_18_1_);
                    if (!(lvt_26_1_ < p_spreadPositions_2_)) continue;
                    ++lvt_22_1_;
                    lvt_23_1_.x += lvt_25_1_.x - lvt_21_1_.x;
                    lvt_23_1_.z += lvt_25_1_.z - lvt_21_1_.z;
                }
                if (lvt_22_1_ > 0) {
                    lvt_23_1_.x /= (double)lvt_22_1_;
                    lvt_23_1_.z /= (double)lvt_22_1_;
                    double lvt_24_2_ = lvt_23_1_.getLength();
                    if (lvt_24_2_ > 0.0) {
                        lvt_23_1_.normalize();
                        lvt_21_1_.moveAway(lvt_23_1_);
                    } else {
                        lvt_21_1_.randomize(p_spreadPositions_5_, p_spreadPositions_6_, p_spreadPositions_8_, p_spreadPositions_10_, p_spreadPositions_12_);
                    }
                    lvt_16_1_ = true;
                }
                if (!lvt_21_1_.clamp(p_spreadPositions_6_, p_spreadPositions_8_, p_spreadPositions_10_, p_spreadPositions_12_)) continue;
                lvt_16_1_ = true;
            }
            if (lvt_16_1_) continue;
            for (Position lvt_23_2_ : p_spreadPositions_14_) {
                if (lvt_23_2_.isSafe(p_spreadPositions_4_)) continue;
                lvt_23_2_.randomize(p_spreadPositions_5_, p_spreadPositions_6_, p_spreadPositions_8_, p_spreadPositions_10_, p_spreadPositions_12_);
                lvt_16_1_ = true;
            }
        }
        if (lvt_17_1_ >= 10000) {
            throw new CommandException("commands.spreadplayers.failure." + (p_spreadPositions_15_ ? "teams" : "players"), p_spreadPositions_14_.length, p_spreadPositions_1_.x, p_spreadPositions_1_.z, String.format("%.2f", lvt_18_1_));
        }
        return lvt_17_1_;
    }

    private double setPlayerPositions(List<Entity> p_setPlayerPositions_1_, World p_setPlayerPositions_2_, Position[] p_setPlayerPositions_3_, boolean p_setPlayerPositions_4_) {
        double lvt_5_1_ = 0.0;
        int lvt_7_1_ = 0;
        HashMap lvt_8_1_ = Maps.newHashMap();
        for (int lvt_9_1_ = 0; lvt_9_1_ < p_setPlayerPositions_1_.size(); ++lvt_9_1_) {
            Position lvt_11_2_;
            Entity lvt_10_1_ = p_setPlayerPositions_1_.get(lvt_9_1_);
            if (p_setPlayerPositions_4_) {
                Team lvt_12_1_;
                Team team = lvt_12_1_ = lvt_10_1_ instanceof EntityPlayer ? lvt_10_1_.getTeam() : null;
                if (!lvt_8_1_.containsKey(lvt_12_1_)) {
                    lvt_8_1_.put(lvt_12_1_, p_setPlayerPositions_3_[lvt_7_1_++]);
                }
                Position lvt_11_1_ = (Position)lvt_8_1_.get(lvt_12_1_);
            } else {
                lvt_11_2_ = p_setPlayerPositions_3_[lvt_7_1_++];
            }
            lvt_10_1_.setPositionAndUpdate((float)MathHelper.floor(lvt_11_2_.x) + 0.5f, lvt_11_2_.getSpawnY(p_setPlayerPositions_2_), (double)MathHelper.floor(lvt_11_2_.z) + 0.5);
            double lvt_12_2_ = Double.MAX_VALUE;
            for (Position lvt_17_1_ : p_setPlayerPositions_3_) {
                if (lvt_11_2_ == lvt_17_1_) continue;
                double lvt_18_1_ = lvt_11_2_.dist(lvt_17_1_);
                lvt_12_2_ = Math.min(lvt_18_1_, lvt_12_2_);
            }
            lvt_5_1_ += lvt_12_2_;
        }
        return lvt_5_1_ /= (double)p_setPlayerPositions_1_.size();
    }

    private Position[] createInitialPositions(Random p_createInitialPositions_1_, int p_createInitialPositions_2_, double p_createInitialPositions_3_, double p_createInitialPositions_5_, double p_createInitialPositions_7_, double p_createInitialPositions_9_) {
        Position[] lvt_11_1_ = new Position[p_createInitialPositions_2_];
        for (int lvt_12_1_ = 0; lvt_12_1_ < lvt_11_1_.length; ++lvt_12_1_) {
            Position lvt_13_1_ = new Position();
            lvt_13_1_.randomize(p_createInitialPositions_1_, p_createInitialPositions_3_, p_createInitialPositions_5_, p_createInitialPositions_7_, p_createInitialPositions_9_);
            lvt_11_1_[lvt_12_1_] = lvt_13_1_;
        }
        return lvt_11_1_;
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer p_getTabCompletions_1_, ICommandSender p_getTabCompletions_2_, String[] p_getTabCompletions_3_, BlockPos p_getTabCompletions_4_) {
        if (p_getTabCompletions_3_.length >= 1 && p_getTabCompletions_3_.length <= 2) {
            return CommandSpreadPlayers.getTabCompletionCoordinateXZ(p_getTabCompletions_3_, 0, p_getTabCompletions_4_);
        }
        return Collections.emptyList();
    }

    static class Position {
        double x;
        double z;

        Position() {
        }

        Position(double p_i1358_1_, double p_i1358_3_) {
            this.x = p_i1358_1_;
            this.z = p_i1358_3_;
        }

        double dist(Position p_dist_1_) {
            double lvt_2_1_ = this.x - p_dist_1_.x;
            double lvt_4_1_ = this.z - p_dist_1_.z;
            return Math.sqrt(lvt_2_1_ * lvt_2_1_ + lvt_4_1_ * lvt_4_1_);
        }

        void normalize() {
            double lvt_1_1_ = this.getLength();
            this.x /= lvt_1_1_;
            this.z /= lvt_1_1_;
        }

        float getLength() {
            return MathHelper.sqrt(this.x * this.x + this.z * this.z);
        }

        public void moveAway(Position p_moveAway_1_) {
            this.x -= p_moveAway_1_.x;
            this.z -= p_moveAway_1_.z;
        }

        public boolean clamp(double p_clamp_1_, double p_clamp_3_, double p_clamp_5_, double p_clamp_7_) {
            boolean lvt_9_1_ = false;
            if (this.x < p_clamp_1_) {
                this.x = p_clamp_1_;
                lvt_9_1_ = true;
            } else if (this.x > p_clamp_5_) {
                this.x = p_clamp_5_;
                lvt_9_1_ = true;
            }
            if (this.z < p_clamp_3_) {
                this.z = p_clamp_3_;
                lvt_9_1_ = true;
            } else if (this.z > p_clamp_7_) {
                this.z = p_clamp_7_;
                lvt_9_1_ = true;
            }
            return lvt_9_1_;
        }

        public int getSpawnY(World p_getSpawnY_1_) {
            BlockPos lvt_2_1_ = new BlockPos(this.x, 256.0, this.z);
            while (lvt_2_1_.getY() > 0) {
                if (p_getSpawnY_1_.getBlockState(lvt_2_1_ = lvt_2_1_.down()).getMaterial() == Material.AIR) continue;
                return lvt_2_1_.getY() + 1;
            }
            return 257;
        }

        public boolean isSafe(World p_isSafe_1_) {
            BlockPos lvt_2_1_ = new BlockPos(this.x, 256.0, this.z);
            while (lvt_2_1_.getY() > 0) {
                Material lvt_3_1_ = p_isSafe_1_.getBlockState(lvt_2_1_ = lvt_2_1_.down()).getMaterial();
                if (lvt_3_1_ == Material.AIR) continue;
                return !lvt_3_1_.isLiquid() && lvt_3_1_ != Material.FIRE;
            }
            return false;
        }

        public void randomize(Random p_randomize_1_, double p_randomize_2_, double p_randomize_4_, double p_randomize_6_, double p_randomize_8_) {
            this.x = MathHelper.nextDouble(p_randomize_1_, p_randomize_2_, p_randomize_6_);
            this.z = MathHelper.nextDouble(p_randomize_1_, p_randomize_4_, p_randomize_8_);
        }
    }
}

