/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CommandStats
extends CommandBase {
    @Override
    public String getName() {
        return "stats";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public String getUsage(ICommandSender p_getUsage_1_) {
        return "commands.stats.usage";
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(MinecraftServer p_execute_1_, ICommandSender p_execute_2_, String[] p_execute_3_) throws CommandException {
        CommandResultStats lvt_9_4_;
        CommandResultStats.Type lvt_7_1_;
        int lvt_5_2_;
        void lvt_4_3_;
        if (p_execute_3_.length < 1) {
            throw new WrongUsageException("commands.stats.usage", new Object[0]);
        }
        if ("entity".equals(p_execute_3_[0])) {
            boolean lvt_4_1_ = false;
        } else {
            if (!"block".equals(p_execute_3_[0])) throw new WrongUsageException("commands.stats.usage", new Object[0]);
            boolean lvt_4_2_ = true;
        }
        if (lvt_4_3_ != false) {
            if (p_execute_3_.length < 5) {
                throw new WrongUsageException("commands.stats.block.usage", new Object[0]);
            }
            int lvt_5_1_ = 4;
        } else {
            if (p_execute_3_.length < 3) {
                throw new WrongUsageException("commands.stats.entity.usage", new Object[0]);
            }
            lvt_5_2_ = 2;
        }
        String lvt_6_1_ = p_execute_3_[lvt_5_2_++];
        if ("set".equals(lvt_6_1_)) {
            if (p_execute_3_.length < lvt_5_2_ + 3) {
                if (lvt_5_2_ != 5) throw new WrongUsageException("commands.stats.entity.set.usage", new Object[0]);
                throw new WrongUsageException("commands.stats.block.set.usage", new Object[0]);
            }
        } else {
            if (!"clear".equals(lvt_6_1_)) throw new WrongUsageException("commands.stats.usage", new Object[0]);
            if (p_execute_3_.length < lvt_5_2_ + 1) {
                if (lvt_5_2_ != 5) throw new WrongUsageException("commands.stats.entity.clear.usage", new Object[0]);
                throw new WrongUsageException("commands.stats.block.clear.usage", new Object[0]);
            }
        }
        if ((lvt_7_1_ = CommandResultStats.Type.getTypeByName(p_execute_3_[lvt_5_2_++])) == null) {
            throw new CommandException("commands.stats.failed", new Object[0]);
        }
        World lvt_8_1_ = p_execute_2_.getEntityWorld();
        if (lvt_4_3_ != false) {
            BlockPos lvt_10_1_ = CommandStats.parseBlockPos(p_execute_2_, p_execute_3_, 1, false);
            TileEntity lvt_11_1_ = lvt_8_1_.getTileEntity(lvt_10_1_);
            if (lvt_11_1_ == null) {
                throw new CommandException("commands.stats.noCompatibleBlock", lvt_10_1_.getX(), lvt_10_1_.getY(), lvt_10_1_.getZ());
            }
            if (lvt_11_1_ instanceof TileEntityCommandBlock) {
                CommandResultStats lvt_9_1_ = ((TileEntityCommandBlock)lvt_11_1_).getCommandResultStats();
            } else {
                if (!(lvt_11_1_ instanceof TileEntitySign)) throw new CommandException("commands.stats.noCompatibleBlock", lvt_10_1_.getX(), lvt_10_1_.getY(), lvt_10_1_.getZ());
                CommandResultStats lvt_9_2_ = ((TileEntitySign)lvt_11_1_).getStats();
            }
        } else {
            Entity lvt_10_2_ = CommandStats.getEntity(p_execute_1_, p_execute_2_, p_execute_3_[1]);
            lvt_9_4_ = lvt_10_2_.getCommandStats();
        }
        if ("set".equals(lvt_6_1_)) {
            String lvt_10_3_ = p_execute_3_[lvt_5_2_++];
            String lvt_11_2_ = p_execute_3_[lvt_5_2_];
            if (lvt_10_3_.isEmpty() || lvt_11_2_.isEmpty()) {
                throw new CommandException("commands.stats.failed", new Object[0]);
            }
            CommandResultStats.setScoreBoardStat(lvt_9_4_, lvt_7_1_, lvt_10_3_, lvt_11_2_);
            CommandStats.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.stats.success", lvt_7_1_.getTypeName(), lvt_11_2_, lvt_10_3_);
        } else if ("clear".equals(lvt_6_1_)) {
            CommandResultStats.setScoreBoardStat(lvt_9_4_, lvt_7_1_, null, null);
            CommandStats.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.stats.cleared", lvt_7_1_.getTypeName());
        }
        if (lvt_4_3_ == false) return;
        BlockPos lvt_10_4_ = CommandStats.parseBlockPos(p_execute_2_, p_execute_3_, 1, false);
        TileEntity lvt_11_3_ = lvt_8_1_.getTileEntity(lvt_10_4_);
        lvt_11_3_.markDirty();
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer p_getTabCompletions_1_, ICommandSender p_getTabCompletions_2_, String[] p_getTabCompletions_3_, BlockPos p_getTabCompletions_4_) {
        if (p_getTabCompletions_3_.length == 1) {
            return CommandStats.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, "entity", "block");
        }
        if (p_getTabCompletions_3_.length == 2 && "entity".equals(p_getTabCompletions_3_[0])) {
            return CommandStats.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, p_getTabCompletions_1_.getOnlinePlayerNames());
        }
        if (p_getTabCompletions_3_.length >= 2 && p_getTabCompletions_3_.length <= 4 && "block".equals(p_getTabCompletions_3_[0])) {
            return CommandStats.getTabCompletionCoordinate(p_getTabCompletions_3_, 1, p_getTabCompletions_4_);
        }
        if (p_getTabCompletions_3_.length == 3 && "entity".equals(p_getTabCompletions_3_[0]) || p_getTabCompletions_3_.length == 5 && "block".equals(p_getTabCompletions_3_[0])) {
            return CommandStats.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, "set", "clear");
        }
        if (p_getTabCompletions_3_.length == 4 && "entity".equals(p_getTabCompletions_3_[0]) || p_getTabCompletions_3_.length == 6 && "block".equals(p_getTabCompletions_3_[0])) {
            return CommandStats.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, CommandResultStats.Type.getTypeNames());
        }
        if (p_getTabCompletions_3_.length == 6 && "entity".equals(p_getTabCompletions_3_[0]) || p_getTabCompletions_3_.length == 8 && "block".equals(p_getTabCompletions_3_[0])) {
            return CommandStats.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, this.getObjectiveNames(p_getTabCompletions_1_));
        }
        return Collections.emptyList();
    }

    protected List<String> getObjectiveNames(MinecraftServer p_getObjectiveNames_1_) {
        Collection<ScoreObjective> lvt_2_1_ = p_getObjectiveNames_1_.worldServerForDimension(0).getScoreboard().getScoreObjectives();
        ArrayList lvt_3_1_ = Lists.newArrayList();
        for (ScoreObjective lvt_5_1_ : lvt_2_1_) {
            if (lvt_5_1_.getCriteria().isReadOnly()) continue;
            lvt_3_1_.add(lvt_5_1_.getName());
        }
        return lvt_3_1_;
    }

    @Override
    public boolean isUsernameIndex(String[] p_isUsernameIndex_1_, int p_isUsernameIndex_2_) {
        return p_isUsernameIndex_1_.length > 0 && "entity".equals(p_isUsernameIndex_1_[0]) && p_isUsernameIndex_2_ == 1;
    }
}

