/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import io.netty.buffer.Unpooled;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SPacketCustomPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;

public class CommandStopSound
extends CommandBase {
    @Override
    public String getName() {
        return "stopsound";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public String getUsage(ICommandSender p_getUsage_1_) {
        return "commands.stopsound.usage";
    }

    @Override
    public void execute(MinecraftServer p_execute_1_, ICommandSender p_execute_2_, String[] p_execute_3_) throws CommandException {
        if (p_execute_3_.length < 1 || p_execute_3_.length > 3) {
            throw new WrongUsageException(this.getUsage(p_execute_2_), new Object[0]);
        }
        int lvt_4_1_ = 0;
        EntityPlayerMP lvt_5_1_ = CommandStopSound.getPlayer(p_execute_1_, p_execute_2_, p_execute_3_[lvt_4_1_++]);
        String lvt_6_1_ = "";
        String lvt_7_1_ = "";
        if (p_execute_3_.length >= 2) {
            String lvt_8_1_;
            SoundCategory lvt_9_1_;
            if ((lvt_9_1_ = SoundCategory.getByName(lvt_8_1_ = p_execute_3_[lvt_4_1_++])) == null) {
                throw new CommandException("commands.stopsound.unknownSoundSource", lvt_8_1_);
            }
            lvt_6_1_ = lvt_9_1_.getName();
        }
        if (p_execute_3_.length == 3) {
            lvt_7_1_ = p_execute_3_[lvt_4_1_++];
        }
        PacketBuffer lvt_8_2_ = new PacketBuffer(Unpooled.buffer());
        lvt_8_2_.writeString(lvt_6_1_);
        lvt_8_2_.writeString(lvt_7_1_);
        lvt_5_1_.connection.sendPacket(new SPacketCustomPayload("MC|StopSound", lvt_8_2_));
        if (lvt_6_1_.isEmpty() && lvt_7_1_.isEmpty()) {
            CommandStopSound.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.stopsound.success.all", lvt_5_1_.getName());
        } else if (lvt_7_1_.isEmpty()) {
            CommandStopSound.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.stopsound.success.soundSource", lvt_6_1_, lvt_5_1_.getName());
        } else {
            CommandStopSound.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.stopsound.success.individualSound", lvt_7_1_, lvt_6_1_, lvt_5_1_.getName());
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer p_getTabCompletions_1_, ICommandSender p_getTabCompletions_2_, String[] p_getTabCompletions_3_, BlockPos p_getTabCompletions_4_) {
        if (p_getTabCompletions_3_.length == 1) {
            return CommandStopSound.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, p_getTabCompletions_1_.getOnlinePlayerNames());
        }
        if (p_getTabCompletions_3_.length == 2) {
            return CommandStopSound.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, SoundCategory.getSoundCategoryNames());
        }
        if (p_getTabCompletions_3_.length == 3) {
            return CommandStopSound.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, SoundEvent.REGISTRY.getKeys());
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(String[] p_isUsernameIndex_1_, int p_isUsernameIndex_2_) {
        return p_isUsernameIndex_2_ == 0;
    }
}

