/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.play.server.SPacketPlayerPosLook;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class CommandTP
extends CommandBase {
    @Override
    public String getName() {
        return "tp";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public String getUsage(ICommandSender p_getUsage_1_) {
        return "commands.tp.usage";
    }

    @Override
    public void execute(MinecraftServer p_execute_1_, ICommandSender p_execute_2_, String[] p_execute_3_) throws CommandException {
        EntityPlayerMP lvt_5_2_;
        if (p_execute_3_.length < 1) {
            throw new WrongUsageException("commands.tp.usage", new Object[0]);
        }
        int lvt_4_1_ = 0;
        if (p_execute_3_.length == 2 || p_execute_3_.length == 4 || p_execute_3_.length == 6) {
            Entity lvt_5_1_ = CommandTP.getEntity(p_execute_1_, p_execute_2_, p_execute_3_[0]);
            lvt_4_1_ = 1;
        } else {
            lvt_5_2_ = CommandTP.getCommandSenderAsPlayer(p_execute_2_);
        }
        if (p_execute_3_.length == 1 || p_execute_3_.length == 2) {
            Entity lvt_6_1_ = CommandTP.getEntity(p_execute_1_, p_execute_2_, p_execute_3_[p_execute_3_.length - 1]);
            if (lvt_6_1_.world != lvt_5_2_.world) {
                throw new CommandException("commands.tp.notSameDimension", new Object[0]);
            }
            ((Entity)lvt_5_2_).dismountRidingEntity();
            if (lvt_5_2_ instanceof EntityPlayerMP) {
                lvt_5_2_.connection.setPlayerLocation(lvt_6_1_.posX, lvt_6_1_.posY, lvt_6_1_.posZ, lvt_6_1_.rotationYaw, lvt_6_1_.rotationPitch);
            } else {
                lvt_5_2_.setLocationAndAngles(lvt_6_1_.posX, lvt_6_1_.posY, lvt_6_1_.posZ, lvt_6_1_.rotationYaw, lvt_6_1_.rotationPitch);
            }
            CommandTP.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.tp.success", ((Entity)lvt_5_2_).getName(), lvt_6_1_.getName());
            return;
        }
        if (p_execute_3_.length < lvt_4_1_ + 3) {
            throw new WrongUsageException("commands.tp.usage", new Object[0]);
        }
        if (lvt_5_2_.world == null) {
            return;
        }
        int lvt_6_2_ = lvt_4_1_;
        int lvt_7_1_ = 4096;
        CommandBase.CoordinateArg lvt_8_1_ = CommandTP.parseCoordinate(lvt_5_2_.posX, p_execute_3_[lvt_6_2_++], true);
        CommandBase.CoordinateArg lvt_9_1_ = CommandTP.parseCoordinate(lvt_5_2_.posY, p_execute_3_[lvt_6_2_++], -4096, 4096, false);
        CommandBase.CoordinateArg lvt_10_1_ = CommandTP.parseCoordinate(lvt_5_2_.posZ, p_execute_3_[lvt_6_2_++], true);
        CommandBase.CoordinateArg lvt_11_1_ = CommandTP.parseCoordinate(lvt_5_2_.rotationYaw, p_execute_3_.length > lvt_6_2_ ? p_execute_3_[lvt_6_2_++] : "~", false);
        CommandBase.CoordinateArg lvt_12_1_ = CommandTP.parseCoordinate(lvt_5_2_.rotationPitch, p_execute_3_.length > lvt_6_2_ ? p_execute_3_[lvt_6_2_] : "~", false);
        CommandTP.teleportEntityToCoordinates(lvt_5_2_, lvt_8_1_, lvt_9_1_, lvt_10_1_, lvt_11_1_, lvt_12_1_);
        CommandTP.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.tp.success.coordinates", ((Entity)lvt_5_2_).getName(), lvt_8_1_.getResult(), lvt_9_1_.getResult(), lvt_10_1_.getResult());
    }

    private static void teleportEntityToCoordinates(Entity p_teleportEntityToCoordinates_0_, CommandBase.CoordinateArg p_teleportEntityToCoordinates_1_, CommandBase.CoordinateArg p_teleportEntityToCoordinates_2_, CommandBase.CoordinateArg p_teleportEntityToCoordinates_3_, CommandBase.CoordinateArg p_teleportEntityToCoordinates_4_, CommandBase.CoordinateArg p_teleportEntityToCoordinates_5_) {
        if (p_teleportEntityToCoordinates_0_ instanceof EntityPlayerMP) {
            EnumSet<SPacketPlayerPosLook.EnumFlags> lvt_6_1_ = EnumSet.noneOf(SPacketPlayerPosLook.EnumFlags.class);
            if (p_teleportEntityToCoordinates_1_.isRelative()) {
                lvt_6_1_.add(SPacketPlayerPosLook.EnumFlags.X);
            }
            if (p_teleportEntityToCoordinates_2_.isRelative()) {
                lvt_6_1_.add(SPacketPlayerPosLook.EnumFlags.Y);
            }
            if (p_teleportEntityToCoordinates_3_.isRelative()) {
                lvt_6_1_.add(SPacketPlayerPosLook.EnumFlags.Z);
            }
            if (p_teleportEntityToCoordinates_5_.isRelative()) {
                lvt_6_1_.add(SPacketPlayerPosLook.EnumFlags.X_ROT);
            }
            if (p_teleportEntityToCoordinates_4_.isRelative()) {
                lvt_6_1_.add(SPacketPlayerPosLook.EnumFlags.Y_ROT);
            }
            float lvt_7_1_ = (float)p_teleportEntityToCoordinates_4_.getAmount();
            if (!p_teleportEntityToCoordinates_4_.isRelative()) {
                lvt_7_1_ = MathHelper.wrapDegrees(lvt_7_1_);
            }
            float lvt_8_1_ = (float)p_teleportEntityToCoordinates_5_.getAmount();
            if (!p_teleportEntityToCoordinates_5_.isRelative()) {
                lvt_8_1_ = MathHelper.wrapDegrees(lvt_8_1_);
            }
            p_teleportEntityToCoordinates_0_.dismountRidingEntity();
            ((EntityPlayerMP)p_teleportEntityToCoordinates_0_).connection.setPlayerLocation(p_teleportEntityToCoordinates_1_.getAmount(), p_teleportEntityToCoordinates_2_.getAmount(), p_teleportEntityToCoordinates_3_.getAmount(), lvt_7_1_, lvt_8_1_, lvt_6_1_);
            p_teleportEntityToCoordinates_0_.setRotationYawHead(lvt_7_1_);
        } else {
            float lvt_6_2_ = (float)MathHelper.wrapDegrees(p_teleportEntityToCoordinates_4_.getResult());
            float lvt_7_2_ = (float)MathHelper.wrapDegrees(p_teleportEntityToCoordinates_5_.getResult());
            lvt_7_2_ = MathHelper.clamp(lvt_7_2_, -90.0f, 90.0f);
            p_teleportEntityToCoordinates_0_.setLocationAndAngles(p_teleportEntityToCoordinates_1_.getResult(), p_teleportEntityToCoordinates_2_.getResult(), p_teleportEntityToCoordinates_3_.getResult(), lvt_6_2_, lvt_7_2_);
            p_teleportEntityToCoordinates_0_.setRotationYawHead(lvt_6_2_);
        }
        if (!(p_teleportEntityToCoordinates_0_ instanceof EntityLivingBase) || !((EntityLivingBase)p_teleportEntityToCoordinates_0_).isElytraFlying()) {
            p_teleportEntityToCoordinates_0_.motionY = 0.0;
            p_teleportEntityToCoordinates_0_.onGround = true;
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer p_getTabCompletions_1_, ICommandSender p_getTabCompletions_2_, String[] p_getTabCompletions_3_, BlockPos p_getTabCompletions_4_) {
        if (p_getTabCompletions_3_.length == 1 || p_getTabCompletions_3_.length == 2) {
            return CommandTP.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, p_getTabCompletions_1_.getOnlinePlayerNames());
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(String[] p_isUsernameIndex_1_, int p_isUsernameIndex_2_) {
        return p_isUsernameIndex_2_ == 0;
    }
}

