/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;

public class CommandTime
extends CommandBase {
    @Override
    public String getName() {
        return "time";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public String getUsage(ICommandSender p_getUsage_1_) {
        return "commands.time.usage";
    }

    @Override
    public void execute(MinecraftServer p_execute_1_, ICommandSender p_execute_2_, String[] p_execute_3_) throws CommandException {
        if (p_execute_3_.length > 1) {
            if ("set".equals(p_execute_3_[0])) {
                int lvt_4_3_;
                if ("day".equals(p_execute_3_[1])) {
                    int lvt_4_1_ = 1000;
                } else if ("night".equals(p_execute_3_[1])) {
                    int lvt_4_2_ = 13000;
                } else {
                    lvt_4_3_ = CommandTime.parseInt(p_execute_3_[1], 0);
                }
                this.setAllWorldTimes(p_execute_1_, lvt_4_3_);
                CommandTime.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.time.set", lvt_4_3_);
                return;
            }
            if ("add".equals(p_execute_3_[0])) {
                int lvt_4_4_ = CommandTime.parseInt(p_execute_3_[1], 0);
                this.incrementAllWorldTimes(p_execute_1_, lvt_4_4_);
                CommandTime.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.time.added", lvt_4_4_);
                return;
            }
            if ("query".equals(p_execute_3_[0])) {
                if ("daytime".equals(p_execute_3_[1])) {
                    int lvt_4_5_ = (int)(p_execute_2_.getEntityWorld().getWorldTime() % 24000L);
                    p_execute_2_.setCommandStat(CommandResultStats.Type.QUERY_RESULT, lvt_4_5_);
                    CommandTime.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.time.query", lvt_4_5_);
                    return;
                }
                if ("day".equals(p_execute_3_[1])) {
                    int lvt_4_6_ = (int)(p_execute_2_.getEntityWorld().getWorldTime() / 24000L % Integer.MAX_VALUE);
                    p_execute_2_.setCommandStat(CommandResultStats.Type.QUERY_RESULT, lvt_4_6_);
                    CommandTime.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.time.query", lvt_4_6_);
                    return;
                }
                if ("gametime".equals(p_execute_3_[1])) {
                    int lvt_4_7_ = (int)(p_execute_2_.getEntityWorld().getTotalWorldTime() % Integer.MAX_VALUE);
                    p_execute_2_.setCommandStat(CommandResultStats.Type.QUERY_RESULT, lvt_4_7_);
                    CommandTime.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.time.query", lvt_4_7_);
                    return;
                }
            }
        }
        throw new WrongUsageException("commands.time.usage", new Object[0]);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer p_getTabCompletions_1_, ICommandSender p_getTabCompletions_2_, String[] p_getTabCompletions_3_, BlockPos p_getTabCompletions_4_) {
        if (p_getTabCompletions_3_.length == 1) {
            return CommandTime.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, "set", "add", "query");
        }
        if (p_getTabCompletions_3_.length == 2 && "set".equals(p_getTabCompletions_3_[0])) {
            return CommandTime.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, "day", "night");
        }
        if (p_getTabCompletions_3_.length == 2 && "query".equals(p_getTabCompletions_3_[0])) {
            return CommandTime.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, "daytime", "gametime", "day");
        }
        return Collections.emptyList();
    }

    protected void setAllWorldTimes(MinecraftServer p_setAllWorldTimes_1_, int p_setAllWorldTimes_2_) {
        for (int lvt_3_1_ = 0; lvt_3_1_ < p_setAllWorldTimes_1_.worlds.length; ++lvt_3_1_) {
            p_setAllWorldTimes_1_.worlds[lvt_3_1_].setWorldTime(p_setAllWorldTimes_2_);
        }
    }

    protected void incrementAllWorldTimes(MinecraftServer p_incrementAllWorldTimes_1_, int p_incrementAllWorldTimes_2_) {
        for (int lvt_3_1_ = 0; lvt_3_1_ < p_incrementAllWorldTimes_1_.worlds.length; ++lvt_3_1_) {
            WorldServer lvt_4_1_ = p_incrementAllWorldTimes_1_.worlds[lvt_3_1_];
            lvt_4_1_.setWorldTime(lvt_4_1_.getWorldTime() + (long)p_incrementAllWorldTimes_2_);
        }
    }
}

