/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import com.google.gson.JsonParseException;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.play.server.SPacketTitle;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommandTitle
extends CommandBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public String getName() {
        return "title";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public String getUsage(ICommandSender p_getUsage_1_) {
        return "commands.title.usage";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void execute(MinecraftServer p_execute_1_, ICommandSender p_execute_2_, String[] p_execute_3_) throws CommandException {
        void lvt_7_3_;
        if (p_execute_3_.length < 2) {
            throw new WrongUsageException("commands.title.usage", new Object[0]);
        }
        if (p_execute_3_.length < 3) {
            if ("title".equals(p_execute_3_[1]) || "subtitle".equals(p_execute_3_[1]) || "actionbar".equals(p_execute_3_[1])) {
                throw new WrongUsageException("commands.title.usage.title", new Object[0]);
            }
            if ("times".equals(p_execute_3_[1])) {
                throw new WrongUsageException("commands.title.usage.times", new Object[0]);
            }
        }
        EntityPlayerMP lvt_4_1_ = CommandTitle.getPlayer(p_execute_1_, p_execute_2_, p_execute_3_[0]);
        SPacketTitle.Type lvt_5_1_ = SPacketTitle.Type.byName(p_execute_3_[1]);
        if (lvt_5_1_ == SPacketTitle.Type.CLEAR || lvt_5_1_ == SPacketTitle.Type.RESET) {
            if (p_execute_3_.length != 2) {
                throw new WrongUsageException("commands.title.usage", new Object[0]);
            }
            SPacketTitle lvt_6_1_ = new SPacketTitle(lvt_5_1_, null);
            lvt_4_1_.connection.sendPacket(lvt_6_1_);
            CommandTitle.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.title.success", new Object[0]);
            return;
        }
        if (lvt_5_1_ == SPacketTitle.Type.TIMES) {
            if (p_execute_3_.length != 5) {
                throw new WrongUsageException("commands.title.usage", new Object[0]);
            }
            int lvt_6_2_ = CommandTitle.parseInt(p_execute_3_[2]);
            int lvt_7_1_ = CommandTitle.parseInt(p_execute_3_[3]);
            int lvt_8_1_ = CommandTitle.parseInt(p_execute_3_[4]);
            SPacketTitle lvt_9_1_ = new SPacketTitle(lvt_6_2_, lvt_7_1_, lvt_8_1_);
            lvt_4_1_.connection.sendPacket(lvt_9_1_);
            CommandTitle.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.title.success", new Object[0]);
            return;
        }
        if (p_execute_3_.length < 3) {
            throw new WrongUsageException("commands.title.usage", new Object[0]);
        }
        String lvt_6_3_ = CommandTitle.buildString(p_execute_3_, 2);
        try {
            ITextComponent lvt_7_2_ = ITextComponent.Serializer.jsonToComponent(lvt_6_3_);
        }
        catch (JsonParseException lvt_8_2_) {
            throw CommandTitle.toSyntaxException(lvt_8_2_);
        }
        SPacketTitle lvt_8_3_ = new SPacketTitle(lvt_5_1_, TextComponentUtils.processComponent(p_execute_2_, (ITextComponent)lvt_7_3_, lvt_4_1_));
        lvt_4_1_.connection.sendPacket(lvt_8_3_);
        CommandTitle.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.title.success", new Object[0]);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer p_getTabCompletions_1_, ICommandSender p_getTabCompletions_2_, String[] p_getTabCompletions_3_, BlockPos p_getTabCompletions_4_) {
        if (p_getTabCompletions_3_.length == 1) {
            return CommandTitle.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, p_getTabCompletions_1_.getOnlinePlayerNames());
        }
        if (p_getTabCompletions_3_.length == 2) {
            return CommandTitle.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, SPacketTitle.Type.getNames());
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(String[] p_isUsernameIndex_1_, int p_isUsernameIndex_2_) {
        return p_isUsernameIndex_2_ == 0;
    }
}

