/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.scoreboard.IScoreCriteria;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public class CommandTrigger
extends CommandBase {
    @Override
    public String getName() {
        return "trigger";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 0;
    }

    @Override
    public String getUsage(ICommandSender p_getUsage_1_) {
        return "commands.trigger.usage";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void execute(MinecraftServer p_execute_1_, ICommandSender p_execute_2_, String[] p_execute_3_) throws CommandException {
        void lvt_4_3_;
        if (p_execute_3_.length < 3) {
            throw new WrongUsageException("commands.trigger.usage", new Object[0]);
        }
        if (p_execute_2_ instanceof EntityPlayerMP) {
            EntityPlayerMP lvt_4_1_ = (EntityPlayerMP)p_execute_2_;
        } else {
            Entity lvt_5_1_ = p_execute_2_.getCommandSenderEntity();
            if (lvt_5_1_ instanceof EntityPlayerMP) {
                EntityPlayerMP lvt_4_2_ = (EntityPlayerMP)lvt_5_1_;
            } else {
                throw new CommandException("commands.trigger.invalidPlayer", new Object[0]);
            }
        }
        Scoreboard lvt_5_2_ = p_execute_1_.worldServerForDimension(0).getScoreboard();
        ScoreObjective lvt_6_1_ = lvt_5_2_.getObjective(p_execute_3_[0]);
        if (lvt_6_1_ == null || lvt_6_1_.getCriteria() != IScoreCriteria.TRIGGER) {
            throw new CommandException("commands.trigger.invalidObjective", p_execute_3_[0]);
        }
        int lvt_7_1_ = CommandTrigger.parseInt(p_execute_3_[2]);
        if (!lvt_5_2_.entityHasObjective(lvt_4_3_.getName(), lvt_6_1_)) {
            throw new CommandException("commands.trigger.invalidObjective", p_execute_3_[0]);
        }
        Score lvt_8_1_ = lvt_5_2_.getOrCreateScore(lvt_4_3_.getName(), lvt_6_1_);
        if (lvt_8_1_.isLocked()) {
            throw new CommandException("commands.trigger.disabled", p_execute_3_[0]);
        }
        if ("set".equals(p_execute_3_[1])) {
            lvt_8_1_.setScorePoints(lvt_7_1_);
        } else if ("add".equals(p_execute_3_[1])) {
            lvt_8_1_.increaseScore(lvt_7_1_);
        } else {
            throw new CommandException("commands.trigger.invalidMode", p_execute_3_[1]);
        }
        lvt_8_1_.setLocked(true);
        if (lvt_4_3_.interactionManager.isCreative()) {
            CommandTrigger.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.trigger.success", p_execute_3_[0], p_execute_3_[1], p_execute_3_[2]);
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer p_getTabCompletions_1_, ICommandSender p_getTabCompletions_2_, String[] p_getTabCompletions_3_, BlockPos p_getTabCompletions_4_) {
        if (p_getTabCompletions_3_.length == 1) {
            Scoreboard lvt_5_1_ = p_getTabCompletions_1_.worldServerForDimension(0).getScoreboard();
            ArrayList lvt_6_1_ = Lists.newArrayList();
            for (ScoreObjective lvt_8_1_ : lvt_5_1_.getScoreObjectives()) {
                if (lvt_8_1_.getCriteria() != IScoreCriteria.TRIGGER) continue;
                lvt_6_1_.add(lvt_8_1_.getName());
            }
            return CommandTrigger.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, lvt_6_1_.toArray(new String[lvt_6_1_.size()]));
        }
        if (p_getTabCompletions_3_.length == 2) {
            return CommandTrigger.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, "add", "set");
        }
        return Collections.emptyList();
    }
}

