/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldInfo;

public class CommandWeather
extends CommandBase {
    @Override
    public String getName() {
        return "weather";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public String getUsage(ICommandSender p_getUsage_1_) {
        return "commands.weather.usage";
    }

    @Override
    public void execute(MinecraftServer p_execute_1_, ICommandSender p_execute_2_, String[] p_execute_3_) throws CommandException {
        if (p_execute_3_.length < 1 || p_execute_3_.length > 2) {
            throw new WrongUsageException("commands.weather.usage", new Object[0]);
        }
        int lvt_4_1_ = (300 + new Random().nextInt(600)) * 20;
        if (p_execute_3_.length >= 2) {
            lvt_4_1_ = CommandWeather.parseInt(p_execute_3_[1], 1, 1000000) * 20;
        }
        WorldServer lvt_5_1_ = p_execute_1_.worlds[0];
        WorldInfo lvt_6_1_ = lvt_5_1_.getWorldInfo();
        if ("clear".equalsIgnoreCase(p_execute_3_[0])) {
            lvt_6_1_.setCleanWeatherTime(lvt_4_1_);
            lvt_6_1_.setRainTime(0);
            lvt_6_1_.setThunderTime(0);
            lvt_6_1_.setRaining(false);
            lvt_6_1_.setThundering(false);
            CommandWeather.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.weather.clear", new Object[0]);
        } else if ("rain".equalsIgnoreCase(p_execute_3_[0])) {
            lvt_6_1_.setCleanWeatherTime(0);
            lvt_6_1_.setRainTime(lvt_4_1_);
            lvt_6_1_.setThunderTime(lvt_4_1_);
            lvt_6_1_.setRaining(true);
            lvt_6_1_.setThundering(false);
            CommandWeather.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.weather.rain", new Object[0]);
        } else if ("thunder".equalsIgnoreCase(p_execute_3_[0])) {
            lvt_6_1_.setCleanWeatherTime(0);
            lvt_6_1_.setRainTime(lvt_4_1_);
            lvt_6_1_.setThunderTime(lvt_4_1_);
            lvt_6_1_.setRaining(true);
            lvt_6_1_.setThundering(true);
            CommandWeather.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.weather.thunder", new Object[0]);
        } else {
            throw new WrongUsageException("commands.weather.usage", new Object[0]);
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer p_getTabCompletions_1_, ICommandSender p_getTabCompletions_2_, String[] p_getTabCompletions_3_, BlockPos p_getTabCompletions_4_) {
        if (p_getTabCompletions_3_.length == 1) {
            return CommandWeather.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, "clear", "rain", "thunder");
        }
        return Collections.emptyList();
    }
}

