/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.border.WorldBorder;

public class CommandWorldBorder
extends CommandBase {
    @Override
    public String getName() {
        return "worldborder";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public String getUsage(ICommandSender p_getUsage_1_) {
        return "commands.worldborder.usage";
    }

    @Override
    public void execute(MinecraftServer p_execute_1_, ICommandSender p_execute_2_, String[] p_execute_3_) throws CommandException {
        if (p_execute_3_.length < 1) {
            throw new WrongUsageException("commands.worldborder.usage", new Object[0]);
        }
        WorldBorder lvt_4_1_ = this.getWorldBorder(p_execute_1_);
        if ("set".equals(p_execute_3_[0])) {
            long lvt_9_1_;
            if (p_execute_3_.length != 2 && p_execute_3_.length != 3) {
                throw new WrongUsageException("commands.worldborder.set.usage", new Object[0]);
            }
            double lvt_5_1_ = lvt_4_1_.getTargetSize();
            double lvt_7_1_ = CommandWorldBorder.parseDouble(p_execute_3_[1], 1.0, 6.0E7);
            long l = lvt_9_1_ = p_execute_3_.length > 2 ? CommandWorldBorder.parseLong(p_execute_3_[2], 0L, 9223372036854775L) * 1000L : 0L;
            if (lvt_9_1_ > 0L) {
                lvt_4_1_.setTransition(lvt_5_1_, lvt_7_1_, lvt_9_1_);
                if (lvt_5_1_ > lvt_7_1_) {
                    CommandWorldBorder.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.worldborder.setSlowly.shrink.success", String.format("%.1f", lvt_7_1_), String.format("%.1f", lvt_5_1_), Long.toString(lvt_9_1_ / 1000L));
                } else {
                    CommandWorldBorder.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.worldborder.setSlowly.grow.success", String.format("%.1f", lvt_7_1_), String.format("%.1f", lvt_5_1_), Long.toString(lvt_9_1_ / 1000L));
                }
            } else {
                lvt_4_1_.setTransition(lvt_7_1_);
                CommandWorldBorder.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.worldborder.set.success", String.format("%.1f", lvt_7_1_), String.format("%.1f", lvt_5_1_));
            }
        } else if ("add".equals(p_execute_3_[0])) {
            if (p_execute_3_.length != 2 && p_execute_3_.length != 3) {
                throw new WrongUsageException("commands.worldborder.add.usage", new Object[0]);
            }
            double lvt_5_2_ = lvt_4_1_.getDiameter();
            double lvt_7_2_ = lvt_5_2_ + CommandWorldBorder.parseDouble(p_execute_3_[1], -lvt_5_2_, 6.0E7 - lvt_5_2_);
            long lvt_9_2_ = lvt_4_1_.getTimeUntilTarget() + (p_execute_3_.length > 2 ? CommandWorldBorder.parseLong(p_execute_3_[2], 0L, 9223372036854775L) * 1000L : 0L);
            if (lvt_9_2_ > 0L) {
                lvt_4_1_.setTransition(lvt_5_2_, lvt_7_2_, lvt_9_2_);
                if (lvt_5_2_ > lvt_7_2_) {
                    CommandWorldBorder.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.worldborder.setSlowly.shrink.success", String.format("%.1f", lvt_7_2_), String.format("%.1f", lvt_5_2_), Long.toString(lvt_9_2_ / 1000L));
                } else {
                    CommandWorldBorder.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.worldborder.setSlowly.grow.success", String.format("%.1f", lvt_7_2_), String.format("%.1f", lvt_5_2_), Long.toString(lvt_9_2_ / 1000L));
                }
            } else {
                lvt_4_1_.setTransition(lvt_7_2_);
                CommandWorldBorder.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.worldborder.set.success", String.format("%.1f", lvt_7_2_), String.format("%.1f", lvt_5_2_));
            }
        } else if ("center".equals(p_execute_3_[0])) {
            if (p_execute_3_.length != 3) {
                throw new WrongUsageException("commands.worldborder.center.usage", new Object[0]);
            }
            BlockPos lvt_5_3_ = p_execute_2_.getPosition();
            double lvt_6_1_ = CommandWorldBorder.parseDouble((double)lvt_5_3_.getX() + 0.5, p_execute_3_[1], true);
            double lvt_8_1_ = CommandWorldBorder.parseDouble((double)lvt_5_3_.getZ() + 0.5, p_execute_3_[2], true);
            lvt_4_1_.setCenter(lvt_6_1_, lvt_8_1_);
            CommandWorldBorder.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.worldborder.center.success", lvt_6_1_, lvt_8_1_);
        } else if ("damage".equals(p_execute_3_[0])) {
            if (p_execute_3_.length < 2) {
                throw new WrongUsageException("commands.worldborder.damage.usage", new Object[0]);
            }
            if ("buffer".equals(p_execute_3_[1])) {
                if (p_execute_3_.length != 3) {
                    throw new WrongUsageException("commands.worldborder.damage.buffer.usage", new Object[0]);
                }
                double lvt_5_4_ = CommandWorldBorder.parseDouble(p_execute_3_[2], 0.0);
                double lvt_7_3_ = lvt_4_1_.getDamageBuffer();
                lvt_4_1_.setDamageBuffer(lvt_5_4_);
                CommandWorldBorder.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.worldborder.damage.buffer.success", String.format("%.1f", lvt_5_4_), String.format("%.1f", lvt_7_3_));
            } else if ("amount".equals(p_execute_3_[1])) {
                if (p_execute_3_.length != 3) {
                    throw new WrongUsageException("commands.worldborder.damage.amount.usage", new Object[0]);
                }
                double lvt_5_5_ = CommandWorldBorder.parseDouble(p_execute_3_[2], 0.0);
                double lvt_7_4_ = lvt_4_1_.getDamageAmount();
                lvt_4_1_.setDamageAmount(lvt_5_5_);
                CommandWorldBorder.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.worldborder.damage.amount.success", String.format("%.2f", lvt_5_5_), String.format("%.2f", lvt_7_4_));
            }
        } else if ("warning".equals(p_execute_3_[0])) {
            if (p_execute_3_.length < 2) {
                throw new WrongUsageException("commands.worldborder.warning.usage", new Object[0]);
            }
            if ("time".equals(p_execute_3_[1])) {
                if (p_execute_3_.length != 3) {
                    throw new WrongUsageException("commands.worldborder.warning.time.usage", new Object[0]);
                }
                int lvt_5_6_ = CommandWorldBorder.parseInt(p_execute_3_[2], 0);
                int lvt_6_2_ = lvt_4_1_.getWarningTime();
                lvt_4_1_.setWarningTime(lvt_5_6_);
                CommandWorldBorder.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.worldborder.warning.time.success", lvt_5_6_, lvt_6_2_);
            } else if ("distance".equals(p_execute_3_[1])) {
                if (p_execute_3_.length != 3) {
                    throw new WrongUsageException("commands.worldborder.warning.distance.usage", new Object[0]);
                }
                int lvt_5_7_ = CommandWorldBorder.parseInt(p_execute_3_[2], 0);
                int lvt_6_3_ = lvt_4_1_.getWarningDistance();
                lvt_4_1_.setWarningDistance(lvt_5_7_);
                CommandWorldBorder.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.worldborder.warning.distance.success", lvt_5_7_, lvt_6_3_);
            }
        } else if ("get".equals(p_execute_3_[0])) {
            double lvt_5_8_ = lvt_4_1_.getDiameter();
            p_execute_2_.setCommandStat(CommandResultStats.Type.QUERY_RESULT, MathHelper.floor(lvt_5_8_ + 0.5));
            p_execute_2_.sendMessage(new TextComponentTranslation("commands.worldborder.get.success", String.format("%.0f", lvt_5_8_)));
        } else {
            throw new WrongUsageException("commands.worldborder.usage", new Object[0]);
        }
    }

    protected WorldBorder getWorldBorder(MinecraftServer p_getWorldBorder_1_) {
        return p_getWorldBorder_1_.worlds[0].getWorldBorder();
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer p_getTabCompletions_1_, ICommandSender p_getTabCompletions_2_, String[] p_getTabCompletions_3_, BlockPos p_getTabCompletions_4_) {
        if (p_getTabCompletions_3_.length == 1) {
            return CommandWorldBorder.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, "set", "center", "damage", "warning", "add", "get");
        }
        if (p_getTabCompletions_3_.length == 2 && "damage".equals(p_getTabCompletions_3_[0])) {
            return CommandWorldBorder.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, "buffer", "amount");
        }
        if (p_getTabCompletions_3_.length >= 2 && p_getTabCompletions_3_.length <= 3 && "center".equals(p_getTabCompletions_3_[0])) {
            return CommandWorldBorder.getTabCompletionCoordinateXZ(p_getTabCompletions_3_, 1, p_getTabCompletions_4_);
        }
        if (p_getTabCompletions_3_.length == 2 && "warning".equals(p_getTabCompletions_3_[0])) {
            return CommandWorldBorder.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, "time", "distance");
        }
        return Collections.emptyList();
    }
}

