/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class EntitySelector {
    private static final Pattern TOKEN_PATTERN = Pattern.compile("^@([pare])(?:\\[([^ ]*)\\])?$");
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',').omitEmptyStrings();
    private static final Splitter EQUAL_SPLITTER = Splitter.on((char)'=').limit(2);
    private static final Set<String> VALID_ARGUMENTS = Sets.newHashSet();
    private static final String ARGUMENT_RANGE_MAX = EntitySelector.addArgument("r");
    private static final String ARGUMENT_RANGE_MIN = EntitySelector.addArgument("rm");
    private static final String ARGUMENT_LEVEL_MAX = EntitySelector.addArgument("l");
    private static final String ARGUMENT_LEVEL_MIN = EntitySelector.addArgument("lm");
    private static final String ARGUMENT_COORDINATE_X = EntitySelector.addArgument("x");
    private static final String ARGUMENT_COORDINATE_Y = EntitySelector.addArgument("y");
    private static final String ARGUMENT_COORDINATE_Z = EntitySelector.addArgument("z");
    private static final String ARGUMENT_DELTA_X = EntitySelector.addArgument("dx");
    private static final String ARGUMENT_DELTA_Y = EntitySelector.addArgument("dy");
    private static final String ARGUMENT_DELTA_Z = EntitySelector.addArgument("dz");
    private static final String ARGUMENT_ROTX_MAX = EntitySelector.addArgument("rx");
    private static final String ARGUMENT_ROTX_MIN = EntitySelector.addArgument("rxm");
    private static final String ARGUMENT_ROTY_MAX = EntitySelector.addArgument("ry");
    private static final String ARGUMENT_ROTY_MIN = EntitySelector.addArgument("rym");
    private static final String ARGUMENT_COUNT = EntitySelector.addArgument("c");
    private static final String ARGUMENT_MODE = EntitySelector.addArgument("m");
    private static final String ARGUMENT_TEAM_NAME = EntitySelector.addArgument("team");
    private static final String ARGUMENT_PLAYER_NAME = EntitySelector.addArgument("name");
    private static final String ARGUMENT_ENTITY_TYPE = EntitySelector.addArgument("type");
    private static final String ARGUMENT_ENTITY_TAG = EntitySelector.addArgument("tag");
    private static final Predicate<String> IS_VALID_ARGUMENT = new Predicate<String>(){

        public boolean apply(String p_apply_1_) {
            return p_apply_1_ != null && (VALID_ARGUMENTS.contains(p_apply_1_) || p_apply_1_.length() > "score_".length() && p_apply_1_.startsWith("score_"));
        }
    };
    private static final Set<String> WORLD_BINDING_ARGS = Sets.newHashSet((Object[])new String[]{ARGUMENT_COORDINATE_X, ARGUMENT_COORDINATE_Y, ARGUMENT_COORDINATE_Z, ARGUMENT_DELTA_X, ARGUMENT_DELTA_Y, ARGUMENT_DELTA_Z, ARGUMENT_RANGE_MIN, ARGUMENT_RANGE_MAX});

    private static String addArgument(String p_addArgument_0_) {
        VALID_ARGUMENTS.add(p_addArgument_0_);
        return p_addArgument_0_;
    }

    @Nullable
    public static EntityPlayerMP matchOnePlayer(ICommandSender p_matchOnePlayer_0_, String p_matchOnePlayer_1_) throws CommandException {
        return EntitySelector.matchOneEntity(p_matchOnePlayer_0_, p_matchOnePlayer_1_, EntityPlayerMP.class);
    }

    @Nullable
    public static <T extends Entity> T matchOneEntity(ICommandSender p_matchOneEntity_0_, String p_matchOneEntity_1_, Class<? extends T> p_matchOneEntity_2_) throws CommandException {
        List<T> list = EntitySelector.matchEntities(p_matchOneEntity_0_, p_matchOneEntity_1_, p_matchOneEntity_2_);
        return (T)(list.size() == 1 ? (Entity)list.get(0) : null);
    }

    @Nullable
    public static ITextComponent matchEntitiesToTextComponent(ICommandSender p_matchEntitiesToTextComponent_0_, String p_matchEntitiesToTextComponent_1_) throws CommandException {
        List<Entity> list = EntitySelector.matchEntities(p_matchEntitiesToTextComponent_0_, p_matchEntitiesToTextComponent_1_, Entity.class);
        if (list.isEmpty()) {
            return null;
        }
        ArrayList list1 = Lists.newArrayList();
        for (Entity entity : list) {
            list1.add(entity.getDisplayName());
        }
        return CommandBase.join(list1);
    }

    public static <T extends Entity> List<T> matchEntities(ICommandSender p_matchEntities_0_, String p_matchEntities_1_, Class<? extends T> p_matchEntities_2_) throws CommandException {
        Matcher matcher = TOKEN_PATTERN.matcher(p_matchEntities_1_);
        if (matcher.matches() && p_matchEntities_0_.canUseCommand(1, "@")) {
            Map<String, String> map = EntitySelector.getArgumentMap(matcher.group(2));
            if (!EntitySelector.isEntityTypeValid(p_matchEntities_0_, map)) {
                return Collections.emptyList();
            }
            String s = matcher.group(1);
            BlockPos blockpos = EntitySelector.getBlockPosFromArguments(map, p_matchEntities_0_.getPosition());
            Vec3d vec3d = EntitySelector.getPosFromArguments(map, p_matchEntities_0_.getPositionVector());
            List<World> list = EntitySelector.getWorlds(p_matchEntities_0_, map);
            ArrayList list1 = Lists.newArrayList();
            for (World world : list) {
                if (world == null) continue;
                ArrayList list2 = Lists.newArrayList();
                list2.addAll(EntitySelector.getTypePredicates(map, s));
                list2.addAll(EntitySelector.getXpLevelPredicates(map));
                list2.addAll(EntitySelector.getGamemodePredicates(map));
                list2.addAll(EntitySelector.getTeamPredicates(map));
                list2.addAll(EntitySelector.getScorePredicates(p_matchEntities_0_, map));
                list2.addAll(EntitySelector.getNamePredicates(map));
                list2.addAll(EntitySelector.getTagPredicates(map));
                list2.addAll(EntitySelector.getRadiusPredicates(map, vec3d));
                list2.addAll(EntitySelector.getRotationsPredicates(map));
                list2.addAll(ForgeEventFactory.gatherEntitySelectors(map, s, p_matchEntities_0_, vec3d));
                list1.addAll(EntitySelector.filterResults(map, p_matchEntities_2_, list2, s, world, blockpos));
            }
            return EntitySelector.getEntitiesFromPredicates(list1, map, p_matchEntities_0_, p_matchEntities_2_, s, vec3d);
        }
        return Collections.emptyList();
    }

    private static List<World> getWorlds(ICommandSender p_getWorlds_0_, Map<String, String> p_getWorlds_1_) {
        ArrayList list = Lists.newArrayList();
        if (EntitySelector.hasArgument(p_getWorlds_1_)) {
            list.add(p_getWorlds_0_.getEntityWorld());
        } else {
            Collections.addAll(list, p_getWorlds_0_.getServer().worlds);
        }
        return list;
    }

    private static <T extends Entity> boolean isEntityTypeValid(ICommandSender p_isEntityTypeValid_0_, Map<String, String> p_isEntityTypeValid_1_) {
        String s = EntitySelector.getArgument(p_isEntityTypeValid_1_, ARGUMENT_ENTITY_TYPE);
        if (s == null) {
            return true;
        }
        ResourceLocation resourcelocation = new ResourceLocation(s.startsWith("!") ? s.substring(1) : s);
        if (EntityList.isRegistered(resourcelocation)) {
            return true;
        }
        TextComponentTranslation textcomponenttranslation = new TextComponentTranslation("commands.generic.entity.invalidType", resourcelocation);
        textcomponenttranslation.getStyle().setColor(TextFormatting.RED);
        p_isEntityTypeValid_0_.sendMessage(textcomponenttranslation);
        return false;
    }

    private static List<Predicate<Entity>> getTypePredicates(Map<String, String> p_getTypePredicates_0_, String p_getTypePredicates_1_) {
        String s = EntitySelector.getArgument(p_getTypePredicates_0_, ARGUMENT_ENTITY_TYPE);
        if (s == null || !p_getTypePredicates_1_.equals("e") && !p_getTypePredicates_1_.equals("r")) {
            return !p_getTypePredicates_1_.equals("e") ? Collections.singletonList(new Predicate<Entity>(){

                public boolean apply(Entity p_apply_1_) {
                    return p_apply_1_ instanceof EntityPlayer;
                }
            }) : Collections.emptyList();
        }
        final boolean flag = s.startsWith("!");
        final ResourceLocation resourcelocation = new ResourceLocation(flag ? s.substring(1) : s);
        return Collections.singletonList(new Predicate<Entity>(){

            public boolean apply(Entity p_apply_1_) {
                return EntityList.isMatchingName(p_apply_1_, resourcelocation) != flag;
            }
        });
    }

    private static List<Predicate<Entity>> getXpLevelPredicates(Map<String, String> p_getXpLevelPredicates_0_) {
        ArrayList list = Lists.newArrayList();
        final int i = EntitySelector.getInt(p_getXpLevelPredicates_0_, ARGUMENT_LEVEL_MIN, -1);
        final int j = EntitySelector.getInt(p_getXpLevelPredicates_0_, ARGUMENT_LEVEL_MAX, -1);
        if (i > -1 || j > -1) {
            list.add(new Predicate<Entity>(){

                public boolean apply(Entity p_apply_1_) {
                    if (!(p_apply_1_ instanceof EntityPlayerMP)) {
                        return false;
                    }
                    EntityPlayerMP entityplayermp = (EntityPlayerMP)p_apply_1_;
                    return !(i > -1 && entityplayermp.experienceLevel < i || j > -1 && entityplayermp.experienceLevel > j);
                }
            });
        }
        return list;
    }

    private static List<Predicate<Entity>> getGamemodePredicates(Map<String, String> p_getGamemodePredicates_0_) {
        GameType gametype;
        ArrayList list = Lists.newArrayList();
        String s = EntitySelector.getArgument(p_getGamemodePredicates_0_, ARGUMENT_MODE);
        if (s == null) {
            return list;
        }
        final boolean flag = s.startsWith("!");
        if (flag) {
            s = s.substring(1);
        }
        try {
            int i = Integer.parseInt(s);
            gametype = GameType.parseGameTypeWithDefault(i, GameType.NOT_SET);
        }
        catch (Throwable var6) {
            gametype = GameType.parseGameTypeWithDefault(s, GameType.NOT_SET);
        }
        final GameType type = gametype;
        list.add(new Predicate<Entity>(){

            public boolean apply(Entity p_apply_1_) {
                if (!(p_apply_1_ instanceof EntityPlayerMP)) {
                    return false;
                }
                EntityPlayerMP entityplayermp = (EntityPlayerMP)p_apply_1_;
                GameType gametype1 = entityplayermp.interactionManager.getGameType();
                return flag ? gametype1 != type : gametype1 == type;
            }
        });
        return list;
    }

    private static List<Predicate<Entity>> getTeamPredicates(Map<String, String> p_getTeamPredicates_0_) {
        boolean flag;
        ArrayList list = Lists.newArrayList();
        String s = EntitySelector.getArgument(p_getTeamPredicates_0_, ARGUMENT_TEAM_NAME);
        boolean bl = flag = s != null && s.startsWith("!");
        if (flag) {
            s = s.substring(1);
        }
        if (s != null) {
            final String s_f = s;
            list.add(new Predicate<Entity>(){

                public boolean apply(Entity p_apply_1_) {
                    if (!(p_apply_1_ instanceof EntityLivingBase)) {
                        return false;
                    }
                    EntityLivingBase entitylivingbase = (EntityLivingBase)p_apply_1_;
                    Team team = entitylivingbase.getTeam();
                    String s1 = team == null ? "" : team.getRegisteredName();
                    return s1.equals(s_f) != flag;
                }
            });
        }
        return list;
    }

    private static List<Predicate<Entity>> getScorePredicates(final ICommandSender p_getScorePredicates_0_, Map<String, String> p_getScorePredicates_1_) {
        final Map<String, Integer> map = EntitySelector.getScoreMap(p_getScorePredicates_1_);
        return map.isEmpty() ? Collections.emptyList() : Lists.newArrayList((Object[])new Predicate[]{new Predicate<Entity>(){

            public boolean apply(Entity p_apply_1_) {
                if (p_apply_1_ == null) {
                    return false;
                }
                Scoreboard scoreboard = p_getScorePredicates_0_.getServer().worldServerForDimension(0).getScoreboard();
                for (Map.Entry entry : map.entrySet()) {
                    String s1;
                    ScoreObjective scoreobjective;
                    String s = (String)entry.getKey();
                    boolean flag = false;
                    if (s.endsWith("_min") && s.length() > 4) {
                        flag = true;
                        s = s.substring(0, s.length() - 4);
                    }
                    if ((scoreobjective = scoreboard.getObjective(s)) == null) {
                        return false;
                    }
                    String string = s1 = p_apply_1_ instanceof EntityPlayerMP ? p_apply_1_.getName() : p_apply_1_.getCachedUniqueIdString();
                    if (!scoreboard.entityHasObjective(s1, scoreobjective)) {
                        return false;
                    }
                    Score score = scoreboard.getOrCreateScore(s1, scoreobjective);
                    int i = score.getScorePoints();
                    if (i < (Integer)entry.getValue() && flag) {
                        return false;
                    }
                    if (i <= (Integer)entry.getValue() || flag) continue;
                    return false;
                }
                return true;
            }
        }});
    }

    private static List<Predicate<Entity>> getNamePredicates(Map<String, String> p_getNamePredicates_0_) {
        boolean flag;
        ArrayList list = Lists.newArrayList();
        String s = EntitySelector.getArgument(p_getNamePredicates_0_, ARGUMENT_PLAYER_NAME);
        boolean bl = flag = s != null && s.startsWith("!");
        if (flag) {
            s = s.substring(1);
        }
        if (s != null) {
            final String s_f = s;
            list.add(new Predicate<Entity>(){

                public boolean apply(Entity p_apply_1_) {
                    return p_apply_1_ != null && p_apply_1_.getName().equals(s_f) != flag;
                }
            });
        }
        return list;
    }

    private static List<Predicate<Entity>> getTagPredicates(Map<String, String> p_getTagPredicates_0_) {
        boolean flag;
        ArrayList list = Lists.newArrayList();
        String s = EntitySelector.getArgument(p_getTagPredicates_0_, ARGUMENT_ENTITY_TAG);
        boolean bl = flag = s != null && s.startsWith("!");
        if (flag) {
            s = s.substring(1);
        }
        if (s != null) {
            final String s_f = s;
            list.add(new Predicate<Entity>(){

                public boolean apply(Entity p_apply_1_) {
                    return p_apply_1_ == null ? false : ("".equals(s_f) ? p_apply_1_.getTags().isEmpty() != flag : p_apply_1_.getTags().contains(s_f) != flag);
                }
            });
        }
        return list;
    }

    private static List<Predicate<Entity>> getRadiusPredicates(Map<String, String> p_getRadiusPredicates_0_, final Vec3d p_getRadiusPredicates_1_) {
        boolean flag1;
        double d0 = EntitySelector.getInt(p_getRadiusPredicates_0_, ARGUMENT_RANGE_MIN, -1);
        double d1 = EntitySelector.getInt(p_getRadiusPredicates_0_, ARGUMENT_RANGE_MAX, -1);
        final boolean flag = d0 < -0.5;
        boolean bl = flag1 = d1 < -0.5;
        if (flag && flag1) {
            return Collections.emptyList();
        }
        double d2 = Math.max(d0, 1.0E-4);
        final double d3 = d2 * d2;
        double d4 = Math.max(d1, 1.0E-4);
        final double d5 = d4 * d4;
        return Lists.newArrayList((Object[])new Predicate[]{new Predicate<Entity>(){

            public boolean apply(Entity p_apply_1_) {
                if (p_apply_1_ == null) {
                    return false;
                }
                double d6 = p_getRadiusPredicates_1_.squareDistanceTo(p_apply_1_.posX, p_apply_1_.posY, p_apply_1_.posZ);
                return (flag || d6 >= d3) && (flag1 || d6 <= d5);
            }
        }});
    }

    private static List<Predicate<Entity>> getRotationsPredicates(Map<String, String> p_getRotationsPredicates_0_) {
        ArrayList list = Lists.newArrayList();
        if (p_getRotationsPredicates_0_.containsKey(ARGUMENT_ROTY_MIN) || p_getRotationsPredicates_0_.containsKey(ARGUMENT_ROTY_MAX)) {
            final int i = MathHelper.clampAngle(EntitySelector.getInt(p_getRotationsPredicates_0_, ARGUMENT_ROTY_MIN, 0));
            final int j = MathHelper.clampAngle(EntitySelector.getInt(p_getRotationsPredicates_0_, ARGUMENT_ROTY_MAX, 359));
            list.add(new Predicate<Entity>(){

                public boolean apply(Entity p_apply_1_) {
                    if (p_apply_1_ == null) {
                        return false;
                    }
                    int i1 = MathHelper.clampAngle(MathHelper.floor(p_apply_1_.rotationYaw));
                    return i > j ? i1 >= i || i1 <= j : i1 >= i && i1 <= j;
                }
            });
        }
        if (p_getRotationsPredicates_0_.containsKey(ARGUMENT_ROTX_MIN) || p_getRotationsPredicates_0_.containsKey(ARGUMENT_ROTX_MAX)) {
            final int k = MathHelper.clampAngle(EntitySelector.getInt(p_getRotationsPredicates_0_, ARGUMENT_ROTX_MIN, 0));
            final int l = MathHelper.clampAngle(EntitySelector.getInt(p_getRotationsPredicates_0_, ARGUMENT_ROTX_MAX, 359));
            list.add(new Predicate<Entity>(){

                public boolean apply(Entity p_apply_1_) {
                    if (p_apply_1_ == null) {
                        return false;
                    }
                    int i1 = MathHelper.clampAngle(MathHelper.floor(p_apply_1_.rotationPitch));
                    return k > l ? i1 >= k || i1 <= l : i1 >= k && i1 <= l;
                }
            });
        }
        return list;
    }

    private static <T extends Entity> List<T> filterResults(Map<String, String> p_filterResults_0_, Class<? extends T> p_filterResults_1_, List<Predicate<Entity>> p_filterResults_2_, String p_filterResults_3_, World p_filterResults_4_, BlockPos p_filterResults_5_) {
        ArrayList list = Lists.newArrayList();
        String s = EntitySelector.getArgument(p_filterResults_0_, ARGUMENT_ENTITY_TYPE);
        s = s != null && s.startsWith("!") ? s.substring(1) : s;
        boolean flag = !p_filterResults_3_.equals("e");
        boolean flag1 = p_filterResults_3_.equals("r") && s != null;
        int i = EntitySelector.getInt(p_filterResults_0_, ARGUMENT_DELTA_X, 0);
        int j = EntitySelector.getInt(p_filterResults_0_, ARGUMENT_DELTA_Y, 0);
        int k = EntitySelector.getInt(p_filterResults_0_, ARGUMENT_DELTA_Z, 0);
        int l = EntitySelector.getInt(p_filterResults_0_, ARGUMENT_RANGE_MAX, -1);
        Predicate predicate = Predicates.and(p_filterResults_2_);
        Predicate predicate1 = Predicates.and(EntitySelectors.IS_ALIVE, (Predicate)predicate);
        if (!(p_filterResults_0_.containsKey(ARGUMENT_DELTA_X) || p_filterResults_0_.containsKey(ARGUMENT_DELTA_Y) || p_filterResults_0_.containsKey(ARGUMENT_DELTA_Z))) {
            if (l >= 0) {
                AxisAlignedBB axisalignedbb1 = new AxisAlignedBB(p_filterResults_5_.getX() - l, p_filterResults_5_.getY() - l, p_filterResults_5_.getZ() - l, p_filterResults_5_.getX() + l + 1, p_filterResults_5_.getY() + l + 1, p_filterResults_5_.getZ() + l + 1);
                if (flag && !flag1) {
                    list.addAll(p_filterResults_4_.getPlayers(p_filterResults_1_, predicate1));
                } else {
                    list.addAll(p_filterResults_4_.getEntitiesWithinAABB(p_filterResults_1_, axisalignedbb1, predicate1));
                }
            } else if (p_filterResults_3_.equals("a")) {
                list.addAll(p_filterResults_4_.getPlayers(p_filterResults_1_, predicate));
            } else if (!(p_filterResults_3_.equals("p") || p_filterResults_3_.equals("r") && !flag1)) {
                list.addAll(p_filterResults_4_.getEntities(p_filterResults_1_, predicate1));
            } else {
                list.addAll(p_filterResults_4_.getPlayers(p_filterResults_1_, predicate1));
            }
        } else {
            final AxisAlignedBB axisalignedbb = EntitySelector.getAABB(p_filterResults_5_, i, j, k);
            if (flag && !flag1) {
                Predicate<Entity> predicate2 = new Predicate<Entity>(){

                    public boolean apply(Entity p_apply_1_) {
                        return p_apply_1_ != null && axisalignedbb.intersectsWith(p_apply_1_.getEntityBoundingBox());
                    }
                };
                list.addAll(p_filterResults_4_.getPlayers(p_filterResults_1_, Predicates.and((Predicate)predicate1, (Predicate)predicate2)));
            } else {
                list.addAll(p_filterResults_4_.getEntitiesWithinAABB(p_filterResults_1_, axisalignedbb, predicate1));
            }
        }
        return list;
    }

    private static <T extends Entity> List<T> getEntitiesFromPredicates(List<T> p_getEntitiesFromPredicates_0_, Map<String, String> p_getEntitiesFromPredicates_1_, ICommandSender p_getEntitiesFromPredicates_2_, Class<? extends T> p_getEntitiesFromPredicates_3_, String p_getEntitiesFromPredicates_4_, final Vec3d p_getEntitiesFromPredicates_5_) {
        Entity entity;
        int i = EntitySelector.getInt(p_getEntitiesFromPredicates_1_, ARGUMENT_COUNT, !p_getEntitiesFromPredicates_4_.equals("a") && !p_getEntitiesFromPredicates_4_.equals("e") ? 1 : 0);
        if (!(p_getEntitiesFromPredicates_4_.equals("p") || p_getEntitiesFromPredicates_4_.equals("a") || p_getEntitiesFromPredicates_4_.equals("e"))) {
            if (p_getEntitiesFromPredicates_4_.equals("r")) {
                Collections.shuffle(p_getEntitiesFromPredicates_0_);
            }
        } else {
            Collections.sort(p_getEntitiesFromPredicates_0_, new Comparator<Entity>(){

                @Override
                public int compare(Entity p_compare_1_, Entity p_compare_2_) {
                    return ComparisonChain.start().compare(p_compare_1_.getDistanceSq(p_getEntitiesFromPredicates_5_.xCoord, p_getEntitiesFromPredicates_5_.yCoord, p_getEntitiesFromPredicates_5_.zCoord), p_compare_2_.getDistanceSq(p_getEntitiesFromPredicates_5_.xCoord, p_getEntitiesFromPredicates_5_.yCoord, p_getEntitiesFromPredicates_5_.zCoord)).result();
                }
            });
        }
        if ((entity = p_getEntitiesFromPredicates_2_.getCommandSenderEntity()) != null && p_getEntitiesFromPredicates_3_.isAssignableFrom(entity.getClass()) && i == 1 && p_getEntitiesFromPredicates_0_.contains(entity) && !"r".equals(p_getEntitiesFromPredicates_4_)) {
            p_getEntitiesFromPredicates_0_ = Lists.newArrayList((Object[])new Entity[]{entity});
        }
        if (i != 0) {
            if (i < 0) {
                Collections.reverse(p_getEntitiesFromPredicates_0_);
            }
            p_getEntitiesFromPredicates_0_ = p_getEntitiesFromPredicates_0_.subList(0, Math.min(Math.abs(i), p_getEntitiesFromPredicates_0_.size()));
        }
        return p_getEntitiesFromPredicates_0_;
    }

    private static AxisAlignedBB getAABB(BlockPos p_getAABB_0_, int p_getAABB_1_, int p_getAABB_2_, int p_getAABB_3_) {
        boolean flag = p_getAABB_1_ < 0;
        boolean flag1 = p_getAABB_2_ < 0;
        boolean flag2 = p_getAABB_3_ < 0;
        int i = p_getAABB_0_.getX() + (flag ? p_getAABB_1_ : 0);
        int j = p_getAABB_0_.getY() + (flag1 ? p_getAABB_2_ : 0);
        int k = p_getAABB_0_.getZ() + (flag2 ? p_getAABB_3_ : 0);
        int l = p_getAABB_0_.getX() + (flag ? 0 : p_getAABB_1_) + 1;
        int i1 = p_getAABB_0_.getY() + (flag1 ? 0 : p_getAABB_2_) + 1;
        int j1 = p_getAABB_0_.getZ() + (flag2 ? 0 : p_getAABB_3_) + 1;
        return new AxisAlignedBB(i, j, k, l, i1, j1);
    }

    private static BlockPos getBlockPosFromArguments(Map<String, String> p_getBlockPosFromArguments_0_, BlockPos p_getBlockPosFromArguments_1_) {
        return new BlockPos(EntitySelector.getInt(p_getBlockPosFromArguments_0_, ARGUMENT_COORDINATE_X, p_getBlockPosFromArguments_1_.getX()), EntitySelector.getInt(p_getBlockPosFromArguments_0_, ARGUMENT_COORDINATE_Y, p_getBlockPosFromArguments_1_.getY()), EntitySelector.getInt(p_getBlockPosFromArguments_0_, ARGUMENT_COORDINATE_Z, p_getBlockPosFromArguments_1_.getZ()));
    }

    private static Vec3d getPosFromArguments(Map<String, String> p_getPosFromArguments_0_, Vec3d p_getPosFromArguments_1_) {
        return new Vec3d(EntitySelector.getCoordinate(p_getPosFromArguments_0_, ARGUMENT_COORDINATE_X, p_getPosFromArguments_1_.xCoord, true), EntitySelector.getCoordinate(p_getPosFromArguments_0_, ARGUMENT_COORDINATE_Y, p_getPosFromArguments_1_.yCoord, false), EntitySelector.getCoordinate(p_getPosFromArguments_0_, ARGUMENT_COORDINATE_Z, p_getPosFromArguments_1_.zCoord, true));
    }

    private static double getCoordinate(Map<String, String> p_getCoordinate_0_, String p_getCoordinate_1_, double p_getCoordinate_2_, boolean p_getCoordinate_4_) {
        return p_getCoordinate_0_.containsKey(p_getCoordinate_1_) ? (double)MathHelper.getInt(p_getCoordinate_0_.get(p_getCoordinate_1_), MathHelper.floor(p_getCoordinate_2_)) + (p_getCoordinate_4_ ? 0.5 : 0.0) : p_getCoordinate_2_;
    }

    private static boolean hasArgument(Map<String, String> p_hasArgument_0_) {
        for (String s : WORLD_BINDING_ARGS) {
            if (!p_hasArgument_0_.containsKey(s)) continue;
            return true;
        }
        return false;
    }

    private static int getInt(Map<String, String> p_getInt_0_, String p_getInt_1_, int p_getInt_2_) {
        return p_getInt_0_.containsKey(p_getInt_1_) ? MathHelper.getInt(p_getInt_0_.get(p_getInt_1_), p_getInt_2_) : p_getInt_2_;
    }

    @Nullable
    private static String getArgument(Map<String, String> p_getArgument_0_, String p_getArgument_1_) {
        return p_getArgument_0_.get(p_getArgument_1_);
    }

    public static Map<String, Integer> getScoreMap(Map<String, String> p_getScoreMap_0_) {
        HashMap map = Maps.newHashMap();
        for (String s : p_getScoreMap_0_.keySet()) {
            if (!s.startsWith("score_") || s.length() <= "score_".length()) continue;
            map.put(s.substring("score_".length()), MathHelper.getInt(p_getScoreMap_0_.get(s), 1));
        }
        return map;
    }

    public static boolean matchesMultiplePlayers(String p_matchesMultiplePlayers_0_) throws CommandException {
        Matcher matcher = TOKEN_PATTERN.matcher(p_matchesMultiplePlayers_0_);
        if (!matcher.matches()) {
            return false;
        }
        Map<String, String> map = EntitySelector.getArgumentMap(matcher.group(2));
        String s = matcher.group(1);
        int i = !"a".equals(s) && !"e".equals(s) ? 1 : 0;
        return EntitySelector.getInt(map, ARGUMENT_COUNT, i) != 1;
    }

    public static boolean isSelector(String p_isSelector_0_) {
        return TOKEN_PATTERN.matcher(p_isSelector_0_).matches();
    }

    private static Map<String, String> getArgumentMap(String p_getArgumentMap_0_) throws CommandException {
        HashMap map = Maps.newHashMap();
        if (p_getArgumentMap_0_ == null) {
            return map;
        }
        for (String s : COMMA_SPLITTER.split((CharSequence)p_getArgumentMap_0_)) {
            Iterator iterator = EQUAL_SPLITTER.split((CharSequence)s).iterator();
            String s1 = (String)iterator.next();
            if (!IS_VALID_ARGUMENT.apply((Object)s1)) {
                throw new CommandException("commands.generic.selector_argument", s);
            }
            map.put(s1, iterator.hasNext() ? (String)iterator.next() : "");
        }
        return map;
    }
}

