/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandBlockData;
import net.minecraft.command.CommandClearInventory;
import net.minecraft.command.CommandClone;
import net.minecraft.command.CommandCompare;
import net.minecraft.command.CommandDebug;
import net.minecraft.command.CommandDefaultGameMode;
import net.minecraft.command.CommandDifficulty;
import net.minecraft.command.CommandEffect;
import net.minecraft.command.CommandEnchant;
import net.minecraft.command.CommandEntityData;
import net.minecraft.command.CommandExecuteAt;
import net.minecraft.command.CommandFill;
import net.minecraft.command.CommandGameMode;
import net.minecraft.command.CommandGameRule;
import net.minecraft.command.CommandGive;
import net.minecraft.command.CommandHandler;
import net.minecraft.command.CommandHelp;
import net.minecraft.command.CommandKill;
import net.minecraft.command.CommandLocate;
import net.minecraft.command.CommandParticle;
import net.minecraft.command.CommandPlaySound;
import net.minecraft.command.CommandReplaceItem;
import net.minecraft.command.CommandServerKick;
import net.minecraft.command.CommandSetPlayerTimeout;
import net.minecraft.command.CommandSetSpawnpoint;
import net.minecraft.command.CommandShowSeed;
import net.minecraft.command.CommandSpreadPlayers;
import net.minecraft.command.CommandStats;
import net.minecraft.command.CommandStopSound;
import net.minecraft.command.CommandTP;
import net.minecraft.command.CommandTime;
import net.minecraft.command.CommandTitle;
import net.minecraft.command.CommandToggleDownfall;
import net.minecraft.command.CommandTrigger;
import net.minecraft.command.CommandWeather;
import net.minecraft.command.CommandWorldBorder;
import net.minecraft.command.CommandXP;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandListener;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.server.CommandAchievement;
import net.minecraft.command.server.CommandBanIp;
import net.minecraft.command.server.CommandBanPlayer;
import net.minecraft.command.server.CommandBroadcast;
import net.minecraft.command.server.CommandDeOp;
import net.minecraft.command.server.CommandEmote;
import net.minecraft.command.server.CommandListBans;
import net.minecraft.command.server.CommandListPlayers;
import net.minecraft.command.server.CommandMessage;
import net.minecraft.command.server.CommandMessageRaw;
import net.minecraft.command.server.CommandOp;
import net.minecraft.command.server.CommandPardonIp;
import net.minecraft.command.server.CommandPardonPlayer;
import net.minecraft.command.server.CommandPublishLocalServer;
import net.minecraft.command.server.CommandSaveAll;
import net.minecraft.command.server.CommandSaveOff;
import net.minecraft.command.server.CommandSaveOn;
import net.minecraft.command.server.CommandScoreboard;
import net.minecraft.command.server.CommandSetBlock;
import net.minecraft.command.server.CommandSetDefaultSpawnpoint;
import net.minecraft.command.server.CommandStop;
import net.minecraft.command.server.CommandSummon;
import net.minecraft.command.server.CommandTeleport;
import net.minecraft.command.server.CommandTestFor;
import net.minecraft.command.server.CommandTestForBlock;
import net.minecraft.command.server.CommandWhitelist;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.rcon.RConConsoleSource;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.CommandBlockBaseLogic;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class ServerCommandManager
extends CommandHandler
implements ICommandListener {
    private final MinecraftServer server;

    public ServerCommandManager(MinecraftServer p_i46985_1_) {
        this.server = p_i46985_1_;
        this.registerCommand(new CommandTime());
        this.registerCommand(new CommandGameMode());
        this.registerCommand(new CommandDifficulty());
        this.registerCommand(new CommandDefaultGameMode());
        this.registerCommand(new CommandKill());
        this.registerCommand(new CommandToggleDownfall());
        this.registerCommand(new CommandWeather());
        this.registerCommand(new CommandXP());
        this.registerCommand(new CommandTP());
        this.registerCommand(new CommandTeleport());
        this.registerCommand(new CommandGive());
        this.registerCommand(new CommandReplaceItem());
        this.registerCommand(new CommandStats());
        this.registerCommand(new CommandEffect());
        this.registerCommand(new CommandEnchant());
        this.registerCommand(new CommandParticle());
        this.registerCommand(new CommandEmote());
        this.registerCommand(new CommandShowSeed());
        this.registerCommand(new CommandHelp());
        this.registerCommand(new CommandDebug());
        this.registerCommand(new CommandMessage());
        this.registerCommand(new CommandBroadcast());
        this.registerCommand(new CommandSetSpawnpoint());
        this.registerCommand(new CommandSetDefaultSpawnpoint());
        this.registerCommand(new CommandGameRule());
        this.registerCommand(new CommandClearInventory());
        this.registerCommand(new CommandTestFor());
        this.registerCommand(new CommandSpreadPlayers());
        this.registerCommand(new CommandPlaySound());
        this.registerCommand(new CommandScoreboard());
        this.registerCommand(new CommandExecuteAt());
        this.registerCommand(new CommandTrigger());
        this.registerCommand(new CommandAchievement());
        this.registerCommand(new CommandSummon());
        this.registerCommand(new CommandSetBlock());
        this.registerCommand(new CommandFill());
        this.registerCommand(new CommandClone());
        this.registerCommand(new CommandCompare());
        this.registerCommand(new CommandBlockData());
        this.registerCommand(new CommandTestForBlock());
        this.registerCommand(new CommandMessageRaw());
        this.registerCommand(new CommandWorldBorder());
        this.registerCommand(new CommandTitle());
        this.registerCommand(new CommandEntityData());
        this.registerCommand(new CommandStopSound());
        this.registerCommand(new CommandLocate());
        if (p_i46985_1_.isDedicatedServer()) {
            this.registerCommand(new CommandOp());
            this.registerCommand(new CommandDeOp());
            this.registerCommand(new CommandStop());
            this.registerCommand(new CommandSaveAll());
            this.registerCommand(new CommandSaveOff());
            this.registerCommand(new CommandSaveOn());
            this.registerCommand(new CommandBanIp());
            this.registerCommand(new CommandPardonIp());
            this.registerCommand(new CommandBanPlayer());
            this.registerCommand(new CommandListBans());
            this.registerCommand(new CommandPardonPlayer());
            this.registerCommand(new CommandServerKick());
            this.registerCommand(new CommandListPlayers());
            this.registerCommand(new CommandWhitelist());
            this.registerCommand(new CommandSetPlayerTimeout());
        } else {
            this.registerCommand(new CommandPublishLocalServer());
        }
        CommandBase.setCommandListener(this);
    }

    @Override
    public void notifyListener(ICommandSender p_notifyListener_1_, ICommand p_notifyListener_2_, int p_notifyListener_3_, String p_notifyListener_4_, Object ... p_notifyListener_5_) {
        boolean lvt_6_1_ = true;
        MinecraftServer lvt_7_1_ = this.server;
        if (!p_notifyListener_1_.sendCommandFeedback()) {
            lvt_6_1_ = false;
        }
        TextComponentTranslation lvt_8_1_ = new TextComponentTranslation("chat.type.admin", p_notifyListener_1_.getName(), new TextComponentTranslation(p_notifyListener_4_, p_notifyListener_5_));
        lvt_8_1_.getStyle().setColor(TextFormatting.GRAY);
        lvt_8_1_.getStyle().setItalic(true);
        if (lvt_6_1_) {
            for (EntityPlayer entityPlayer : lvt_7_1_.getPlayerList().getPlayers()) {
                boolean lvt_12_1_;
                if (entityPlayer == p_notifyListener_1_ || !lvt_7_1_.getPlayerList().canSendCommands(entityPlayer.getGameProfile()) || !p_notifyListener_2_.checkPermission(this.server, p_notifyListener_1_)) continue;
                boolean lvt_11_1_ = p_notifyListener_1_ instanceof MinecraftServer && this.server.shouldBroadcastConsoleToOps();
                boolean bl = lvt_12_1_ = p_notifyListener_1_ instanceof RConConsoleSource && this.server.shouldBroadcastRconToOps();
                if (!lvt_11_1_ && !lvt_12_1_ && (p_notifyListener_1_ instanceof RConConsoleSource || p_notifyListener_1_ instanceof MinecraftServer)) continue;
                entityPlayer.sendMessage(lvt_8_1_);
            }
        }
        if (p_notifyListener_1_ != lvt_7_1_ && lvt_7_1_.worlds[0].getGameRules().getBoolean("logAdminCommands")) {
            lvt_7_1_.sendMessage(lvt_8_1_);
        }
        boolean lvt_9_1_ = lvt_7_1_.worlds[0].getGameRules().getBoolean("sendCommandFeedback");
        if (p_notifyListener_1_ instanceof CommandBlockBaseLogic) {
            lvt_9_1_ = ((CommandBlockBaseLogic)p_notifyListener_1_).shouldTrackOutput();
        }
        if ((p_notifyListener_3_ & 1) != 1 && lvt_9_1_ || p_notifyListener_1_ instanceof MinecraftServer) {
            p_notifyListener_1_.sendMessage(new TextComponentTranslation(p_notifyListener_4_, p_notifyListener_5_));
        }
    }

    @Override
    protected MinecraftServer getServer() {
        return this.server;
    }
}

