/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.server;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.math.BlockPos;

public class CommandAchievement
extends CommandBase {
    @Override
    public String getName() {
        return "achievement";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public String getUsage(ICommandSender p_getUsage_1_) {
        return "commands.achievement.usage";
    }

    @Override
    public void execute(MinecraftServer p_execute_1_, ICommandSender p_execute_2_, String[] p_execute_3_) throws CommandException {
        if (p_execute_3_.length < 2) {
            throw new WrongUsageException("commands.achievement.usage", new Object[0]);
        }
        final StatBase lvt_4_1_ = StatList.getOneShotStat(p_execute_3_[1]);
        if (lvt_4_1_ == null && !"*".equals(p_execute_3_[1]) || lvt_4_1_ != null && !lvt_4_1_.isAchievement()) {
            throw new CommandException("commands.achievement.unknownAchievement", p_execute_3_[1]);
        }
        final EntityPlayerMP lvt_5_1_ = p_execute_3_.length >= 3 ? CommandAchievement.getPlayer(p_execute_1_, p_execute_2_, p_execute_3_[2]) : CommandAchievement.getCommandSenderAsPlayer(p_execute_2_);
        boolean lvt_6_1_ = "give".equalsIgnoreCase(p_execute_3_[0]);
        boolean lvt_7_1_ = "take".equalsIgnoreCase(p_execute_3_[0]);
        if (!lvt_6_1_ && !lvt_7_1_) {
            return;
        }
        if (lvt_4_1_ == null) {
            if (lvt_6_1_) {
                for (Achievement lvt_9_1_ : AchievementList.ACHIEVEMENTS) {
                    lvt_5_1_.addStat(lvt_9_1_);
                }
                CommandAchievement.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.achievement.give.success.all", lvt_5_1_.getName());
            } else if (lvt_7_1_) {
                for (Achievement lvt_9_2_ : Lists.reverse(AchievementList.ACHIEVEMENTS)) {
                    lvt_5_1_.takeStat(lvt_9_2_);
                }
                CommandAchievement.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.achievement.take.success.all", lvt_5_1_.getName());
            }
            return;
        }
        if (lvt_4_1_ instanceof Achievement) {
            Achievement lvt_8_1_ = (Achievement)lvt_4_1_;
            if (lvt_6_1_) {
                if (lvt_5_1_.getStatFile().hasAchievementUnlocked(lvt_8_1_)) {
                    throw new CommandException("commands.achievement.alreadyHave", lvt_5_1_.getName(), lvt_4_1_.createChatComponent());
                }
                ArrayList lvt_9_3_ = Lists.newArrayList();
                while (lvt_8_1_.parentAchievement != null && !lvt_5_1_.getStatFile().hasAchievementUnlocked(lvt_8_1_.parentAchievement)) {
                    lvt_9_3_.add(lvt_8_1_.parentAchievement);
                    lvt_8_1_ = lvt_8_1_.parentAchievement;
                }
                for (Achievement lvt_11_1_ : Lists.reverse((List)lvt_9_3_)) {
                    lvt_5_1_.addStat(lvt_11_1_);
                }
            } else if (lvt_7_1_) {
                if (!lvt_5_1_.getStatFile().hasAchievementUnlocked(lvt_8_1_)) {
                    throw new CommandException("commands.achievement.dontHave", lvt_5_1_.getName(), lvt_4_1_.createChatComponent());
                }
                ArrayList lvt_9_4_ = Lists.newArrayList((Iterator)Iterators.filter(AchievementList.ACHIEVEMENTS.iterator(), (Predicate)new Predicate<Achievement>(){

                    public boolean apply(Achievement p_apply_1_) {
                        return lvt_5_1_.getStatFile().hasAchievementUnlocked(p_apply_1_) && p_apply_1_ != lvt_4_1_;
                    }

                    public /* synthetic */ boolean apply(Object p_apply_1_) {
                        return this.apply((Achievement)p_apply_1_);
                    }
                }));
                ArrayList lvt_10_1_ = Lists.newArrayList((Iterable)lvt_9_4_);
                Iterator iterator = lvt_9_4_.iterator();
                while (iterator.hasNext()) {
                    Achievement lvt_12_1_;
                    Achievement lvt_13_1_ = lvt_12_1_ = (Achievement)iterator.next();
                    boolean lvt_14_1_ = false;
                    while (lvt_13_1_ != null) {
                        if (lvt_13_1_ == lvt_4_1_) {
                            lvt_14_1_ = true;
                        }
                        lvt_13_1_ = lvt_13_1_.parentAchievement;
                    }
                    if (lvt_14_1_) continue;
                    lvt_13_1_ = lvt_12_1_;
                    while (lvt_13_1_ != null) {
                        lvt_10_1_.remove(lvt_12_1_);
                        lvt_13_1_ = lvt_13_1_.parentAchievement;
                    }
                }
                for (Achievement lvt_12_2_ : lvt_10_1_) {
                    lvt_5_1_.takeStat(lvt_12_2_);
                }
            }
        }
        if (lvt_6_1_) {
            lvt_5_1_.addStat(lvt_4_1_);
            CommandAchievement.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.achievement.give.success.one", lvt_5_1_.getName(), lvt_4_1_.createChatComponent());
        } else if (lvt_7_1_) {
            lvt_5_1_.takeStat(lvt_4_1_);
            CommandAchievement.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.achievement.take.success.one", lvt_4_1_.createChatComponent(), lvt_5_1_.getName());
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer p_getTabCompletions_1_, ICommandSender p_getTabCompletions_2_, String[] p_getTabCompletions_3_, BlockPos p_getTabCompletions_4_) {
        if (p_getTabCompletions_3_.length == 1) {
            return CommandAchievement.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, "give", "take");
        }
        if (p_getTabCompletions_3_.length == 2) {
            ArrayList lvt_5_1_ = Lists.newArrayList();
            for (StatBase statBase : AchievementList.ACHIEVEMENTS) {
                lvt_5_1_.add(statBase.statId);
            }
            return CommandAchievement.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, lvt_5_1_);
        }
        if (p_getTabCompletions_3_.length == 3) {
            return CommandAchievement.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, p_getTabCompletions_1_.getOnlinePlayerNames());
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(String[] p_isUsernameIndex_1_, int p_isUsernameIndex_2_) {
        return p_isUsernameIndex_2_ == 2;
    }
}

