/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.server;

import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.UserListIPBansEntry;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;

public class CommandBanIp
extends CommandBase {
    public static final Pattern IP_PATTERN = Pattern.compile("^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$");

    @Override
    public String getName() {
        return "ban-ip";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 3;
    }

    @Override
    public boolean checkPermission(MinecraftServer p_checkPermission_1_, ICommandSender p_checkPermission_2_) {
        return p_checkPermission_1_.getPlayerList().getBannedIPs().isLanServer() && super.checkPermission(p_checkPermission_1_, p_checkPermission_2_);
    }

    @Override
    public String getUsage(ICommandSender p_getUsage_1_) {
        return "commands.banip.usage";
    }

    @Override
    public void execute(MinecraftServer p_execute_1_, ICommandSender p_execute_2_, String[] p_execute_3_) throws CommandException {
        if (p_execute_3_.length < 1 || p_execute_3_[0].length() <= 1) {
            throw new WrongUsageException("commands.banip.usage", new Object[0]);
        }
        ITextComponent lvt_4_1_ = p_execute_3_.length >= 2 ? CommandBanIp.getChatComponentFromNthArg(p_execute_2_, p_execute_3_, 1) : null;
        Matcher lvt_5_1_ = IP_PATTERN.matcher(p_execute_3_[0]);
        if (lvt_5_1_.matches()) {
            this.banIp(p_execute_1_, p_execute_2_, p_execute_3_[0], lvt_4_1_ == null ? null : lvt_4_1_.getUnformattedText());
        } else {
            EntityPlayerMP lvt_6_1_ = p_execute_1_.getPlayerList().getPlayerByUsername(p_execute_3_[0]);
            if (lvt_6_1_ == null) {
                throw new PlayerNotFoundException("commands.banip.invalid");
            }
            this.banIp(p_execute_1_, p_execute_2_, lvt_6_1_.getPlayerIP(), lvt_4_1_ == null ? null : lvt_4_1_.getUnformattedText());
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer p_getTabCompletions_1_, ICommandSender p_getTabCompletions_2_, String[] p_getTabCompletions_3_, BlockPos p_getTabCompletions_4_) {
        if (p_getTabCompletions_3_.length == 1) {
            return CommandBanIp.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, p_getTabCompletions_1_.getOnlinePlayerNames());
        }
        return Collections.emptyList();
    }

    protected void banIp(MinecraftServer p_banIp_1_, ICommandSender p_banIp_2_, String p_banIp_3_, String p_banIp_4_) {
        UserListIPBansEntry lvt_5_1_ = new UserListIPBansEntry(p_banIp_3_, null, p_banIp_2_.getName(), null, p_banIp_4_);
        p_banIp_1_.getPlayerList().getBannedIPs().addEntry(lvt_5_1_);
        List<EntityPlayerMP> lvt_6_1_ = p_banIp_1_.getPlayerList().getPlayersMatchingAddress(p_banIp_3_);
        Object[] lvt_7_1_ = new String[lvt_6_1_.size()];
        int lvt_8_1_ = 0;
        for (EntityPlayerMP lvt_10_1_ : lvt_6_1_) {
            lvt_10_1_.connection.disconnect("You have been IP banned.");
            lvt_7_1_[lvt_8_1_++] = lvt_10_1_.getName();
        }
        if (lvt_6_1_.isEmpty()) {
            CommandBanIp.notifyCommandListener(p_banIp_2_, (ICommand)this, "commands.banip.success", p_banIp_3_);
        } else {
            CommandBanIp.notifyCommandListener(p_banIp_2_, (ICommand)this, "commands.banip.success.players", p_banIp_3_, CommandBanIp.joinNiceString(lvt_7_1_));
        }
    }
}

