/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.server;

import com.mojang.authlib.GameProfile;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.UserListBansEntry;
import net.minecraft.util.math.BlockPos;

public class CommandBanPlayer
extends CommandBase {
    @Override
    public String getName() {
        return "ban";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 3;
    }

    @Override
    public String getUsage(ICommandSender p_getUsage_1_) {
        return "commands.ban.usage";
    }

    @Override
    public boolean checkPermission(MinecraftServer p_checkPermission_1_, ICommandSender p_checkPermission_2_) {
        return p_checkPermission_1_.getPlayerList().getBannedPlayers().isLanServer() && super.checkPermission(p_checkPermission_1_, p_checkPermission_2_);
    }

    @Override
    public void execute(MinecraftServer p_execute_1_, ICommandSender p_execute_2_, String[] p_execute_3_) throws CommandException {
        if (p_execute_3_.length < 1 || p_execute_3_[0].length() <= 0) {
            throw new WrongUsageException("commands.ban.usage", new Object[0]);
        }
        GameProfile lvt_4_1_ = p_execute_1_.getPlayerProfileCache().getGameProfileForUsername(p_execute_3_[0]);
        if (lvt_4_1_ == null) {
            throw new CommandException("commands.ban.failed", p_execute_3_[0]);
        }
        String lvt_5_1_ = null;
        if (p_execute_3_.length >= 2) {
            lvt_5_1_ = CommandBanPlayer.getChatComponentFromNthArg(p_execute_2_, p_execute_3_, 1).getUnformattedText();
        }
        UserListBansEntry lvt_6_1_ = new UserListBansEntry(lvt_4_1_, null, p_execute_2_.getName(), null, lvt_5_1_);
        p_execute_1_.getPlayerList().getBannedPlayers().addEntry(lvt_6_1_);
        EntityPlayerMP lvt_7_1_ = p_execute_1_.getPlayerList().getPlayerByUsername(p_execute_3_[0]);
        if (lvt_7_1_ != null) {
            lvt_7_1_.connection.disconnect("You are banned from this server.");
        }
        CommandBanPlayer.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.ban.success", p_execute_3_[0]);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer p_getTabCompletions_1_, ICommandSender p_getTabCompletions_2_, String[] p_getTabCompletions_3_, BlockPos p_getTabCompletions_4_) {
        if (p_getTabCompletions_3_.length >= 1) {
            return CommandBanPlayer.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, p_getTabCompletions_1_.getOnlinePlayerNames());
        }
        return Collections.emptyList();
    }
}

